/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.options.customtypes;

import io.github.moulberry.notenoughupdates.util.NEUDebugLogger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum NEUDebugFlag {
    METAL("Metal Detector Solver"),
    WISHING("Wishing Compass Solver"),
    MAP("Dungeon Map Player Information"),
    SEARCH("SearchString Matches"),
    API_CACHE("Api Cache"),
    ALWAYS_EXPORT_SHOPS("Always export shops even without buy back slot");

    private final String description;

    private NEUDebugFlag(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void log(String message) {
        NEUDebugLogger.log(this, message);
    }

    public boolean isSet() {
        return NEUDebugLogger.isFlagEnabled(this);
    }

    public static String getFlagList() {
        return NEUDebugFlag.renderFlagInformation(Arrays.asList(NEUDebugFlag.values()));
    }

    public static String getEnabledFlags() {
        return NEUDebugFlag.renderFlagInformation(Arrays.stream(NEUDebugFlag.values()).filter(NEUDebugFlag::isSet).collect(Collectors.toList()));
    }

    public static String renderFlagInformation(List<NEUDebugFlag> flags) {
        int maxNameLength = flags.stream().mapToInt(it -> it.name().length()).max().orElse(0);
        return flags.stream().map(it -> String.format("%-" + maxNameLength + "s - %s", it.name(), it.getDescription())).collect(Collectors.joining("\n"));
    }
}

