/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.hypixelapi.ProfileCollectionInfo;
import java.awt.Color;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class CollectionsPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_cols = new ResourceLocation("notenoughupdates:pv_cols.png");
    private static final int COLLS_XCOUNT = 5;
    private static final int COLLS_YCOUNT = 4;
    private static final float COLLS_XPADDING = 15.0f;
    private static final float COLLS_YPADDING = 24.4f;
    private static final String[] romans = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XIX", "XX"};
    private static List<String> tooltipToDisplay = null;
    private static ItemStack selectedCollectionCategory = null;
    private int page = 0;
    private int maxPage = 0;

    public CollectionsPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int j;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_cols);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        JsonObject resourceCollectionInfo = ProfileViewer.getOrLoadCollectionsResource();
        if (resourceCollectionInfo == null) {
            return;
        }
        ProfileCollectionInfo collectionInfo = selectedProfile.getCollectionInfo();
        if (collectionInfo == null) {
            Utils.drawStringCentered(EnumChatFormatting.RED + "Collection API not enabled!", guiLeft + 134, guiTop + 101, true, 0);
            return;
        }
        int collectionCatSize = ProfileViewer.getCollectionCatToCollectionMap().size();
        int collectionCatYSize = (int)(162.0f / ((float)(collectionCatSize - 1) + 1.0E-7f));
        int yIndex = 0;
        for (ItemStack stack : ProfileViewer.getCollectionCatToCollectionMap().keySet()) {
            if (selectedCollectionCategory == null) {
                selectedCollectionCategory = stack;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            if (stack == selectedCollectionCategory) {
                Utils.drawTexturedRect(guiLeft + 7, guiTop + 10 + collectionCatYSize * yIndex, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
                Utils.drawItemStackWithText(stack, guiLeft + 10, guiTop + 13 + collectionCatYSize * yIndex, "" + (yIndex + 1));
            } else {
                Utils.drawTexturedRect(guiLeft + 7, guiTop + 10 + collectionCatYSize * yIndex, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
                Utils.drawItemStackWithText(stack, guiLeft + 9, guiTop + 12 + collectionCatYSize * yIndex, "" + (yIndex + 1));
            }
            ++yIndex;
        }
        List<String> collections = ProfileViewer.getCollectionCatToCollectionMap().get(selectedCollectionCategory);
        List<String> minions = ProfileViewer.getCollectionCatToMinionMap().get(selectedCollectionCategory);
        this.maxPage = Math.max((collections != null ? collections.size() : 0) / 20, (minions != null ? minions.size() : 0) / 20);
        if (this.maxPage != 0) {
            boolean leftHovered = false;
            boolean rightHovered = false;
            if (Mouse.isButtonDown((int)0) && mouseY > guiTop + 6 && mouseY < guiTop + 22) {
                if (mouseX > guiLeft + 100 - 20 - 12 && mouseX < guiLeft + 100 - 20) {
                    leftHovered = true;
                } else if (mouseX > guiLeft + 100 + 20 + 250 && mouseX < guiLeft + 100 + 20 + 12 + 250) {
                    rightHovered = true;
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.resource_packs);
            if (this.page > 0) {
                Utils.drawTexturedRect(guiLeft + 100 - 15 - 12, guiTop + 6, 12.0f, 16.0f, 0.11328125f, 0.20703125f, !leftHovered ? 0.0f : 0.125f, !leftHovered ? 0.125f : 0.25f, 9728);
            }
            if (this.page < 1) {
                Utils.drawTexturedRect(guiLeft + 100 + 15 + 250, guiTop + 6, 12.0f, 16.0f, 0.01953125f, 0.11328125f, !rightHovered ? 0.0f : 0.125f, !rightHovered ? 0.125f : 0.25f, 9728);
            }
        }
        Utils.drawStringCentered(selectedCollectionCategory.func_82833_r() + " Collections", guiLeft + 134, guiTop + 14, true, 0x404040);
        if (collections != null) {
            int i = this.page * 20;
            j = 0;
            while (i < Math.min((this.page + 1) * 20, collections.size())) {
                String collection = collections.get(i);
                if (collection != null) {
                    ProfileCollectionInfo.CollectionInfo thisCollection = collectionInfo.getCollections().get(collection);
                    if (thisCollection == null) {
                        Utils.showOutdatedRepoNotification("hypixel api collection info");
                    } else {
                        ItemStack collectionItem = ProfileViewer.getCollectionToCollectionDisplayMap().get(collection);
                        if (collectionItem != null) {
                            int xIndex = j % 5;
                            int yIndex2 = j / 5;
                            float x = 54.0f + 35.0f * (float)xIndex;
                            float y = 31.4f + 44.4f * (float)yIndex2;
                            int tier = thisCollection.getUnlockedTiers().size();
                            String tierString = tier > 20 || tier == 0 ? String.valueOf(tier) : romans[tier - 1];
                            BigInteger amount = thisCollection.getTotalCollectionCount();
                            BigInteger maxAmount = BigInteger.valueOf(thisCollection.getCollection().getTiers().get(thisCollection.getCollection().getTiers().size() - 1).getAmountRequired());
                            Color color = new Color(128, 128, 128, 255);
                            int tierStringColour = color.getRGB();
                            float completedness = 0.0f;
                            if (maxAmount.compareTo(BigInteger.ZERO) > 0) {
                                completedness = amount.compareTo(maxAmount) > 0 ? 1.0f : amount.floatValue() / maxAmount.floatValue();
                            }
                            if (completedness >= 1.0f) {
                                tierStringColour = new Color(255, 215, 0).getRGB();
                            }
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                            Utils.drawTexturedRect((float)guiLeft + x, (float)guiTop + y, 20.0f, 20.0f * (1.0f - completedness), 0.0f, 0.078125f, 0.0f, 20.0f * (1.0f - completedness) / 256.0f, 9728);
                            GlStateManager.func_179131_c((float)1.0f, (float)0.7254902f, (float)0.0f, (float)1.0f);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                            Utils.drawTexturedRect((float)guiLeft + x, (float)guiTop + y + 20.0f * (1.0f - completedness), 20.0f, 20.0f * completedness, 0.0f, 0.078125f, 20.0f * (1.0f - completedness) / 256.0f, 0.078125f, 9728);
                            Utils.drawItemStack(collectionItem, guiLeft + (int)x + 2, guiTop + (int)y + 2);
                            if (mouseX > guiLeft + (int)x + 2 && mouseX < guiLeft + (int)x + 18 && mouseY > guiTop + (int)y + 2 && mouseY < guiTop + (int)y + 18) {
                                tooltipToDisplay = new ArrayList<String>();
                                tooltipToDisplay.add(collectionItem.func_82833_r() + " " + (completedness >= 1.0f ? EnumChatFormatting.GOLD : EnumChatFormatting.GRAY) + tierString);
                                tooltipToDisplay.add("Collected: " + StringUtils.formatNumber(thisCollection.getPersonalCollectionCount()));
                                tooltipToDisplay.add("Total Collected: " + StringUtils.formatNumber(amount));
                            }
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            Utils.drawStringCentered(tierString, (float)guiLeft + x + 10.0f, (float)guiTop + y - 4.0f, true, tierStringColour);
                            Utils.drawStringCentered(StringUtils.shortNumberFormat(amount), (float)guiLeft + x + 10.0f, (float)guiTop + y + 26.0f, true, color.getRGB());
                        }
                    }
                }
                ++i;
                ++j;
            }
        }
        Utils.drawStringCentered(selectedCollectionCategory.func_82833_r() + " Minions", guiLeft + 326, guiTop + 14, true, 0x404040);
        if (minions != null) {
            int i = this.page * 20;
            j = 0;
            while (i < Math.min((this.page + 1) * 20, minions.size())) {
                String minion = minions.get(i);
                if (minion != null) {
                    JsonObject misc = Constants.MISC;
                    float MAX_MINION_TIER = Utils.getElementAsFloat(Utils.getElement(misc, "minions." + minion + "_GENERATOR"), 11.0f);
                    int tier = collectionInfo.getCraftedGenerators().getOrDefault(minion, 0);
                    JsonObject minionJson = tier == 0 ? NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(minion + "_GENERATOR_1") : NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(minion + "_GENERATOR_" + tier);
                    if (minionJson != null) {
                        int xIndex = j % 5;
                        int yIndex3 = j / 5;
                        float x = 246.0f + 35.0f * (float)xIndex;
                        float y = 31.4f + 44.4f * (float)yIndex3;
                        String tierString = tier - 1 >= romans.length || tier - 1 < 0 ? String.valueOf(tier) : romans[tier - 1];
                        Color color = new Color(128, 128, 128, 255);
                        int tierStringColour = color.getRGB();
                        float completedness = (float)tier / MAX_MINION_TIER;
                        if ((completedness = Math.min(1.0f, completedness)) >= 1.0f) {
                            tierStringColour = new Color(255, 215, 0).getRGB();
                        }
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                        Utils.drawTexturedRect((float)guiLeft + x, (float)guiTop + y, 20.0f, 20.0f * (1.0f - completedness), 0.0f, 0.078125f, 0.0f, 20.0f * (1.0f - completedness) / 256.0f, 9728);
                        GlStateManager.func_179131_c((float)1.0f, (float)0.7254902f, (float)0.0f, (float)1.0f);
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                        Utils.drawTexturedRect((float)guiLeft + x, (float)guiTop + y + 20.0f * (1.0f - completedness), 20.0f, 20.0f * completedness, 0.0f, 0.078125f, 20.0f * (1.0f - completedness) / 256.0f, 0.078125f, 9728);
                        Utils.drawItemStack(NotEnoughUpdates.INSTANCE.manager.jsonToStack(minionJson), guiLeft + (int)x + 2, guiTop + (int)y + 2);
                        if (mouseX > guiLeft + (int)x + 2 && mouseX < guiLeft + (int)x + 18 && mouseY > guiTop + (int)y + 2 && mouseY < guiTop + (int)y + 18) {
                            tooltipToDisplay = NotEnoughUpdates.INSTANCE.manager.jsonToStack(minionJson).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                        }
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (tier >= 0) {
                            Utils.drawStringCentered(tierString, (float)guiLeft + x + 10.0f, (float)guiTop + y - 4.0f, true, tierStringColour);
                        }
                    }
                }
                ++i;
                ++j;
            }
        }
        if (tooltipToDisplay != null) {
            ArrayList<String> grayTooltip = new ArrayList<String>(tooltipToDisplay.size());
            for (String line : tooltipToDisplay) {
                grayTooltip.add(EnumChatFormatting.GRAY + line);
            }
            Utils.drawHoveringText(grayTooltip, mouseX, mouseY, this.getInstance().field_146294_l, this.getInstance().field_146295_m, -1);
            tooltipToDisplay = null;
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        ItemStack stack = null;
        Iterator<ItemStack> items2 = ProfileViewer.getCollectionCatToCollectionMap().keySet().iterator();
        switch (keyCode) {
            case 7: 
            case 77: {
                items2.next();
            }
            case 6: 
            case 76: {
                items2.next();
            }
            case 5: 
            case 75: {
                items2.next();
            }
            case 4: 
            case 81: {
                items2.next();
            }
            case 3: 
            case 80: {
                items2.next();
            }
            case 2: 
            case 79: {
                stack = items2.next();
            }
        }
        if (stack != null) {
            selectedCollectionCategory = stack;
            this.page = 0;
        }
        Utils.playPressSound();
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        if (this.maxPage != 0 && mouseY > guiTop + 6 && mouseY < guiTop + 22) {
            if (mouseX > guiLeft + 100 - 15 - 12 && mouseX < guiLeft + 100 - 20) {
                if (this.page > 0) {
                    --this.page;
                    return;
                }
            } else if (mouseX > guiLeft + 100 + 15 + 250 && mouseX < guiLeft + 100 + 20 + 12 + 250 && this.page < 1) {
                ++this.page;
                return;
            }
        }
        int collectionCatSize = ProfileViewer.getCollectionCatToCollectionMap().size();
        int collectionCatYSize = (int)(162.0f / ((float)(collectionCatSize - 1) + 1.0E-7f));
        int yIndex = 0;
        for (ItemStack stack : ProfileViewer.getCollectionCatToCollectionMap().keySet()) {
            if (mouseX > guiLeft + 7 && mouseX < guiLeft + 7 + 20 && mouseY > guiTop + 10 + collectionCatYSize * yIndex && mouseY < guiTop + 10 + collectionCatYSize * yIndex + 20) {
                selectedCollectionCategory = stack;
                this.page = 0;
                Utils.playPressSound();
                return;
            }
            ++yIndex;
        }
    }
}

