/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.ClipboardUtils;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Bootstrap;

public class CrashRecoveryPage
extends GuiProfileViewerPage {
    private final Exception exception;
    private final String timestamp;
    private final GuiProfileViewer.ProfileViewerPage lastViewedPage;
    private int offset = 0;
    private final CrashReport crashReport;

    public CrashRecoveryPage(GuiProfileViewer instance, Exception exception, GuiProfileViewer.ProfileViewerPage lastViewedPage) {
        super(instance);
        this.lastViewedPage = lastViewedPage;
        this.timestamp = DateTimeFormatter.ISO_ZONED_DATE_TIME.format(OffsetDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
        this.exception = exception;
        SkyblockProfiles profile = GuiProfileViewer.getProfile();
        this.crashReport = new CrashReport("NEU Profile Viewer crashed", (Throwable)exception);
        CrashReportCategory parameters = this.crashReport.func_85058_a("Profile Viewer Parameters");
        parameters.func_71507_a("Viewed Player", (Object)this.getInstance().getEntityPlayer().func_70005_c_());
        parameters.func_71507_a("Viewed Player UUID", (Object)(profile == null ? "null" : profile.getUuid()));
        parameters.func_71507_a("Viewed Profile", (Object)GuiProfileViewer.getProfileName());
        parameters.func_71507_a("Timestamp", (Object)this.timestamp);
        parameters.func_71507_a("Last Viewed Page", (Object)lastViewedPage);
        if (NotEnoughUpdates.INSTANCE.manager.onBackupRepo) {
            parameters.func_71507_a("Repo Commit", (Object)"Using Backup");
        } else {
            parameters.func_71507_a("Repo Commit", (Object)NotEnoughUpdates.INSTANCE.manager.latestRepoCommit);
        }
        Bootstrap.func_179870_a((String)this.crashReport.func_71502_e());
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)GuiProfileViewer.getGuiLeft() + (float)this.getInstance().sizeX / 2.0f), (float)(GuiProfileViewer.getGuiTop() + 20), (float)0.0f);
        this.offset = 20;
        this.drawTitle();
        this.drawString("\u00a7cLooks like your profile viewer crashed.");
        this.drawString("\u00a7cPlease immediately send a screenshot of this screen into #neu-support.");
        this.drawString("\u00a7cJoin our support server at \u00a7a" + Utils.getDiscordInvite() + "\u00a7c.");
        SkyblockProfiles profile = GuiProfileViewer.getProfile();
        this.drawString("Viewed Player: " + this.getInstance().getEntityPlayer().func_70005_c_());
        this.drawString("Viewed Player UUID: " + (profile == null ? "null" : profile.getUuid()));
        this.drawString("Viewed Profile: " + GuiProfileViewer.getProfileName());
        this.drawString("Timestamp: " + this.timestamp);
        this.drawString("");
        this.drawString(this.exception.toString());
        for (StackTraceElement stackTraceElement : this.exception.getStackTrace()) {
            if (this.offset >= this.getInstance().sizeY - 50) break;
            this.drawString(stackTraceElement.toString());
        }
        GlStateManager.func_179121_F();
        Rectangle buttonCoords = this.getButtonCoordinates();
        RenderUtils.drawFloatingRectWithAlpha(buttonCoords.getX(), buttonCoords.getY(), buttonCoords.getWidth(), buttonCoords.getHeight(), 100, true);
        Utils.drawStringCenteredScaledMaxWidth("Copy Report", buttonCoords.getCenterX(), buttonCoords.getCenterY(), false, buttonCoords.getWidth(), -1);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.getButtonCoordinates().contains(mouseX, mouseY) && mouseButton == 0) {
            ClipboardUtils.copyToClipboard(this.crashReport.func_71502_e());
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private Rectangle getButtonCoordinates() {
        return new Rectangle(GuiProfileViewer.getGuiLeft() + this.getInstance().sizeX / 2 - 40, GuiProfileViewer.getGuiTop() + this.getInstance().sizeY - 30, 80, 12);
    }

    private void drawString(String text) {
        Utils.drawStringCenteredScaledMaxWidth(text, 0.0f, 0.0f, false, this.getInstance().sizeX - 20, -1);
        int spacing = Minecraft.func_71410_x().field_71466_p.field_78288_b + 2;
        GlStateManager.func_179109_b((float)0.0f, (float)spacing, (float)0.0f);
        this.offset += spacing;
    }

    private void drawTitle() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        Utils.drawStringCenteredScaledMaxWidth("\u00a7cKA-BOOM!", 0.0f, 0.0f, false, this.getInstance().sizeX / 2, -1);
        GlStateManager.func_179121_F();
        int spacing = Minecraft.func_71410_x().field_71466_p.field_78288_b * 2 + 6;
        GlStateManager.func_179109_b((float)0.0f, (float)spacing, (float)0.0f);
        this.offset += spacing;
    }
}

