/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.HoppityPage;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Mouse;

public class ExtraPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_extra = new ResourceLocation("notenoughupdates:pv_extra.png");
    private static final List<String> skills = Arrays.asList("taming", "mining", "foraging", "enchanting", "farming", "combat", "fishing", "alchemy", "carpentry");
    private TreeMap<Integer, Set<String>> topKills = null;
    private TreeMap<Integer, Set<String>> topDeaths = null;
    private int deathScroll = 0;
    private int killScroll = 0;
    private boolean clickedLoadGuildInfoButton = false;
    private final HoppityPage hoppityPage;
    public static final ItemStack hoppitySkull = Utils.createSkull("calmwolfs", "d7ac85e6-bd40-359e-a2c5-86082959309e", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWE4MTUzOThlN2RhODliMWJjMDhmNjQ2Y2FmYzhlN2I4MTNkYTBiZTBlZWMwY2NlNmQzZWZmNTIwNzgwMTAyNiJ9fX0=");
    private static final LinkedHashMap<String, ItemStack> pageModeIcon = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("stats", Utils.editItemStackInfo(new ItemStack(Items.field_151122_aG), EnumChatFormatting.GRAY + "Stats", true, new String[0]));
            this.put("hoppity", Utils.editItemStackInfo(hoppitySkull, EnumChatFormatting.GRAY + "Hoppity", true, new String[0]));
        }
    };

    public ExtraPage(GuiProfileViewer instance) {
        super(instance);
        this.hoppityPage = new HoppityPage(instance);
        this.getInstance().killDeathSearchTextField.setSize(80, 12);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        super.keyTyped(typedChar, keyCode);
        if (this.getInstance().killDeathSearchTextField.getFocus()) {
            this.getInstance().killDeathSearchTextField.keyTyped(typedChar, keyCode);
            this.killScroll = 0;
            this.deathScroll = 0;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int i = ProfileViewerUtils.onSlotToChangePage(mouseX, mouseY, guiLeft, guiTop);
        switch (i) {
            case 1: {
                GuiProfileViewer.onSecondPage = false;
                break;
            }
            case 2: {
                GuiProfileViewer.onSecondPage = true;
                break;
            }
        }
        if (GuiProfileViewer.onSecondPage) {
            return this.hoppityPage.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (mouseX >= GuiProfileViewer.getGuiLeft() + 22 + 309 && mouseX <= GuiProfileViewer.getGuiLeft() + 22 + 309 + 80 && mouseY >= GuiProfileViewer.getGuiTop() + 105 + 77 && mouseY <= GuiProfileViewer.getGuiTop() + 105 + 77 + 12) {
            this.getInstance().killDeathSearchTextField.mouseClicked(mouseX, mouseY, mouseButton);
            this.getInstance().playerNameTextField.otherComponentClick();
            return true;
        }
        this.getInstance().killDeathSearchTextField.otherComponentClick();
        return false;
    }

    public void drawEssence(JsonObject profileInfo2, float xStart, float yStartTop, float xOffset, float yOffset, float mouseX, float mouseY) {
        if (Constants.PARENTS == null || !Constants.PARENTS.has("ESSENCE_WITHER")) {
            Utils.showOutdatedRepoNotification("parents.json or missing ESSENCE_WITHER");
            return;
        }
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        yStartTop += 77.0f;
        JsonArray essenceArray = new JsonArray();
        essenceArray.addAll(Constants.PARENTS.get("ESSENCE_WITHER").getAsJsonArray());
        essenceArray.add(new JsonPrimitive("ESSENCE_WITHER"));
        for (int i = 0; i < essenceArray.size(); ++i) {
            JsonElement jsonElement = essenceArray.get(i);
            String essenceName = jsonElement.getAsString();
            TreeMap<String, JsonObject> itemInformation = NotEnoughUpdates.INSTANCE.manager.getItemInformation();
            if (!itemInformation.containsKey(essenceName)) {
                Utils.showOutdatedRepoNotification(essenceName);
                return;
            }
            String displayName = itemInformation.get(essenceName).getAsJsonObject().get("displayname").getAsString();
            int essenceNumber = Utils.getElementAsInt(Utils.getElement(profileInfo2, "currencies.essence." + essenceName.replace("ESSENCE_", "") + ".current"), 0);
            Utils.renderAlignedString(EnumChatFormatting.GOLD + displayName, EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(essenceNumber, 0), (float)guiLeft + xStart + xOffset, (float)guiTop + yStartTop + (yOffset - 1.0f) * (float)i, 76);
            if (Constants.ESSENCESHOPS == null) {
                return;
            }
            JsonObject essenceShops = Constants.ESSENCESHOPS;
            if (!(mouseX >= (float)guiLeft + xStart + xOffset) || !(mouseX <= (float)guiLeft + xStart + xOffset + 76.0f) || !(mouseY >= (float)guiTop + yStartTop + (yOffset - 1.0f) * (float)i) || !(mouseY <= (float)guiTop + yStartTop + (yOffset - 1.0f) * (float)i + 10.0f)) continue;
            this.getInstance().tooltipToDisplay = new ArrayList<String>();
            if (essenceShops.get(essenceName) == null) continue;
            for (Map.Entry<String, JsonElement> entry : essenceShops.get(essenceName).getAsJsonObject().entrySet()) {
                int max2;
                int perkTier = Utils.getElementAsInt(Utils.getElement(profileInfo2, "player_data.perks." + entry.getKey()), 0);
                EnumChatFormatting formatting = perkTier == (max2 = entry.getValue().getAsJsonObject().get("costs").getAsJsonArray().size()) ? EnumChatFormatting.GREEN : EnumChatFormatting.AQUA;
                String name = entry.getValue().getAsJsonObject().get("name").getAsString();
                this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GOLD + name + ": " + formatting + perkTier + "/" + max2);
            }
        }
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int deathsMaxScroll;
        int killsMaxScroll;
        Object name;
        JsonPrimitive prim;
        JsonObject stats;
        boolean shouldRenderGuild;
        JsonObject guildInfo;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        this.drawSideButtons(mouseX, mouseY);
        if (GuiProfileViewer.onSecondPage) {
            this.hoppityPage.drawPage(mouseX, mouseY, partialTicks);
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_extra);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        JsonObject profileInfo2 = selectedProfile.getProfileJson();
        Map<String, ProfileViewer.Level> skyblockInfo = selectedProfile.getLevelingInfo();
        APIDataJson data = selectedProfile.getAPIDataJson();
        if (data == null) {
            return;
        }
        APIDataJson.Player_Stats player_stats = data.player_stats;
        APIDataJson.Player_Stats.Auctions auctions = player_stats.auctions;
        float xStart = 22.0f;
        float xOffset = 103.0f;
        float yStartTop = 27.0f;
        float yStartBottom = 105.0f;
        float yOffset = 10.0f;
        float bankBalance = Utils.getElementAsFloat(Utils.getElement(selectedProfile.getOuterProfileJson(), "banking.balance"), 0.0f);
        float purseBalance = data.currencies.coin_purse;
        float personalBankBalance = data.profile.bank_account;
        Utils.renderAlignedString(EnumChatFormatting.GOLD + "Bank", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(bankBalance) + "/" + StringUtils.shortNumberFormat(personalBankBalance), (float)guiLeft + xStart, (float)guiTop + yStartTop, 76);
        Utils.renderAlignedString(EnumChatFormatting.GOLD + "Purse", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(purseBalance), (float)guiLeft + xStart, (float)guiTop + yStartTop + yOffset, 76);
        String first_join = this.getTimeSinceString(profileInfo2, "profile.first_join");
        if (first_join != null) {
            Utils.renderAlignedString(EnumChatFormatting.AQUA + "Joined", EnumChatFormatting.WHITE + first_join, (float)guiLeft + xStart, (float)guiTop + yStartTop + yOffset * 2.0f, 76);
        }
        if (GuiProfileViewer.getProfile().isPlayerInGuild()) {
            guildInfo = this.clickedLoadGuildInfoButton ? GuiProfileViewer.getProfile().getOrLoadGuildInformation(null) : null;
        } else {
            guildInfo = new JsonObject();
            guildInfo.add("name", new JsonPrimitive("N/A"));
        }
        boolean bl = shouldRenderGuild = guildInfo != null && guildInfo.has("name");
        if (shouldRenderGuild) {
            Utils.renderAlignedString(EnumChatFormatting.AQUA + "Guild", EnumChatFormatting.WHITE + guildInfo.get("name").getAsString(), (float)guiLeft + xStart, (float)guiTop + yStartTop + yOffset * 3.0f, 76);
        } else {
            Rectangle buttonRect = new Rectangle((int)((float)guiLeft + xStart - 1.0f), (int)((float)guiTop + yStartTop + yOffset * 3.0f), 78, 12);
            RenderUtils.drawFloatingRectWithAlpha(buttonRect.getX(), buttonRect.getY(), buttonRect.getWidth(), buttonRect.getHeight(), 100, true);
            Utils.renderShadowedString(this.clickedLoadGuildInfoButton ? EnumChatFormatting.AQUA + "Loading..." : EnumChatFormatting.WHITE + "Load Guild Info", (float)guiLeft + xStart + 38.0f, (float)guiTop + yStartTop + yOffset * 3.0f + 2.0f, 70);
            if (Mouse.getEventButtonState() && Utils.isWithinRect(mouseX, mouseY, buttonRect)) {
                this.clickedLoadGuildInfoButton = true;
            }
        }
        GuiProfileViewer.pronouns.peekValue().flatMap(it -> it).ifPresent(choice -> Utils.renderAlignedString(EnumChatFormatting.GREEN + "Pronouns", EnumChatFormatting.WHITE + String.join((CharSequence)" / ", choice.render()), (float)guiLeft + xStart, (float)guiTop + yStartTop + yOffset * 4.0f + (float)(shouldRenderGuild ? 0 : 5), 76));
        int fairySouls = data.fairy_soul.total_collected;
        boolean cookieBuff = data.profile.cookie_buff_active;
        int fairySoulMax = 227;
        if (Constants.FAIRYSOULS != null && Constants.FAIRYSOULS.has("Max Souls")) {
            fairySoulMax = Constants.FAIRYSOULS.get("Max Souls").getAsInt();
        }
        Utils.renderAlignedString(EnumChatFormatting.LIGHT_PURPLE + "Fairy Souls", EnumChatFormatting.WHITE.toString() + fairySouls + "/" + fairySoulMax, (float)guiLeft + xStart, (float)guiTop + yStartBottom, 76);
        if (skyblockInfo != null) {
            float totalSkillLVL = 0.0f;
            float totalTrueSkillLVL = 0.0f;
            float totalSlayerLVL = 0.0f;
            float totalSkillCount = 0.0f;
            float totalSlayerCount = 0.0f;
            float totalSlayerXP = 0.0f;
            for (Map.Entry<String, ProfileViewer.Level> entry : skyblockInfo.entrySet()) {
                if (skills.contains(entry.getKey())) {
                    totalSkillLVL += entry.getValue().level;
                    totalTrueSkillLVL = (float)((double)totalTrueSkillLVL + Math.floor(entry.getValue().level));
                    totalSkillCount += 1.0f;
                    continue;
                }
                if (!Weight.SLAYER_NAMES.contains(entry.getKey())) continue;
                totalSlayerLVL += entry.getValue().level;
                totalSlayerCount += 1.0f;
                totalSlayerXP += entry.getValue().totalXp;
            }
            float avgSkillLVL = totalSkillLVL / totalSkillCount;
            float avgTrueSkillLVL = totalTrueSkillLVL / totalSkillCount;
            float avgSlayerLVL = totalSlayerLVL / totalSlayerCount;
            Utils.renderAlignedString(EnumChatFormatting.RED + "AVG Skill LVL", selectedProfile.skillsApiEnabled() ? EnumChatFormatting.WHITE.toString() + Math.floor(avgSkillLVL * 10.0f) / 10.0 : EnumChatFormatting.RED + "API OFF!", (float)guiLeft + xStart, (float)guiTop + yStartBottom + yOffset, 76);
            Utils.renderAlignedString(EnumChatFormatting.RED + "True AVG Skill LVL", selectedProfile.skillsApiEnabled() ? EnumChatFormatting.WHITE.toString() + Math.floor(avgTrueSkillLVL * 10.0f) / 10.0 : EnumChatFormatting.RED + "API OFF!", (float)guiLeft + xStart, (float)guiTop + yStartBottom + yOffset * 2.0f, 76);
            Utils.renderAlignedString(EnumChatFormatting.RED + "AVG Slayer LVL", EnumChatFormatting.WHITE.toString() + Math.floor(avgSlayerLVL * 10.0f) / 10.0, (float)guiLeft + xStart, (float)guiTop + yStartBottom + yOffset * 3.0f, 76);
            Utils.renderAlignedString(EnumChatFormatting.RED + "Total Slayer XP", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(totalSlayerXP), (float)guiLeft + xStart, (float)guiTop + yStartBottom + yOffset * 4.0f, 76);
            Utils.renderAlignedString(EnumChatFormatting.GOLD + "Cookie Buff", cookieBuff ? EnumChatFormatting.LIGHT_PURPLE + "Active" : EnumChatFormatting.RED + "Inactive", (float)guiLeft + xStart, (float)guiTop + yStartBottom + yOffset * 5.0f, 76);
        }
        float auctions_bids = auctions.bids;
        float auctions_highest_bid = auctions.highest_bid;
        float auctions_won = auctions.won;
        float auctions_created = auctions.created;
        float auctions_gold_spent = auctions.gold_spent;
        float auctions_gold_earned = auctions.gold_earned;
        Utils.renderAlignedString(EnumChatFormatting.DARK_PURPLE + "Auction Bids", EnumChatFormatting.WHITE.toString() + (int)auctions_bids, (float)guiLeft + xStart + xOffset, (float)guiTop + yStartTop, 76);
        Utils.renderAlignedString(EnumChatFormatting.DARK_PURPLE + "Highest Bid", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(auctions_highest_bid), (float)guiLeft + xStart + xOffset, (float)guiTop + yStartTop + yOffset, 76);
        Utils.renderAlignedString(EnumChatFormatting.DARK_PURPLE + "Auctions Won", EnumChatFormatting.WHITE.toString() + (int)auctions_won, (float)guiLeft + xStart + xOffset, (float)guiTop + yStartTop + yOffset * 2.0f, 76);
        Utils.renderAlignedString(EnumChatFormatting.DARK_PURPLE + "Auctions Created", EnumChatFormatting.WHITE.toString() + (int)auctions_created, (float)guiLeft + xStart + xOffset, (float)guiTop + yStartTop + yOffset * 3.0f, 76);
        Utils.renderAlignedString(EnumChatFormatting.DARK_PURPLE + "Gold Spent", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(auctions_gold_spent), (float)guiLeft + xStart + xOffset, (float)guiTop + yStartTop + yOffset * 4.0f, 76);
        Utils.renderAlignedString(EnumChatFormatting.DARK_PURPLE + "Gold Earned", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(auctions_gold_earned), (float)guiLeft + xStart + xOffset, (float)guiTop + yStartTop + yOffset * 5.0f, 76);
        float pet_milestone_ores_mined = player_stats.pets.milestone.ores_mined;
        float pet_milestone_sea_creatures_killed = player_stats.pets.milestone.sea_creatures_killed;
        float items_fished = player_stats.items_fished.total;
        float items_fished_treasure = player_stats.items_fished.treasure;
        float items_fished_large_treasure = player_stats.items_fished.large_treasure;
        Utils.renderAlignedString(EnumChatFormatting.GREEN + "Ores Mined", EnumChatFormatting.WHITE.toString() + (int)pet_milestone_ores_mined, (float)guiLeft + xStart + xOffset * 2.0f, (float)guiTop + yStartTop, 76);
        Utils.renderAlignedString(EnumChatFormatting.GREEN + "Sea Creatures Killed", EnumChatFormatting.WHITE.toString() + (int)pet_milestone_sea_creatures_killed, (float)guiLeft + xStart + xOffset * 2.0f, (float)guiTop + yStartTop + yOffset, 76);
        Utils.renderAlignedString(EnumChatFormatting.GREEN + "Items Fished", EnumChatFormatting.WHITE.toString() + (int)items_fished, (float)guiLeft + xStart + xOffset * 2.0f, (float)guiTop + yStartTop + yOffset * 3.0f, 76);
        Utils.renderAlignedString(EnumChatFormatting.GREEN + "Treasures Fished", EnumChatFormatting.WHITE.toString() + (int)items_fished_treasure, (float)guiLeft + xStart + xOffset * 2.0f, (float)guiTop + yStartTop + yOffset * 4.0f, 76);
        Utils.renderAlignedString(EnumChatFormatting.GREEN + "Large Treasures", EnumChatFormatting.WHITE.toString() + (int)items_fished_large_treasure, (float)guiLeft + xStart + xOffset * 2.0f, (float)guiTop + yStartTop + yOffset * 5.0f, 76);
        this.drawEssence(selectedProfile.getProfileJson(), xStart, yStartTop, xOffset, yOffset, mouseX, mouseY);
        if (this.topKills == null) {
            this.topKills = new TreeMap();
            stats = Utils.getElementOrDefault(profileInfo2, "player_stats.kills", new JsonObject()).getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : stats.entrySet()) {
                if (!entry.getValue().isJsonPrimitive() || !(prim = (JsonPrimitive)entry.getValue()).isNumber()) continue;
                name = WordUtils.capitalizeFully((String)entry.getKey().replace("_", " "));
                Set kills = this.topKills.computeIfAbsent(prim.getAsInt(), k -> new HashSet());
                kills.add(name);
            }
        }
        if (this.topDeaths == null) {
            this.topDeaths = new TreeMap();
            stats = Utils.getElementOrDefault(profileInfo2, "player_stats.deaths", new JsonObject()).getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : stats.entrySet()) {
                if (!entry.getValue().isJsonPrimitive() || !(prim = (JsonPrimitive)entry.getValue()).isNumber()) continue;
                name = WordUtils.capitalizeFully((String)entry.getKey().replace("_", " "));
                Set deaths = this.topDeaths.computeIfAbsent(prim.getAsInt(), k -> new HashSet());
                deaths.add(name);
            }
        }
        this.getInstance().killDeathSearchTextField.render((int)((float)guiLeft + xStart + xOffset * 3.0f), (int)((float)guiTop + yStartBottom + 77.0f));
        float killDeathX = (float)guiLeft + xStart + xOffset * 3.0f;
        int indexKills = 0;
        int skipCountKills = 0;
        int renderedKills = 0;
        name = this.topKills.descendingKeySet().iterator();
        while (name.hasNext()) {
            int killCount = (Integer)name.next();
            Set<String> kills = this.topKills.get(killCount);
            for (String killType : kills) {
                boolean isSearch = this.getInstance().killDeathSearchTextField.getText().isEmpty() || killType.toLowerCase(Locale.ROOT).contains(this.getInstance().killDeathSearchTextField.getText().toLowerCase(Locale.ROOT));
                float killY = (float)guiTop + yStartTop + yOffset * (float)(indexKills - skipCountKills - this.killScroll);
                if (!isSearch) {
                    ++skipCountKills;
                }
                if (isSearch && killY + 6.0f < (float)guiTop + yStartTop + 75.0f && killY >= (float)guiTop + yStartTop) {
                    ++renderedKills;
                    Utils.renderAlignedString(EnumChatFormatting.YELLOW + "K: " + killType, EnumChatFormatting.WHITE.toString() + killCount, killDeathX, killY, 76);
                }
                ++indexKills;
            }
        }
        int indexDeaths = 0;
        int skipCountDeaths = 0;
        int renderedDeaths = 0;
        Iterator<Object> iterator = this.topDeaths.descendingKeySet().iterator();
        while (iterator.hasNext()) {
            int deathCount = (Integer)iterator.next();
            Set<String> deaths = this.topDeaths.get(deathCount);
            for (String deathType : deaths) {
                boolean isSearch = this.getInstance().killDeathSearchTextField.getText().isEmpty() || deathType.toLowerCase(Locale.ROOT).contains(this.getInstance().killDeathSearchTextField.getText().toLowerCase(Locale.ROOT));
                float deathY = (float)guiTop + yStartBottom + yOffset * (float)(indexDeaths - skipCountDeaths - this.deathScroll);
                if (!isSearch) {
                    ++skipCountDeaths;
                }
                if (isSearch && deathY + 6.0f < (float)guiTop + yStartBottom + 75.0f && deathY >= (float)guiTop + yStartBottom) {
                    ++renderedDeaths;
                    Utils.renderAlignedString(EnumChatFormatting.YELLOW + "D: " + deathType, EnumChatFormatting.WHITE.toString() + deathCount, killDeathX, deathY, 76);
                }
                ++indexDeaths;
            }
        }
        int mouseDWheel = Mouse.getDWheel();
        if ((float)mouseX >= killDeathX && (float)mouseX <= killDeathX + 76.0f) {
            if ((float)mouseY >= (float)guiTop + yStartTop && (float)mouseY <= (float)guiTop + yStartTop + 65.0f) {
                if (mouseDWheel > 0) {
                    --this.killScroll;
                } else if (mouseDWheel < 0) {
                    ++this.killScroll;
                }
                if (this.killScroll < 0) {
                    this.killScroll = 0;
                }
            } else if ((float)mouseY >= (float)guiTop + yStartBottom && (float)mouseY <= (float)guiTop + yStartBottom + 65.0f) {
                if (mouseDWheel > 0) {
                    --this.deathScroll;
                } else if (mouseDWheel < 0) {
                    ++this.deathScroll;
                }
                if (this.deathScroll < 0) {
                    this.deathScroll = 0;
                }
            }
        }
        if (this.killScroll > (killsMaxScroll = indexKills - skipCountKills - renderedKills)) {
            this.killScroll = killsMaxScroll;
        }
        if (this.deathScroll > (deathsMaxScroll = indexDeaths - skipCountDeaths - renderedDeaths)) {
            this.deathScroll = deathsMaxScroll;
        }
    }

    private String getTimeSinceString(JsonObject profileInfo2, String path) {
        JsonElement lastSaveElement = Utils.getElement(profileInfo2, path);
        if (lastSaveElement != null && lastSaveElement.isJsonPrimitive()) {
            return Utils.timeSinceMillisecond(lastSaveElement.getAsLong());
        }
        return null;
    }

    @Override
    public void resetCache() {
        this.topDeaths = null;
        this.topKills = null;
    }

    private void drawSideButtons(int mouseX, int mouseY) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        if (GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("hoppity"), true, this.getInstance(), mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("stats"), true, this.getInstance(), mouseX, mouseY);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
        if (!GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("hoppity"), false, this.getInstance(), mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("stats"), false, this.getInstance(), mouseX, mouseY);
        }
        GlStateManager.func_179097_i();
    }
}

