/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.SacksPage;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.PlayerStats;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.info.QuiverInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class InventoriesPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_invs = new ResourceLocation("notenoughupdates:pv_invs.png");
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    private static final Pattern FISHING_SPEED_PATTERN = Pattern.compile("^Fishing Speed: \\+(\\d+)");
    private static final LinkedHashMap<String, ItemStack> invNameToDisplayMap = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("inv_contents", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150486_ae), EnumChatFormatting.GRAY + "Inventory", new String[0]));
            this.put("ender_chest_contents", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150477_bB), EnumChatFormatting.GRAY + "Ender Chest", new String[0]));
            this.put("backpack_contents", Utils.editItemStackInfo(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("JUMBO_BACKPACK")), EnumChatFormatting.GRAY + "Backpacks", true, new String[0]));
            this.put("personal_vault_contents", Utils.editItemStackInfo(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("IRON_CHEST")), EnumChatFormatting.GRAY + "Personal Vault", true, new String[0]));
            this.put("talisman_bag", Utils.createItemStack(Items.field_151153_ao, EnumChatFormatting.GRAY + "Accessory Bag", new String[0]));
            this.put("wardrobe_contents", Utils.createItemStack((Item)Items.field_151027_R, EnumChatFormatting.GRAY + "Wardrobe", new String[0]));
            this.put("fishing_bag", Utils.createItemStack(Items.field_151115_aP, EnumChatFormatting.GRAY + "Fishing Bag", new String[0]));
            this.put("potion_bag", Utils.createItemStack((Item)Items.field_151068_bn, EnumChatFormatting.GRAY + "Potion Bag", new String[0]));
        }
    };
    private final ItemStack fillerStack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150397_co), 1, 15);
    private HashMap<String, ItemStack[][][]> inventoryItems = new HashMap();
    private ItemStack[] bestWeapons = null;
    private ItemStack[] bestRods = null;
    private ItemStack[] armorItems = null;
    private ItemStack[] equipmentItems = null;
    private String selectedInventory = "inv_contents";
    private int currentInventoryIndex = 0;
    private int arrowCount = -1;
    private int greenCandyCount = -1;
    private int purpleCandyCount = -1;
    public static final HashMap<String, String> apiStatNames = new HashMap<String, String>(){
        {
            this.put("health", "\u00a7c\u2764 Health");
            this.put("defense", "\u00a7a\u2748 Defense");
            this.put("walk_speed", "\u00a7f\u2726 Speed");
            this.put("strength", "\u00a7c\u2741 Strength");
            this.put("critical_damage", "\u00a79\u2620 Crit Damage");
            this.put("critical_chance", "\u00a79\u2623 Crit Chance");
            this.put("attack_speed", "\u00a7e\u2694 Bonus Attack Speed");
            this.put("intelligence", "\u00a7b\u270e Intelligence");
        }
    };
    public static final HashMap<String, Float> tuningCoefficients = new HashMap<String, Float>(){
        {
            this.put("health", Float.valueOf(5.0f));
            this.put("defense", Float.valueOf(1.0f));
            this.put("walk_speed", Float.valueOf(1.5f));
            this.put("strength", Float.valueOf(1.0f));
            this.put("critical_damage", Float.valueOf(1.0f));
            this.put("critical_chance", Float.valueOf(0.2f));
            this.put("attack_speed", Float.valueOf(0.3f));
            this.put("intelligence", Float.valueOf(2.0f));
        }
    };
    private final SacksPage sacksPage = new SacksPage(this.getInstance());
    private static final LinkedHashMap<String, ItemStack> pageModeIcon = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("inventories", Utils.editItemStackInfo(new ItemStack(Items.field_151159_an), EnumChatFormatting.GRAY + "Inventories", true, new String[0]));
            this.put("sacks", Utils.editItemStackInfo(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("LARGE_ENCHANTED_MINING_SACK")), EnumChatFormatting.GRAY + "Sacks", true, new String[0]));
        }
    };

    public InventoriesPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int i;
        int y;
        int x;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        this.drawSideButtons(mouseX, mouseY);
        if (GuiProfileViewer.onSecondPage) {
            this.sacksPage.drawPage(mouseX, mouseY, partialTicks);
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_invs);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        this.getInstance().inventoryTextField.setSize(88, 20);
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        Map<String, JsonArray> inventoryInfo = selectedProfile.getInventoryInfo();
        int invNameIndex = 0;
        for (Map.Entry<String, ItemStack> entry : invNameToDisplayMap.entrySet()) {
            int xIndex = invNameIndex % 3;
            int yIndex = invNameIndex / 3;
            x = 19 + 34 * xIndex;
            y = 26 + 34 * yIndex;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            if (entry.getKey().equals(this.selectedInventory)) {
                Utils.drawTexturedRect(guiLeft + x - 2, guiTop + y - 2, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
                ++x;
                ++y;
            } else {
                Utils.drawTexturedRect(guiLeft + x - 2, guiTop + y - 2, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
            }
            Utils.drawItemStackWithText(entry.getValue(), guiLeft + x, guiTop + y, String.valueOf(invNameIndex + 1), true);
            if (mouseX >= guiLeft + x && mouseX <= guiLeft + x + 16 && mouseY >= guiTop + y && mouseY <= guiTop + y + 16) {
                this.getInstance().tooltipToDisplay = entry.getValue().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                if (Objects.equals(entry.getKey(), "talisman_bag")) {
                    StringBuilder magicalPowerString = new StringBuilder(EnumChatFormatting.DARK_GRAY + "Magical Power: ");
                    int magicalPower = this.getSelectedProfile().getMagicalPower();
                    this.getInstance().tooltipToDisplay.add(magicalPower == -1 ? magicalPowerString.append(EnumChatFormatting.RED).append("Error while calculating!").toString() : magicalPowerString.append(EnumChatFormatting.GOLD).append(StringUtils.formatNumber(magicalPower)).toString());
                    StringBuilder selectedPowerString = new StringBuilder(EnumChatFormatting.DARK_GRAY + "Selected Power: ");
                    String selectedPower = PlayerStats.getSelectedMagicalPower(this.getSelectedProfile().getProfileJson());
                    this.getInstance().tooltipToDisplay.add(selectedPower == null ? selectedPowerString.append(EnumChatFormatting.RED).append("None!").toString() : selectedPowerString.append(EnumChatFormatting.GREEN).append(selectedPower).toString());
                    LinkedHashMap<String, Integer> tuningInfo = this.getSelectedProfile().getTuningInfo();
                    if (tuningInfo != null && tuningInfo.size() > 0) {
                        this.getInstance().tooltipToDisplay.add("");
                        this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GRAY + "Tuning:");
                        tuningInfo.forEach((statName, statPoints) -> {
                            if (statPoints != 0) {
                                this.getInstance().tooltipToDisplay.add("  " + apiStatNames.get(statName) + ": +" + new DecimalFormat("#.#").format((float)statPoints.intValue() * tuningCoefficients.getOrDefault(statName, Float.valueOf(1.0f)).floatValue()) + EnumChatFormatting.DARK_GRAY + " (" + EnumChatFormatting.YELLOW + statPoints + EnumChatFormatting.DARK_GRAY + " points)");
                            }
                        });
                    }
                }
            }
            ++invNameIndex;
        }
        this.getInstance().inventoryTextField.render(guiLeft + 19, guiTop + this.getInstance().sizeY - 26 - 20);
        if (this.armorItems == null) {
            this.armorItems = new ItemStack[4];
            JsonArray armor = inventoryInfo.get("inv_armor");
            for (int i2 = 0; i2 < armor.size(); ++i2) {
                if (armor.get(i2) == null || !armor.get(i2).isJsonObject()) continue;
                this.armorItems[i2] = NotEnoughUpdates.INSTANCE.manager.jsonToStack(armor.get(i2).getAsJsonObject(), false);
            }
        }
        for (int i3 = 0; i3 < this.armorItems.length; ++i3) {
            ItemStack stack = this.armorItems[i3];
            if (stack == null) continue;
            Utils.drawItemStack(stack, guiLeft + 173, guiTop + 67 - 18 * i3, true);
            if (stack == this.fillerStack || mouseX < guiLeft + 173 - 1 || mouseX > guiLeft + 173 + 16 + 1 || mouseY < guiTop + 67 - 18 * i3 - 1 || mouseY > guiTop + 67 - 18 * i3 + 16 + 1) continue;
            this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (this.equipmentItems == null) {
            this.equipmentItems = new ItemStack[4];
            JsonArray equippment = inventoryInfo.get("equipment_contents");
            for (int i4 = 0; i4 < equippment.size(); ++i4) {
                if (equippment.get(i4) == null || !equippment.get(i4).isJsonObject()) continue;
                this.equipmentItems[i4] = NotEnoughUpdates.INSTANCE.manager.jsonToStack(equippment.get(i4).getAsJsonObject(), false);
            }
        }
        for (int i5 = 0; i5 < this.equipmentItems.length; ++i5) {
            ItemStack stack = this.equipmentItems[i5];
            if (stack == null) continue;
            Utils.drawItemStack(stack, guiLeft + 192, guiTop + 13 + 18 * i5, true);
            if (stack == this.fillerStack || mouseX < guiLeft + 192 - 1 || mouseX > guiLeft + 192 + 16 + 1 || mouseY < guiTop + 13 + 18 * i5 - 1 || mouseY > guiTop + 13 + 18 * i5 + 16 + 1) continue;
            this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        ItemStack[][][] inventories = this.getItemsForInventory(inventoryInfo, this.selectedInventory);
        if (this.currentInventoryIndex >= inventories.length) {
            this.currentInventoryIndex = inventories.length - 1;
        }
        if (this.currentInventoryIndex < 0) {
            this.currentInventoryIndex = 0;
        }
        ItemStack[][] inventory = inventories[this.currentInventoryIndex];
        if (this.bestWeapons == null) {
            this.bestWeapons = this.findBestItems(inventoryInfo, 6, new String[]{"inv_contents", "ender_chest_contents"}, new String[]{"SWORD", "BOW"}, new Pattern[0]);
        }
        if (this.bestRods == null) {
            this.bestRods = this.findBestItems(inventoryInfo, 3, new String[]{"inv_contents", "ender_chest_contents"}, new String[]{"FISHING ROD", "FISHING WEAPON"}, FISHING_SPEED_PATTERN);
        }
        for (i = 0; i < this.bestWeapons.length; ++i) {
            if (this.bestWeapons[i] == null) continue;
            ItemStack stack = this.bestWeapons[i];
            Utils.drawItemStack(stack, guiLeft + 143, guiTop + 13 + 18 * i, true);
            if (mouseX < guiLeft + 143 - 1 || mouseX > guiLeft + 143 + 16 + 1 || mouseY < guiTop + 13 + 18 * i - 1 || mouseY > guiTop + 13 + 18 * i + 16 + 1) continue;
            this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        for (i = 0; i < this.bestRods.length; ++i) {
            if (this.bestRods[i] == null) continue;
            ItemStack stack = this.bestRods[i];
            Utils.drawItemStack(stack, guiLeft + 143, guiTop + 137 + 18 * i, true);
            if (mouseX < guiLeft + 143 - 1 || mouseX > guiLeft + 143 + 16 + 1 || mouseY < guiTop + 137 + 18 * i - 1 || mouseY > guiTop + 137 + 18 * i + 16 + 1) continue;
            this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (this.arrowCount == -1) {
            this.arrowCount = this.countItemsInInventory("ARROW", inventoryInfo, false, "quiver");
        }
        if (this.greenCandyCount == -1) {
            this.greenCandyCount = this.countItemsInInventory("GREEN_CANDY", inventoryInfo, true, "candy_inventory_contents");
        }
        if (this.purpleCandyCount == -1) {
            this.purpleCandyCount = this.countItemsInInventory("PURPLE_CANDY", inventoryInfo, true, "candy_inventory_contents");
        }
        Utils.drawItemStackWithText(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("ARROW")), guiLeft + 173, guiTop + 101, String.valueOf(this.arrowCount > 999 ? StringUtils.shortNumberFormat(this.arrowCount) : Integer.valueOf(this.arrowCount)), true);
        Utils.drawItemStackWithText(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("GREEN_CANDY")), guiLeft + 173, guiTop + 119, String.valueOf(this.greenCandyCount), true);
        Utils.drawItemStackWithText(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("PURPLE_CANDY")), guiLeft + 173, guiTop + 137, String.valueOf(this.purpleCandyCount), true);
        if (mouseX > guiLeft + 173 && mouseX < guiLeft + 173 + 16 && mouseY > guiTop + 101 && mouseY < guiTop + 137 + 16) {
            QuiverInfo quiverInfo;
            this.getInstance().tooltipToDisplay = mouseY < guiTop + 101 + 17 ? ((quiverInfo = PlayerStats.getQuiverInfo(inventoryInfo, this.getSelectedProfile().getProfileJson())) == null ? Utils.createList(EnumChatFormatting.RED + "Error checking Quiver") : quiverInfo.generateProfileViewerTooltip()) : (mouseY < guiTop + 119 + 17 ? Utils.createList(EnumChatFormatting.GREEN + "Green Candy " + EnumChatFormatting.GRAY + "x" + this.greenCandyCount) : Utils.createList(EnumChatFormatting.DARK_PURPLE + "Purple Candy " + EnumChatFormatting.GRAY + "x" + this.purpleCandyCount));
        }
        if (inventory == null) {
            String strToRender = "Inventory API not enabled!";
            if (this.selectedInventory.equalsIgnoreCase("personal_vault_contents")) {
                strToRender = "Personal Vault API not enabled!";
            } else if (this.selectedInventory.equalsIgnoreCase("backpack_contents")) {
                strToRender = "Inventory API not enabled";
                Utils.drawStringCentered(EnumChatFormatting.RED + "Or has no backpacks!", guiLeft + 317, guiTop + 112, true, 0);
            }
            Utils.drawStringCentered(EnumChatFormatting.RED + strToRender, guiLeft + 317, guiTop + 101, true, 0);
            return;
        }
        int inventoryRows = inventory.length;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
        int invSizeY = inventoryRows * 18 + 17 + 7;
        x = guiLeft + 320 - 88;
        y = guiTop + 101 - invSizeY / 2;
        int staticSelectorHeight = guiTop + 177;
        this.getInstance().func_73729_b(x, y, 0, 0, 176, inventoryRows * 18 + 17);
        this.getInstance().func_73729_b(x, y + inventoryRows * 18 + 17, 0, 215, 176, 7);
        boolean leftHovered = false;
        boolean rightHovered = false;
        if (Mouse.isButtonDown((int)0) && mouseY > staticSelectorHeight && mouseY < staticSelectorHeight + 16 && mouseX > guiLeft + 320 - 12 && mouseX < guiLeft + 320 + 12) {
            if (mouseX < guiLeft + 320) {
                leftHovered = true;
            } else {
                rightHovered = true;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.resource_packs);
        if (this.currentInventoryIndex > 0) {
            Utils.drawTexturedRect(guiLeft + 320 - 12, staticSelectorHeight, 12.0f, 16.0f, 0.11328125f, 0.20703125f, !leftHovered ? 0.0f : 0.125f, !leftHovered ? 0.125f : 0.25f, 9728);
        }
        if (this.currentInventoryIndex < inventories.length - 1) {
            Utils.drawTexturedRect(guiLeft + 320, staticSelectorHeight, 12.0f, 16.0f, 0.01953125f, 0.11328125f, !rightHovered ? 0.0f : 0.125f, !rightHovered ? 0.125f : 0.25f, 9728);
        }
        if (inventories.length > 1) {
            String text = "Page " + (this.currentInventoryIndex + 1) + "/" + inventories.length;
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, guiLeft + 320 - Minecraft.func_71410_x().field_71466_p.func_78256_a(text) / 2, staticSelectorHeight - 10, 0x949494);
        }
        Minecraft.func_71410_x().field_71466_p.func_78276_b(Utils.cleanColour(invNameToDisplayMap.get(this.selectedInventory).func_82833_r()), x + 8, y + 6, 0x404040);
        ItemStack stackToRender = null;
        int overlay = new Color(0, 0, 0, 100).getRGB();
        for (int yIndex = 0; yIndex < inventory.length; ++yIndex) {
            if (inventory[yIndex] == null) continue;
            for (int xIndex = 0; xIndex < inventory[yIndex].length; ++xIndex) {
                ItemStack stack = inventory[yIndex][xIndex];
                if (stack != null) {
                    Utils.drawItemStack(stack, x + 8 + xIndex * 18, y + 18 + yIndex * 18, true);
                }
                if (!(this.getInstance().inventoryTextField.getText() == null || this.getInstance().inventoryTextField.getText().isEmpty() || stack != null && NotEnoughUpdates.INSTANCE.manager.doesStackMatchSearch(stack, this.getInstance().inventoryTextField.getText()))) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
                    GuiScreen.func_73734_a((int)(x + 8 + xIndex * 18), (int)(y + 18 + yIndex * 18), (int)(x + 8 + xIndex * 18 + 16), (int)(y + 18 + yIndex * 18 + 16), (int)overlay);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
                }
                if (stack == null || stack == this.fillerStack || mouseX < x + 8 + xIndex * 18 || mouseX > x + 8 + xIndex * 18 + 16 || mouseY < y + 18 + yIndex * 18 || mouseY > y + 18 + yIndex * 18 + 16) continue;
                stackToRender = stack;
            }
        }
        if (stackToRender != null) {
            this.getInstance().tooltipToDisplay = stackToRender.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        if (!GuiProfileViewer.onSecondPage) {
            this.getInstance().inventoryTextField.setSize(88, 20);
            if (mouseX > guiLeft + 19 && mouseX < guiLeft + 19 + 88 && mouseY > guiTop + this.getInstance().sizeY - 26 - 20 && mouseY < guiTop + this.getInstance().sizeY - 26) {
                this.getInstance().inventoryTextField.mouseClicked(mouseX, mouseY, mouseButton);
                this.getInstance().playerNameTextField.otherComponentClick();
                return true;
            }
        }
        int i = ProfileViewerUtils.onSlotToChangePage(mouseX, mouseY, guiLeft, guiTop);
        switch (i) {
            case 1: {
                GuiProfileViewer.onSecondPage = false;
                break;
            }
            case 2: {
                GuiProfileViewer.onSecondPage = true;
                break;
            }
        }
        return this.sacksPage.mouseClick(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        if (mouseButton == 0) {
            ItemStack[][] inventory;
            int i = 0;
            for (Map.Entry<String, ItemStack> entry : invNameToDisplayMap.entrySet()) {
                int xIndex = i % 3;
                int yIndex = i / 3;
                int x = guiLeft + 19 + 34 * xIndex;
                int y = guiTop + 26 + 34 * yIndex;
                if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
                    if (!this.selectedInventory.equals(entry.getKey())) {
                        Utils.playPressSound();
                    }
                    this.selectedInventory = entry.getKey();
                    return;
                }
                ++i;
            }
            SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
            if (selectedProfile == null) {
                return;
            }
            Map<String, JsonArray> inventoryInfo = selectedProfile.getInventoryInfo();
            if (inventoryInfo == null) {
                return;
            }
            ItemStack[][][] inventories = this.getItemsForInventory(inventoryInfo, this.selectedInventory);
            if (this.currentInventoryIndex >= inventories.length) {
                this.currentInventoryIndex = inventories.length - 1;
            }
            if (this.currentInventoryIndex < 0) {
                this.currentInventoryIndex = 0;
            }
            if ((inventory = inventories[this.currentInventoryIndex]) == null) {
                return;
            }
            int staticSelectorHeight = guiTop + 177;
            if (mouseY > staticSelectorHeight && mouseY < staticSelectorHeight + 16 && mouseX > guiLeft + 320 - 12 && mouseX < guiLeft + 320 + 12) {
                this.currentInventoryIndex = mouseX < guiLeft + 320 ? --this.currentInventoryIndex : ++this.currentInventoryIndex;
            }
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        switch (keyCode) {
            case 2: 
            case 79: {
                this.selectedInventory = "inv_contents";
                break;
            }
            case 3: 
            case 80: {
                this.selectedInventory = "ender_chest_contents";
                break;
            }
            case 4: 
            case 81: {
                this.selectedInventory = "backpack_contents";
                break;
            }
            case 5: 
            case 75: {
                this.selectedInventory = "personal_vault_contents";
                break;
            }
            case 6: 
            case 76: {
                this.selectedInventory = "talisman_bag";
                break;
            }
            case 7: 
            case 77: {
                this.selectedInventory = "wardrobe_contents";
                break;
            }
            case 8: 
            case 71: {
                this.selectedInventory = "fishing_bag";
                break;
            }
            case 9: 
            case 72: {
                this.selectedInventory = "potion_bag";
                break;
            }
            default: {
                this.getInstance().inventoryTextField.keyTyped(typedChar, keyCode);
                return;
            }
        }
        Utils.playPressSound();
        this.getInstance().inventoryTextField.keyTyped(typedChar, keyCode);
    }

    @Override
    public void resetCache() {
        this.inventoryItems = new HashMap();
        this.bestWeapons = null;
        this.bestRods = null;
        this.armorItems = null;
        this.equipmentItems = null;
        this.currentInventoryIndex = 0;
        this.arrowCount = -1;
        this.greenCandyCount = -1;
        this.purpleCandyCount = -1;
    }

    private int countItemsInInventory(String internalname, Map<String, JsonArray> inventoryInfo, boolean specific, String ... invsToSearch) {
        int count = 0;
        for (String inv : invsToSearch) {
            JsonArray invItems = inventoryInfo.get(inv).getAsJsonArray();
            for (int i = 0; i < invItems.size(); ++i) {
                if (invItems.get(i) == null || !invItems.get(i).isJsonObject()) continue;
                JsonObject item = invItems.get(i).getAsJsonObject();
                if ((!specific || !item.get("internalname").getAsString().equals(internalname)) && (specific || !item.get("internalname").getAsString().contains(internalname))) continue;
                if (item.has("count")) {
                    count += item.get("count").getAsInt();
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    private ItemStack[] findBestItems(Map<String, JsonArray> inventoryInfo, int numItems, String[] invsToSearch, String[] typeMatches, Pattern ... importantPatterns) {
        ItemStack[] bestItems = new ItemStack[numItems];
        TreeMap<Long, Set> map2 = new TreeMap<Long, Set>();
        for (String inv : invsToSearch) {
            JsonArray invItems = inventoryInfo.get(inv).getAsJsonArray();
            for (int i = 0; i < invItems.size(); ++i) {
                JsonObject item;
                JsonArray lore;
                if (invItems.get(i) == null || !invItems.get(i).isJsonObject() || Utils.checkItemType(lore = (item = invItems.get(i).getAsJsonObject()).get("lore").getAsJsonArray(), true, typeMatches) < 0) continue;
                long importance = 0L;
                int id = 0;
                if (importantPatterns.length == 0) {
                    String internalName = item.get("internalname").getAsString();
                    importance += NotEnoughUpdates.INSTANCE.manager.auctionManager.getLowestBin(internalName);
                    importance += (long)(++id);
                } else {
                    for (int j = 0; j < lore.size(); ++j) {
                        String line = lore.get(j).getAsString();
                        for (Pattern pattern : importantPatterns) {
                            Matcher matcher = pattern.matcher(Utils.cleanColour(line));
                            if (!matcher.find()) continue;
                            importance += (long)Integer.parseInt(matcher.group(1));
                        }
                    }
                }
                map2.computeIfAbsent(importance, k -> new HashSet()).add(NotEnoughUpdates.INSTANCE.manager.jsonToStack(item, false));
            }
        }
        int i = 0;
        Iterator iterator = map2.descendingKeySet().iterator();
        block4: while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            Set items2 = (Set)map2.get(key);
            for (JsonObject item : items2) {
                bestItems[i] = item;
                if (++i < bestItems.length) continue;
                break block4;
            }
        }
        return bestItems;
    }

    private ItemStack[][][] getItemsForInventory(Map<String, JsonArray> inventoryInfo, String invName) {
        int jsonInvSize;
        if (this.inventoryItems.containsKey(invName)) {
            return this.inventoryItems.get(invName);
        }
        JsonArray jsonInv = inventoryInfo.get(invName);
        if (jsonInv.size() == 0) {
            return new ItemStack[1][][];
        }
        if (this.useActualMax(invName)) {
            jsonInvSize = (int)Math.ceil((float)jsonInv.size() / 9.0f) * 9;
        } else {
            jsonInvSize = 36;
            float divideBy = 9.0f;
            if (invName.equals("wardrobe_contents")) {
                divideBy = 36.0f;
            }
            for (int i = 36; i < jsonInv.size(); ++i) {
                JsonElement item = jsonInv.get(i);
                if (item == null || !item.isJsonObject()) continue;
                jsonInvSize = (int)(Math.ceil((float)(i + 1) / divideBy) * (double)((int)divideBy));
            }
        }
        int rowSize = 9;
        int rows = jsonInvSize / rowSize;
        int maxRowsPerPage = this.getRowsForInventory(invName);
        int maxInvSize = rowSize * maxRowsPerPage;
        int numInventories = (jsonInvSize - 1) / maxInvSize + 1;
        JsonArray backpackSizes = inventoryInfo.get("backpack_sizes");
        if (invName.equals("backpack_contents")) {
            numInventories = backpackSizes.size();
        }
        ItemStack[][][] inventories = new ItemStack[numInventories][][];
        int startNumberJ = 0;
        for (int i = 0; i < numInventories; ++i) {
            int invSize;
            int thisRows = Math.min(maxRowsPerPage, rows - maxRowsPerPage * i);
            if (invName.equals("backpack_contents")) {
                thisRows = backpackSizes.get(i).getAsInt() / 9;
                invSize = startNumberJ + thisRows * 9;
                maxInvSize = thisRows * 9;
            } else {
                startNumberJ = maxInvSize * i;
                invSize = Math.min(jsonInvSize, maxInvSize + maxInvSize * i);
            }
            if (thisRows <= 0) break;
            ItemStack[][] items2 = new ItemStack[thisRows][rowSize];
            for (int j = startNumberJ; j < invSize; ++j) {
                int xIndex = j % maxInvSize % rowSize;
                int yIndex = j % maxInvSize / rowSize;
                if (invName.equals("inv_contents") && --yIndex < 0) {
                    yIndex = rows - 1;
                }
                if (yIndex >= thisRows) break;
                if (j >= jsonInv.size()) {
                    items2[yIndex][xIndex] = this.fillerStack;
                    continue;
                }
                if (jsonInv.get(j) == null || !jsonInv.get(j).isJsonObject()) continue;
                JsonObject item = jsonInv.get(j).getAsJsonObject();
                ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(item, false);
                if (item.has("item_contents")) {
                    JsonArray bytesArr = item.get("item_contents").getAsJsonArray();
                    byte[] bytes = new byte[bytesArr.size()];
                    for (int bytesArrI = 0; bytesArrI < bytesArr.size(); ++bytesArrI) {
                        bytes[bytesArrI] = bytesArr.get(bytesArrI).getAsByte();
                    }
                    NBTTagCompound tag = stack.func_77978_p();
                    if (tag != null && tag.func_150297_b("ExtraAttributes", 10)) {
                        NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
                        for (String key : ea.func_150296_c()) {
                            if (!key.endsWith("backpack_data") && !key.equals("new_year_cake_bag_data")) continue;
                            ea.func_74782_a(key, (NBTBase)new NBTTagByteArray(bytes));
                            break;
                        }
                        tag.func_74782_a("ExtraAttributes", (NBTBase)ea);
                        stack.func_77982_d(tag);
                    }
                }
                items2[yIndex][xIndex] = stack;
            }
            inventories[i] = items2;
            if (!invName.equals("backpack_contents")) continue;
            startNumberJ += backpackSizes.get(i).getAsInt();
        }
        this.inventoryItems.put(invName, inventories);
        return inventories;
    }

    private boolean useActualMax(String invName) {
        switch (invName) {
            case "talisman_bag": 
            case "fishing_bag": 
            case "potion_bag": 
            case "personal_vault_contents": {
                return true;
            }
        }
        return false;
    }

    private int getRowsForInventory(String invName) {
        switch (invName) {
            case "wardrobe_contents": {
                return 4;
            }
            case "backpack_contents": 
            case "ender_chest_contents": {
                return 5;
            }
        }
        return 6;
    }

    private void drawSideButtons(int mouseX, int mouseY) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        if (GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("sacks"), true, this.getInstance(), mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("inventories"), true, this.getInstance(), mouseX, mouseY);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
        if (!GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("sacks"), false, this.getInstance(), mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("inventories"), false, this.getInstance(), mouseX, mouseY);
        }
        GlStateManager.func_179097_i();
    }
}

