/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.ReplaceItemEvent;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.BetterContainers;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProfileViewerButton {
    private static final ItemStack profileViewerStack = Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150483_bI), EnumChatFormatting.GREEN + "Profile Viewer", EnumChatFormatting.YELLOW + "Click to open NEU profile viewer!");
    String username = "";
    int replaceSlot = -1;

    @SubscribeEvent
    public void onSlotClick(SlotClickEvent event) {
        if (!Utils.getOpenChestName().contains(" Profile") || event.guiContainer.field_147002_h.field_75151_b.size() < 54) {
            this.username = "";
            this.replaceSlot = -1;
            return;
        }
        if (!this.username.isEmpty() && event.slot.field_75222_d == this.replaceSlot && ProfileViewerButton.isReplacedStack(event.slot.func_75211_c())) {
            Utils.playPressSound();
            event.setCanceled(true);
            NotEnoughUpdates.profileViewer.loadPlayerByName(this.username, profile -> {
                if (profile == null) {
                    Utils.addChatMessage(EnumChatFormatting.RED + "Invalid player name. Maybe the API is down?");
                } else {
                    profile.resetCache();
                    ProfileViewerUtils.saveSearch(this.username);
                    NotEnoughUpdates.INSTANCE.openGui = new GuiProfileViewer((SkyblockProfiles)profile);
                }
            });
        }
    }

    @SubscribeEvent
    public void itemReplace(ReplaceItemEvent event) {
        ItemStack stack;
        if (event.getInventory() instanceof InventoryPlayer) {
            return;
        }
        if (!Utils.getOpenChestName().contains(" Profile")) {
            this.username = "";
            this.replaceSlot = -1;
            return;
        }
        if (this.replaceSlot == event.getSlotNumber()) {
            event.replaceWith(profileViewerStack);
        } else if (!this.username.isEmpty() && this.replaceSlot == -1 && event.getSlotNumber() > 9 && (event.getSlotNumber() % 9 == 6 || event.getSlotNumber() % 9 == 7) && BetterContainers.isBlankStack(-1, event.getOriginal())) {
            event.replaceWith(profileViewerStack);
            this.replaceSlot = event.getSlotNumber();
        } else if (event.getSlotNumber() == 22 && (stack = event.getOriginal()) != null && stack.func_77978_p() != null) {
            this.username = "";
            NBTTagCompound tag = stack.func_77978_p();
            String tagName = tag.func_74775_l("SkullOwner").func_74779_i("Name");
            String displayName = Utils.cleanColour(stack.func_82833_r());
            if (displayName.length() - tagName.length() >= 0 && tagName.equals(displayName.substring(displayName.length() - tagName.length()))) {
                this.username = tagName;
            }
        }
    }

    private static boolean isReplacedStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150483_bI);
    }
}

