/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.level.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.profileviewer.level.LevelPage;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.GuiTaskLevel;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.hypixelapi.ProfileCollectionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CoreTaskLevel
extends GuiTaskLevel {
    private final List<String> skills = Arrays.asList("taming", "mining", "foraging", "enchanting", "carpentry", "farming", "combat", "fishing", "alchemy");

    public CoreTaskLevel(LevelPage levelPage) {
        super(levelPage);
    }

    @Override
    public void drawTask(JsonObject object, int mouseX, int mouseY, int guiLeft, int guiTop) {
        JsonObject coreTask = this.levelPage.getConstant().get("core_task").getAsJsonObject();
        SkyblockProfiles.SkyblockProfile selectedProfile = GuiProfileViewer.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        APIDataJson data = selectedProfile.getAPIDataJson();
        if (data == null) {
            return;
        }
        Map<String, ProfileViewer.Level> skyblockInfo = selectedProfile.getLevelingInfo();
        int sbXpGainedSkillLVL = 0;
        if (skyblockInfo != null && selectedProfile.skillsApiEnabled()) {
            for (String skill : this.skills) {
                ProfileViewer.Level level = skyblockInfo.get(skill);
                int i = 1;
                while ((float)i <= level.level) {
                    if (i <= 10) {
                        sbXpGainedSkillLVL += 5;
                    }
                    if (i <= 25 && i > 10) {
                        sbXpGainedSkillLVL += 10;
                    }
                    if (i <= 50 && i > 25) {
                        sbXpGainedSkillLVL += 20;
                    }
                    if (i <= 60 && i > 50) {
                        sbXpGainedSkillLVL += 30;
                    }
                    ++i;
                }
            }
        } else {
            sbXpGainedSkillLVL = -1;
        }
        int sbXpGainedMp = 0;
        if (data.accessory_bag_storage != null) {
            sbXpGainedMp = data.accessory_bag_storage.highest_magical_power;
        }
        int petScore = data.leveling.highest_pet_score;
        int sbXpPetScore = petScore * coreTask.get("pet_score_xp").getAsInt();
        int sbXpGainedFairy = (data.fairy_soul.total_collected - data.fairy_soul.unspent_souls) / 5 * coreTask.get("fairy_souls_xp").getAsInt();
        int sbXpCollection = -1;
        int sbXpMinionTier = -1;
        JsonObject minionXp = Constants.MISC.get("minionXp").getAsJsonObject();
        int collectionsXp = coreTask.get("collections_xp").getAsInt();
        ProfileCollectionInfo collection = GuiProfileViewer.getSelectedProfile().getCollectionInfo();
        if (collection != null) {
            sbXpCollection = 0;
            for (Map.Entry<String, ProfileCollectionInfo.CollectionInfo> stringCollectionInfoEntry : collection.getCollections().entrySet()) {
                ProfileCollectionInfo.CollectionInfo value = stringCollectionInfoEntry.getValue();
                sbXpCollection += value.getUnlockedTiers().size() * collectionsXp;
            }
            Iterator<Object> iterator = collection.getCraftedGenerators().values().iterator();
            while (iterator.hasNext()) {
                int tier = (Integer)iterator.next();
                for (int i = 1; i <= tier; ++i) {
                    if (!minionXp.has(String.valueOf(i))) continue;
                    sbXpMinionTier += minionXp.get(String.valueOf(i)).getAsInt();
                }
            }
        }
        int sbXpBankUpgrades = 0;
        int sbXpTravelScroll = 0;
        if (object.has("leveling") && object.getAsJsonObject("leveling").has("completed_tasks")) {
            JsonArray completedTasks = object.getAsJsonObject("leveling").get("completed_tasks").getAsJsonArray();
            JsonObject bankUpgradesXp = coreTask.getAsJsonObject("bank_upgrades_xp");
            for (JsonElement completedTask : completedTasks) {
                String name = completedTask.getAsString();
                if (name.startsWith("FAST_TRAVEL_") && coreTask.has("fast_travel_unlocked_xp")) {
                    sbXpTravelScroll += coreTask.get("fast_travel_unlocked_xp").getAsInt();
                }
                if (!bankUpgradesXp.has(name)) continue;
                sbXpBankUpgrades += bankUpgradesXp.get(name).getAsInt();
            }
        }
        ArrayList<String> lore = new ArrayList<String>();
        int totalXp = sbXpGainedSkillLVL + sbXpGainedFairy + sbXpCollection + sbXpMinionTier + sbXpBankUpgrades + sbXpTravelScroll;
        lore.add(this.levelPage.buildLore("Skill Level Up", sbXpGainedSkillLVL, coreTask.get("skill_level_up").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Museum Progression", 0.0, 0.0, false));
        lore.add(this.levelPage.buildLore("Fairy Soul", sbXpGainedFairy, coreTask.get("fairy_souls").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Accessory Bag", sbXpGainedMp, 0.0, true));
        lore.add(this.levelPage.buildLore("Pet Score", sbXpPetScore, 0.0, true));
        lore.add(this.levelPage.buildLore("Collections", sbXpCollection, coreTask.get("collections").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Craft Minions", sbXpMinionTier, coreTask.get("craft_minions").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Bank Upgrade", sbXpBankUpgrades, coreTask.get("bank_upgrades").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Fast Travel Scroll", sbXpTravelScroll, coreTask.get("fast_travel_unlocked").getAsInt(), false));
        this.levelPage.renderLevelBar("Core Task", new ItemStack(Items.field_151156_bN), guiLeft + 23, guiTop + 25, 110, 0.0, totalXp, this.levelPage.getConstant().getAsJsonObject("category_xp").get("core_task").getAsInt(), mouseX, mouseY, true, lore);
    }
}

