/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.trophy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.trophy.TrophyFish;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TrophyFishPage
extends GuiProfileViewerPage {
    private static final Map<String, EnumChatFormatting> internalTrophyFish = new HashMap<String, EnumChatFormatting>(){
        {
            this.put("gusher", EnumChatFormatting.WHITE);
            this.put("flyfish", EnumChatFormatting.GREEN);
            this.put("moldfin", EnumChatFormatting.DARK_PURPLE);
            this.put("vanille", EnumChatFormatting.BLUE);
            this.put("blobfish", EnumChatFormatting.WHITE);
            this.put("mana_ray", EnumChatFormatting.BLUE);
            this.put("slugfish", EnumChatFormatting.GREEN);
            this.put("soul_fish", EnumChatFormatting.DARK_PURPLE);
            this.put("lava_horse", EnumChatFormatting.BLUE);
            this.put("golden_fish", EnumChatFormatting.GOLD);
            this.put("karate_fish", EnumChatFormatting.DARK_PURPLE);
            this.put("skeleton_fish", EnumChatFormatting.DARK_PURPLE);
            this.put("sulphur_skitter", EnumChatFormatting.WHITE);
            this.put("obfuscated_fish_1", EnumChatFormatting.WHITE);
            this.put("obfuscated_fish_2", EnumChatFormatting.GREEN);
            this.put("obfuscated_fish_3", EnumChatFormatting.BLUE);
            this.put("volcanic_stonefish", EnumChatFormatting.BLUE);
            this.put("steaming_hot_flounder", EnumChatFormatting.WHITE);
        }
    };
    private static final LinkedHashMap<ItemStack, Pair<String, Integer>> armorHelmets = new LinkedHashMap<ItemStack, Pair<String, Integer>>(){
        {
            this.put(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("BRONZE_HUNTER_HELMET")), Pair.of((Object)(EnumChatFormatting.GREEN + "Novice Fisher"), (Object)1));
            this.put(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("SILVER_HUNTER_HELMET")), Pair.of((Object)(EnumChatFormatting.BLUE + "Adept Fisher"), (Object)2));
            this.put(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("GOLD_HUNTER_HELMET")), Pair.of((Object)(EnumChatFormatting.DARK_PURPLE + "Expert Fisher"), (Object)3));
            this.put(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("DIAMOND_HUNTER_HELMET")), Pair.of((Object)(EnumChatFormatting.GOLD + "Master Fisher"), (Object)4));
        }
    };
    private static final Map<Integer, Pair<Integer, Integer>> slotLocations = new HashMap<Integer, Pair<Integer, Integer>>(){
        {
            this.put(0, Pair.of((Object)277, (Object)46));
            this.put(1, Pair.of((Object)253, (Object)58));
            this.put(2, Pair.of((Object)301, (Object)58));
            this.put(3, Pair.of((Object)229, (Object)70));
            this.put(4, Pair.of((Object)325, (Object)70));
            this.put(5, Pair.of((Object)277, (Object)70));
            this.put(6, Pair.of((Object)253, (Object)82));
            this.put(7, Pair.of((Object)301, (Object)82));
            this.put(8, Pair.of((Object)229, (Object)94));
            this.put(9, Pair.of((Object)325, (Object)94));
            this.put(10, Pair.of((Object)253, (Object)106));
            this.put(11, Pair.of((Object)301, (Object)106));
            this.put(12, Pair.of((Object)277, (Object)118));
            this.put(13, Pair.of((Object)229, (Object)118));
            this.put(14, Pair.of((Object)325, (Object)118));
            this.put(15, Pair.of((Object)253, (Object)130));
            this.put(16, Pair.of((Object)301, (Object)130));
            this.put(17, Pair.of((Object)277, (Object)142));
        }
    };
    private static final ResourceLocation TROPHY_FISH_TEXTURE = new ResourceLocation("notenoughupdates:pv_trophy_fish_tab.png");
    private static final String checkX = "\u00a7c\u2716";
    private static final String check = "\u00a7a\u2714";
    private final Map<String, Integer> total = new HashMap<String, Integer>();
    private final Map<String, TrophyFish> trophyFishList = new HashMap<String, TrophyFish>();
    private long totalCount = 0L;
    private static List<String> tooltipToDisplay = null;

    public TrophyFishPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int y;
        int x;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        this.trophyFishList.clear();
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        JsonObject profileInformation = selectedProfile.getProfileJson();
        if (profileInformation == null || !profileInformation.has("trophy_fish")) {
            Utils.drawStringCentered(EnumChatFormatting.RED + "No data found", (float)guiLeft + 215.5f, (float)(guiTop + 101), true, 0);
            return;
        }
        JsonObject trophyObject = profileInformation.getAsJsonObject("trophy_fish");
        this.loadTrophyInformation(trophyObject);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TROPHY_FISH_TEXTURE);
        Utils.drawTexturedRect(guiLeft, guiTop, 431.0f, 202.0f, 9728);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        RenderHelper.func_74520_c();
        int thunderKills = Utils.getElementAsInt(Utils.getElement(selectedProfile.getProfileJson(), "bestiary.kills.thunder_400"), 0);
        ItemStack thunder_sc = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("THUNDER_SC"));
        Minecraft.func_71410_x().func_175599_af().func_175042_a(thunder_sc, guiLeft + 16, guiTop + 108);
        Utils.drawStringF(EnumChatFormatting.AQUA + "Thunder Kills: \u00a7f" + thunderKills, guiLeft + 36, guiTop + 112, true, 0);
        ItemStack lord_jawbus_sc = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("LORD_JAWBUS_SC"));
        Minecraft.func_71410_x().func_175599_af().func_175042_a(lord_jawbus_sc, guiLeft + 16, guiTop + 120);
        int jawbusKills = Utils.getElementAsInt(Utils.getElement(selectedProfile.getProfileJson(), "bestiary.kills.lord_jawbus_600"), 0);
        Utils.drawStringF(EnumChatFormatting.AQUA + "Lord Jawbus Kills: \u00a7f" + jawbusKills, guiLeft + 36, guiTop + 124, true, 0);
        ItemStack fishing_rod = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("FISHING_ROD"));
        Minecraft.func_71410_x().func_175599_af().func_175042_a(fishing_rod, guiLeft + 20, guiTop + 21);
        Utils.drawStringF(EnumChatFormatting.AQUA + "Total Caught: \u00a7f" + this.totalCount, guiLeft + 38, guiTop + 25, true, 0);
        ArrayList<TrophyFish> arrayList = new ArrayList<TrophyFish>(this.trophyFishList.values());
        arrayList.sort((c1, c2) -> Integer.compare(c2.getTotal(), c1.getTotal()));
        for (TrophyFish trophyFish : arrayList) {
            x = guiLeft + (Integer)slotLocations.get(arrayList.indexOf(trophyFish)).getLeft();
            y = guiTop + (Integer)slotLocations.get(arrayList.indexOf(trophyFish)).getRight();
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            Map<TrophyFish.TrophyFishRarity, Integer> trophyFishRarityIntegerMap = trophyFish.getTrophyFishRarityIntegerMap();
            TrophyFish.TrophyFishRarity highestRarity = this.getHighestRarity(trophyFishRarityIntegerMap).orElse(null);
            if (highestRarity == TrophyFish.TrophyFishRarity.BRONZE) {
                GlStateManager.func_179131_c((float)1.0f, (float)0.50980395f, (float)0.0f, (float)1.0f);
            }
            if (highestRarity == TrophyFish.TrophyFishRarity.SILVER) {
                GlStateManager.func_179131_c((float)0.7529412f, (float)0.7529412f, (float)0.7529412f, (float)1.0f);
            }
            if (highestRarity == TrophyFish.TrophyFishRarity.GOLD) {
                GlStateManager.func_179131_c((float)1.0f, (float)0.82f, (float)0.0f, (float)1.0f);
            }
            if (highestRarity == TrophyFish.TrophyFishRarity.DIAMOND) {
                GlStateManager.func_179131_c((float)0.12156863f, (float)0.84705883f, (float)0.94509804f, (float)1.0f);
            }
            Utils.drawTexturedRect(x - 2, y - 2, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(this.getItem(trophyFish.getName(), highestRarity), x, y);
            if (mouseX < x || mouseX >= x + 24 || mouseY < y || mouseY > y + 24) continue;
            tooltipToDisplay = new ArrayList<String>();
            tooltipToDisplay.addAll(this.getTooltip(trophyFish.getName(), trophyFish.getTrophyFishRarityIntegerMap()));
        }
        if (arrayList.size() != internalTrophyFish.size()) {
            ArrayList<String> clonedList = new ArrayList<String>(internalTrophyFish.size());
            clonedList.addAll(internalTrophyFish.keySet());
            clonedList.removeAll(this.fixStringName(new ArrayList<String>(this.trophyFishList.keySet())));
            for (String difference : clonedList) {
                RenderHelper.func_74520_c();
                x = guiLeft + (Integer)slotLocations.get(clonedList.indexOf(difference) + this.trophyFishList.keySet().size()).getLeft();
                y = guiTop + (Integer)slotLocations.get(clonedList.indexOf(difference) + this.trophyFishList.keySet().size()).getRight();
                ItemStack itemStack = new ItemStack(Items.field_151100_aR, 1, 8);
                Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStack, x, y);
                if (mouseX >= x && mouseX < x + 24 && mouseY >= y && mouseY <= y + 24) {
                    tooltipToDisplay = new ArrayList<String>();
                    tooltipToDisplay.addAll(this.getTooltip(difference, null));
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                Utils.drawTexturedRect(x - 2, y - 2, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
            }
        }
        int[] trophiesPerTier = this.getTrophiesPerTier(trophyObject);
        JsonArray jsonArray = Utils.getElementOrDefault(selectedProfile.getProfileJson(), "trophy_fish.rewards", new JsonArray()).getAsJsonArray();
        int i = 0;
        for (ItemStack itemStack : armorHelmets.keySet()) {
            RenderHelper.func_74520_c();
            int integer = (Integer)armorHelmets.get(itemStack).getRight();
            x = guiLeft + 15;
            y = guiTop + 50 + i;
            Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStack, x, y);
            Utils.drawStringF((String)armorHelmets.get(itemStack).getLeft(), x + 20, y + 4, true, 0);
            int hasValue = trophiesPerTier[integer - 1];
            int neededValue = integer == 1 ? 15 : 18;
            String neededText = (hasValue == neededValue ? "\u00a7a" : "\u00a7c") + hasValue + "/" + neededValue;
            try {
                JsonElement jsonElement = jsonArray.get(integer - 1);
                if (!jsonElement.isJsonNull()) {
                    Utils.drawStringF(check, x + 100, y + 2, true, 0);
                } else {
                    Utils.drawStringF(neededText, x + 100, y + 4, true, 0);
                }
            }
            catch (IndexOutOfBoundsException exception) {
                Utils.drawStringF(neededText, x + 100, y + 4, true, 0);
            }
            i += 10;
        }
        if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.getInstance().field_146294_l, this.getInstance().field_146295_m, -1, Minecraft.func_71410_x().field_71466_p);
            tooltipToDisplay = null;
        }
        GlStateManager.func_179145_e();
    }

    private int[] getTrophiesPerTier(JsonObject trophyFish) {
        int[] trophiesPerTier = new int[]{0, 0, 0, 0};
        for (String fishType : internalTrophyFish.keySet()) {
            int highestTier = 0;
            if (trophyFish.has(fishType + "_bronze")) {
                highestTier = 1;
            }
            if (trophyFish.has(fishType + "_silver")) {
                highestTier = 2;
            }
            if (trophyFish.has(fishType + "_gold")) {
                highestTier = 3;
            }
            if (trophyFish.has(fishType + "_diamond")) {
                highestTier = 4;
            }
            if (highestTier >= 1) {
                trophiesPerTier[0] = trophiesPerTier[0] + 1;
            }
            if (highestTier >= 2) {
                trophiesPerTier[1] = trophiesPerTier[1] + 1;
            }
            if (highestTier >= 3) {
                trophiesPerTier[2] = trophiesPerTier[2] + 1;
            }
            if (highestTier < 4) continue;
            trophiesPerTier[3] = trophiesPerTier[3] + 1;
        }
        return trophiesPerTier;
    }

    private List<String> getTooltip(String name, Map<TrophyFish.TrophyFishRarity, Integer> trophyFishRarityIntegerMap) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(internalTrophyFish.get(name.toLowerCase(Locale.US).replace(" ", "_")) + WordUtils.capitalize((String)name.replace("_", " ")));
        List<String> lore = this.readLoreFromRepo(name.toUpperCase(Locale.US));
        List<String> description = this.readDescriptionFromLore(lore);
        tooltip.addAll(description);
        tooltip.add(" ");
        if (trophyFishRarityIntegerMap == null) {
            tooltip.add(EnumChatFormatting.RED + checkX + " Not Discovered");
            tooltip.add(" ");
        }
        tooltip.add(this.display(trophyFishRarityIntegerMap, TrophyFish.TrophyFishRarity.DIAMOND, EnumChatFormatting.AQUA));
        tooltip.add(this.display(trophyFishRarityIntegerMap, TrophyFish.TrophyFishRarity.GOLD, EnumChatFormatting.GOLD));
        tooltip.add(this.display(trophyFishRarityIntegerMap, TrophyFish.TrophyFishRarity.SILVER, EnumChatFormatting.GRAY));
        tooltip.add(this.display(trophyFishRarityIntegerMap, TrophyFish.TrophyFishRarity.BRONZE, EnumChatFormatting.DARK_GRAY));
        if (this.trophyFishList.get(name) != null) {
            tooltip.add(" ");
            tooltip.add(EnumChatFormatting.GRAY + "Total: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(this.trophyFishList.get(name).getTotal()));
        }
        return tooltip;
    }

    private String display(Map<TrophyFish.TrophyFishRarity, Integer> trophyFishRarityIntegerMap, TrophyFish.TrophyFishRarity rarity, EnumChatFormatting color) {
        String name = WordUtils.capitalize((String)rarity.name().toLowerCase(Locale.US));
        if (trophyFishRarityIntegerMap == null) {
            return color + name + ": " + checkX;
        }
        if (trophyFishRarityIntegerMap.containsKey((Object)rarity)) {
            return color + name + ": " + EnumChatFormatting.GOLD + StringUtils.formatNumber(trophyFishRarityIntegerMap.get((Object)rarity));
        }
        return color + name + ": " + checkX;
    }

    private Optional<TrophyFish.TrophyFishRarity> getHighestRarity(Map<TrophyFish.TrophyFishRarity, Integer> trophyFishRarityMap) {
        if (trophyFishRarityMap == null) {
            return Optional.empty();
        }
        return trophyFishRarityMap.keySet().stream().max(Comparator.comparing(Enum::ordinal));
    }

    private ItemStack getItem(String name, TrophyFish.TrophyFishRarity highestCaughtRarity) {
        String repoName = name.toUpperCase(Locale.US).replace(" ", "_") + "_" + (highestCaughtRarity == null ? "BRONZE" : highestCaughtRarity.name());
        JsonObject jsonItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(repoName);
        return NotEnoughUpdates.INSTANCE.manager.jsonToStack(jsonItem);
    }

    private void loadTrophyInformation(JsonObject trophyObject) {
        HashMap<String, List> trophyFishRarityIntegerMap = new HashMap<String, List>();
        this.totalCount = 0L;
        for (Map.Entry<String, JsonElement> stringJsonElementEntry : trophyObject.entrySet()) {
            TrophyFish.TrophyFishRarity trophyFishRarity;
            String key = stringJsonElementEntry.getKey();
            if (key.equalsIgnoreCase("rewards") || key.equalsIgnoreCase("total_caught") || key.equalsIgnoreCase("last_caught")) {
                if (!key.equalsIgnoreCase("total_caught")) continue;
                this.totalCount = stringJsonElementEntry.getValue().getAsInt();
                continue;
            }
            String[] s = key.split("_");
            String type2 = s[s.length - 1];
            int value = 0;
            try {
                value = stringJsonElementEntry.getValue().getAsInt();
            }
            catch (NumberFormatException e2) {
                value = -1;
            }
            if (key.startsWith("golden_fish_")) {
                type2 = s[2];
            }
            try {
                trophyFishRarity = TrophyFish.TrophyFishRarity.valueOf(type2.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException ignored) {
                this.total.put(WordUtils.capitalize((String)key), value);
                continue;
            }
            String replace = key.replace("_" + type2, "");
            String name2 = WordUtils.capitalize((String)replace);
            List pairs2 = trophyFishRarityIntegerMap.containsKey(name2) ? (List)trophyFishRarityIntegerMap.get(name2) : new ArrayList();
            pairs2.add(Pair.of((Object)((Object)trophyFishRarity), (Object)value));
            trophyFishRarityIntegerMap.put(name2, pairs2);
        }
        trophyFishRarityIntegerMap.forEach((name, pair) -> {
            if (!this.trophyFishList.containsKey(name)) {
                TrophyFish trophyFish = new TrophyFish((String)name, (Map<TrophyFish.TrophyFishRarity, Integer>)new HashMap<TrophyFish.TrophyFishRarity, Integer>());
                trophyFish.addTotal(this.total.get(name));
                for (Pair pair1 : pair) {
                    trophyFish.add((TrophyFish.TrophyFishRarity)((Object)((Object)pair1.getKey())), (Integer)pair1.getValue());
                }
                this.trophyFishList.put((String)name, trophyFish);
            } else {
                TrophyFish trophyFish = this.trophyFishList.get(name);
                for (Pair pair1 : pair) {
                    trophyFish.add((TrophyFish.TrophyFishRarity)((Object)((Object)pair1.getKey())), (Integer)pair1.getValue());
                }
            }
        });
    }

    private List<String> fixStringName(List<String> list) {
        ArrayList<String> fixedList = new ArrayList<String>();
        for (String s : list) {
            fixedList.add(s.toLowerCase(Locale.US).replace(" ", "_"));
        }
        return fixedList;
    }

    private List<String> readDescriptionFromLore(List<String> lore) {
        ArrayList<String> description = new ArrayList<String>();
        boolean found = false;
        for (String line : lore) {
            if (!found && line.startsWith("\u00a77")) {
                found = true;
            }
            if (found && line.isEmpty()) break;
            if (!found) continue;
            description.add(line);
        }
        return description;
    }

    private List<String> readLoreFromRepo(String name) {
        String repoName = name.toUpperCase(Locale.US).replace(" ", "_") + "_BRONZE";
        JsonObject jsonItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(repoName);
        ArrayList<String> list = new ArrayList<String>();
        if (jsonItem != null && jsonItem.has("lore")) {
            for (JsonElement line : jsonItem.getAsJsonArray("lore")) {
                list.add(line.getAsString());
            }
        }
        return list;
    }
}

