/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.weight.lily;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.weight.lily.LilyDungeonsWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.lily.LilySkillsWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.lily.LilySlayerWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import java.util.Map;

public class LilyWeight
extends Weight {
    public LilyWeight(Map<String, ProfileViewer.Level> player, JsonObject profileJson) {
        super(new LilySlayerWeight(player), new LilySkillsWeight(player), new LilyDungeonsWeight(player, profileJson));
    }

    @Override
    public void calculateWeight() {
        this.slayerWeight.getWeightStruct().reset();
        this.skillsWeight.getWeightStruct().reset();
        this.dungeonsWeight.getWeightStruct().reset();
        for (String slayerName : SLAYER_NAMES) {
            this.slayerWeight.getSlayerWeight(slayerName);
        }
        for (String skillName : SKILL_NAMES) {
            this.skillsWeight.getSkillsWeight(skillName);
        }
        this.dungeonsWeight.getDungeonWeight();
        ((LilyDungeonsWeight)this.dungeonsWeight).getDungeonCompletionWeight("normal");
        ((LilyDungeonsWeight)this.dungeonsWeight).getDungeonCompletionWeight("master");
    }
}

