/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.weight.weight;

import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.DungeonsWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.SkillsWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.SlayerWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.WeightStruct;
import java.util.Arrays;
import java.util.List;

public abstract class Weight {
    public static final List<String> SKILL_NAMES = Arrays.asList("taming", "mining", "foraging", "enchanting", "farming", "combat", "fishing", "alchemy");
    public static final List<String> SLAYER_NAMES = Arrays.asList("wolf", "zombie", "spider", "enderman", "blaze", "vampire");
    public static final List<String> DUNGEON_CLASS_NAMES = Arrays.asList("healer", "mage", "berserk", "archer", "tank");
    protected final SlayerWeight slayerWeight;
    protected final SkillsWeight skillsWeight;
    protected final DungeonsWeight dungeonsWeight;

    public Weight(SlayerWeight slayerWeight, SkillsWeight skillsWeight, DungeonsWeight dungeonsWeight) {
        this.slayerWeight = slayerWeight;
        this.skillsWeight = skillsWeight;
        this.dungeonsWeight = dungeonsWeight;
        this.calculateWeight();
    }

    public WeightStruct getTotalWeight() {
        return new WeightStruct().add(this.slayerWeight.getWeightStruct()).add(this.skillsWeight.getWeightStruct()).add(this.dungeonsWeight.getWeightStruct());
    }

    public SlayerWeight getSlayerWeight() {
        return this.slayerWeight;
    }

    public SkillsWeight getSkillsWeight() {
        return this.skillsWeight;
    }

    public DungeonsWeight getDungeonsWeight() {
        return this.dungeonsWeight;
    }

    protected abstract void calculateWeight();
}

