/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.recipes.ForgeRecipe;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.MobLootRecipe;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.util.Debouncer;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class RecipeGenerator {
    public static final String DURATION = "Duration: ";
    public static final String COINS_SUFFIX = " Coins";
    private final NotEnoughUpdates neu;
    private final Map<String, String> savedForgingDurations = new HashMap<String, String>();
    private final Debouncer debouncer = new Debouncer(50000000L);
    private final Debouncer durationDebouncer = new Debouncer(500000000L);
    private static final Pattern MOB_DISPLAY_NAME_PATTERN = Pattern.compile("^\u00a78\\[\u00a77Lv(?<level>\\d+)\u00a78] (?<name>.*)$");
    private static final Pattern LORE_PATTERN = Pattern.compile("^(?:\u00a77Coins per Kill: \u00a76(?<coins>[,\\d]+)|\u00a77Combat Exp: \u00a73(?<combatxp>[,\\d]+)|\u00a77XP Orbs: \u00a73(?<xp>[,\\d]+)|\u00a78 \u25a0 (?:\u00a77)?(?<dropName>(?:\u00a7.)?.+?)(?: \u00a78\\(\u00a7a(?<dropChances>[\\d.<]+%)\u00a78\\)| \u00a78(?<dropCount>x.*))?|\u00a77Kills: \u00a7a[,\\d]+|\u00a7.[a-zA-Z]+ Loot|\u00a77Deaths: \u00a7a[,\\d]+| \u00a78\u25a0 (?<missing>\u00a7c\\?\\?\\?)|)$");
    private static final Map<Character, Integer> durationSuffixLengthMap = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf('d'), 86400);
            this.put(Character.valueOf('h'), 3600);
            this.put(Character.valueOf('m'), 60);
            this.put(Character.valueOf('s'), 1);
        }
    };

    public RecipeGenerator(NotEnoughUpdates neu) {
        this.neu = neu;
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (!this.neu.config.apiData.repositoryEditing) {
            return;
        }
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen == null) {
            return;
        }
        if (!(currentScreen instanceof GuiChest)) {
            return;
        }
        this.analyzeUI((GuiChest)currentScreen);
    }

    private boolean shouldSaveRecipe() {
        return Keyboard.isKeyDown((int)24) && this.debouncer.trigger();
    }

    public void analyzeUI(GuiChest gui) {
        ContainerChest container = (ContainerChest)gui.field_147002_h;
        IInventory menu = container.func_85151_d();
        String uiTitle = menu.func_145748_c_().func_150260_c();
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if ((uiTitle.startsWith("Item Casting") || uiTitle.startsWith("Refine")) && this.durationDebouncer.trigger()) {
            this.parseAllForgeItemMetadata(menu);
        }
        boolean saveRecipe = this.shouldSaveRecipe();
        if (uiTitle.equals("Confirm Process") && saveRecipe) {
            ForgeRecipe recipe = this.parseSingleForgeRecipe(menu);
            if (recipe == null) {
                Utils.addChatMessage("" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + "Could not parse recipe for this UI");
            } else {
                Utils.addChatMessage("" + EnumChatFormatting.GREEN + EnumChatFormatting.BOLD + "Parsed recipe:");
                Utils.addChatMessage("" + EnumChatFormatting.AQUA + " Inputs:");
                for (Ingredient i : recipe.getInputs()) {
                    Utils.addChatMessage("  - " + EnumChatFormatting.AQUA + i.getInternalItemId() + " x " + i.getCount());
                }
                Utils.addChatMessage("" + EnumChatFormatting.AQUA + " Output: " + EnumChatFormatting.GOLD + recipe.getOutput().getInternalItemId() + " x " + recipe.getOutput().getCount());
                Utils.addChatMessage("" + EnumChatFormatting.AQUA + " Time: " + EnumChatFormatting.GRAY + recipe.getTimeInSeconds() + " seconds (no QF) .");
                boolean saved = false;
                try {
                    saved = this.saveRecipes(recipe.getOutput().getInternalItemId(), Collections.singletonList(recipe));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!saved) {
                    Utils.addChatMessage("" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + EnumChatFormatting.OBFUSCATED + "#" + EnumChatFormatting.RESET + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + " ERROR " + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + EnumChatFormatting.OBFUSCATED + "#" + EnumChatFormatting.RESET + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + " Failed to save recipe. Does the item already exist?");
                }
            }
        }
        if (saveRecipe) {
            this.attemptToSaveBestiary(menu);
        }
    }

    private List<String> getLore(ItemStack item) {
        NBTTagList loreTag = item.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
        ArrayList<String> loreList = new ArrayList<String>();
        for (int i = 0; i < loreTag.func_74745_c(); ++i) {
            loreList.add(loreTag.func_150307_f(i));
        }
        return loreList;
    }

    private void attemptToSaveBestiary(IInventory menu) {
        if (!menu.func_145748_c_().func_150260_c().contains("\u279c")) {
            return;
        }
        ItemStack backArrow = menu.func_70301_a(48);
        if (backArrow == null || backArrow.func_77973_b() != Items.field_151032_g) {
            return;
        }
        if (!this.getLore(backArrow).stream().anyMatch(it -> it.startsWith("\u00a77To Bestiary \u279c"))) {
            return;
        }
        ArrayList<NeuRecipe> recipes = new ArrayList<NeuRecipe>();
        String internalMobName = menu.func_145748_c_().func_150260_c().split("\u279c")[1].toUpperCase(Locale.ROOT).trim() + "_MONSTER";
        for (int i = 9; i < 44; ++i) {
            Matcher matcher;
            ItemStack mobStack = menu.func_70301_a(i);
            if (mobStack == null || mobStack.func_77973_b() != Items.field_151144_bL || !(matcher = MOB_DISPLAY_NAME_PATTERN.matcher(mobStack.func_82833_r())).matches()) continue;
            String name = matcher.group("name");
            int level = this.parseIntIgnoringCommas(matcher.group("level"));
            List<String> mobLore = this.getLore(mobStack);
            int coins = 0;
            int xp = 0;
            int combatXp = 0;
            ArrayList<MobLootRecipe.MobDrop> drops = new ArrayList<MobLootRecipe.MobDrop>();
            for (String loreLine : mobLore) {
                Matcher loreMatcher = LORE_PATTERN.matcher(loreLine);
                if (!loreMatcher.matches()) {
                    Utils.addChatMessage("[WARNING] Unknown lore line: " + loreLine);
                    continue;
                }
                if (loreMatcher.group("coins") != null) {
                    coins = this.parseIntIgnoringCommas(loreMatcher.group("coins"));
                }
                if (loreMatcher.group("combatxp") != null) {
                    combatXp = this.parseIntIgnoringCommas(loreMatcher.group("combatxp"));
                }
                if (loreMatcher.group("xp") != null) {
                    xp = this.parseIntIgnoringCommas(loreMatcher.group("xp"));
                }
                if (loreMatcher.group("dropName") != null) {
                    String dropName = loreMatcher.group("dropName");
                    List possibleItems = this.neu.manager.getItemInformation().values().stream().filter(it -> it.get("displayname").getAsString().equals(dropName)).collect(Collectors.toList());
                    if (possibleItems.size() != 1) {
                        Utils.addChatMessage("[WARNING] Could not parse drop, ambiguous or missing item information: " + loreLine);
                        continue;
                    }
                    Ingredient item = new Ingredient(this.neu.manager, ((JsonObject)possibleItems.get(0)).get("internalname").getAsString());
                    String chance = loreMatcher.group("dropChances") != null ? loreMatcher.group("dropChances") : loreMatcher.group("dropCount");
                    drops.add(new MobLootRecipe.MobDrop(item, chance, new ArrayList<String>(), Collections.emptyList()));
                }
                if (loreMatcher.group("missing") == null) continue;
                Utils.addChatMessage("[WARNING] You are missing Bestiary levels for drop: " + loreLine);
            }
            recipes.add(new MobLootRecipe(new Ingredient(this.neu.manager, internalMobName, 1.0), drops, level, coins, xp, combatXp, name, null, new ArrayList<String>(), "unknown"));
        }
        boolean saved = false;
        try {
            saved = this.saveRecipes(internalMobName, recipes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!saved) {
            Utils.addChatMessage("" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + EnumChatFormatting.OBFUSCATED + "#" + EnumChatFormatting.RESET + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + " ERROR " + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + EnumChatFormatting.OBFUSCATED + "#" + EnumChatFormatting.RESET + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + " Failed to save recipe. Does the item already exist?");
        }
    }

    private int parseIntIgnoringCommas(String text) {
        return Integer.parseInt(text.replace(",", ""));
    }

    public boolean saveRecipes(String relevantItem, List<NeuRecipe> recipes) throws IOException {
        JsonObject outputJson = this.neu.manager.readJsonDefaultDir((relevantItem = relevantItem.replace(" ", "_")) + ".json");
        if (outputJson == null) {
            return false;
        }
        outputJson.addProperty("clickcommand", "viewrecipe");
        JsonArray array = new JsonArray();
        for (NeuRecipe recipe : recipes) {
            array.add(recipe.serialize());
        }
        outputJson.add("recipes", array);
        this.neu.manager.writeJsonDefaultDir(outputJson, relevantItem + ".json");
        this.neu.manager.loadItem(relevantItem);
        return true;
    }

    public ForgeRecipe parseSingleForgeRecipe(IInventory chest) {
        int durationInSeconds = -1;
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        Ingredient output = null;
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            int col = i % 9;
            ItemStack itemStack = chest.func_70301_a(i);
            if (itemStack == null) continue;
            String name = Utils.cleanColour(itemStack.func_82833_r());
            String internalId = this.neu.manager.getInternalNameForItem(itemStack);
            Ingredient ingredient = null;
            if (itemStack.func_82833_r().endsWith(COINS_SUFFIX)) {
                int coinCost = Integer.parseInt(name.substring(0, name.length() - COINS_SUFFIX.length()).replace(",", ""));
                ingredient = Ingredient.coinIngredient(this.neu.manager, coinCost);
            } else if (internalId != null) {
                ingredient = new Ingredient(this.neu.manager, internalId, itemStack.field_77994_a);
            }
            if (ingredient == null) continue;
            if (col < 4) {
                inputs.add(ingredient);
                continue;
            }
            output = ingredient;
        }
        if (output == null || inputs.isEmpty()) {
            return null;
        }
        if (this.savedForgingDurations.containsKey(output.getInternalItemId())) {
            durationInSeconds = this.parseDuration(this.savedForgingDurations.get(output.getInternalItemId()));
        }
        return new ForgeRecipe(this.neu.manager, new ArrayList<Ingredient>(Ingredient.mergeIngredients(inputs)), output, durationInSeconds, -1);
    }

    public int parseDuration(String durationString) {
        String[] parts = durationString.split(" ");
        int timeInSeconds = 0;
        for (String part : parts) {
            char signifier = part.charAt(part.length() - 1);
            int value = Integer.parseInt(part.substring(0, part.length() - 1));
            if (!durationSuffixLengthMap.containsKey(Character.valueOf(signifier))) {
                return -1;
            }
            timeInSeconds += value * durationSuffixLengthMap.get(Character.valueOf(signifier));
        }
        return timeInSeconds;
    }

    private void parseAllForgeItemMetadata(IInventory chest) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            String internalName;
            ItemStack stack = chest.func_70301_a(i);
            if (stack == null || (internalName = this.neu.manager.getInternalNameForItem(stack)) == null) continue;
            List tooltip = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            String durationInfo = null;
            for (String s : tooltip) {
                String info = Utils.cleanColour(s);
                if (!info.startsWith(DURATION)) continue;
                durationInfo = info.substring(DURATION.length());
            }
            if (durationInfo == null) continue;
            this.savedForgingDurations.put(internalName, durationInfo);
        }
    }
}

