/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.options.customtypes.NEUDebugFlag;
import io.github.moulberry.notenoughupdates.util.ApiCache;
import io.github.moulberry.notenoughupdates.util.ApiUtil;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.apache.http.NameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002)*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u001a0\u001f2\b\u0010 \u001a\u0004\u0018\u00010!J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0012H\u0002J\u001a\u0010'\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0019\u0010\u0018\u001a\u00020\u000fX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0010\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006+"}, d2={"Lio/github/moulberry/notenoughupdates/util/ApiCache;", "", "()V", "cacheBaseDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCacheBaseDir", "()Ljava/nio/file/Path;", "cacheBaseDir$delegate", "Lkotlin/Lazy;", "cachedRequests", "", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheKey;", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult;", "globalMaxCacheAge", "Lkotlin/time/Duration;", "J", "histogramNonCachedRequests", "", "", "getHistogramNonCachedRequests", "()Ljava/util/Map;", "histogramTotalRequests", "getHistogramTotalRequests", "timeout", "cacheRequest", "Ljava/util/concurrent/CompletableFuture;", "request", "Lio/github/moulberry/notenoughupdates/util/ApiUtil$Request;", "cacheKey", "futureSupplier", "Ljava/util/function/Supplier;", "maxAge", "Ljava/time/Duration;", "clear", "", "evictCache", "log", "message", "traceApiRequest", "failReason", "CacheKey", "CacheResult", "NotEnoughUpdates"})
public final class ApiCache {
    @NotNull
    public static final ApiCache INSTANCE = new ApiCache();
    @NotNull
    private static final Lazy cacheBaseDir$delegate = LazyKt.lazy((Function0)cacheBaseDir.2.INSTANCE);
    @NotNull
    private static final Map<CacheKey, CacheResult> cachedRequests = new LinkedHashMap();
    @NotNull
    private static final Map<String, Integer> histogramTotalRequests = new LinkedHashMap();
    @NotNull
    private static final Map<String, Integer> histogramNonCachedRequests = new LinkedHashMap();
    private static final long timeout = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
    private static final long globalMaxCacheAge = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS);

    private ApiCache() {
    }

    private final Path getCacheBaseDir() {
        Lazy lazy = cacheBaseDir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final Map<String, Integer> getHistogramTotalRequests() {
        return histogramTotalRequests;
    }

    @NotNull
    public final Map<String, Integer> getHistogramNonCachedRequests() {
        return histogramNonCachedRequests;
    }

    private final void log(String message) {
        NEUDebugFlag.API_CACHE.log(message);
    }

    /*
     * Unable to fully structure code
     */
    private final void traceApiRequest(ApiUtil.Request request, String failReason) {
        block15: {
            block14: {
                block13: {
                    if (!NotEnoughUpdates.INSTANCE.config.hidden.dev) {
                        return;
                    }
                    v0 = Thread.currentThread().getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"currentThread().stackTrace");
                    for (Object var8_8 : (Object[])v0) {
                        it = (StackTraceElement)var8_8;
                        $i$a$-find-ApiCache$traceApiRequest$callingClass$1 = false;
                        v1 = it.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.className");
                        if (StringsKt.startsWith$default((String)v1, (String)"java.", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                        v2 = it.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.className");
                        if (!(StringsKt.startsWith$default((String)v2, (String)"kotlin.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)it.getClassName(), (Object)ApiCache.class.getName()) || Intrinsics.areEqual((Object)it.getClassName(), (Object)ApiUtil.class.getName()) || Intrinsics.areEqual((Object)it.getClassName(), (Object)ApiUtil.Request.class.getName()))) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = var8_8;
                        break block13;
                    }
                    v4 = null;
                }
                if ((v5 = (callingClass = (StackTraceElement)v4)) == null) break block14;
                it = v5;
                $i$a$-let-ApiCache$traceApiRequest$callingClassText$1 = false;
                v6 = it.getClassName() + '.' + it.getMethodName() + " (" + it.getFileName() + ':' + it.getLineNumber() + ')';
                v5 = v6;
                if (v6 != null) break block15;
            }
            v5 = callingClassText = "no calling class found";
        }
        if ((v7 = callingClass) != null && (v7 = v7.getClassName()) != null) {
            it = v7;
            $i$a$-let-ApiCache$traceApiRequest$1 = false;
            var9_11 = ApiCache.histogramTotalRequests;
            v8 = ApiCache.histogramTotalRequests.get(it);
            var10_13 = (v8 != null ? v8 : 0) + 1;
            var9_11.put((String)it, var10_13);
            if (failReason != null) {
                var9_11 = ApiCache.histogramNonCachedRequests;
                v9 = ApiCache.histogramNonCachedRequests.get(it);
                var10_13 = (v9 != null ? v9 : 0) + 1;
                var9_11.put((String)it, var10_13);
            }
        }
        if (failReason != null) {
            this.log("Executing api request for url " + request.getBaseUrl() + " by " + (String)callingClassText + ": " + failReason);
        } else {
            this.log("Cache hit for api request for url " + request.getBaseUrl() + " by " + (String)callingClassText + '.');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ApiCache apiCache = this;
        synchronized (apiCache) {
            boolean bl = false;
            cachedRequests.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void evictCache() {
        ApiCache apiCache = this;
        synchronized (apiCache) {
            boolean bl = false;
            Iterator<Map.Entry<CacheKey, CacheResult>> it = cachedRequests.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CacheKey, CacheResult> next2 = it.next();
                if (Duration.compareTo-LRDsOJo((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)next2.getValue().getFiredAt-z9LOYto()), (long)globalMaxCacheAge) < 0) continue;
                next2.getValue().dispose$NotEnoughUpdates();
                it.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<String> cacheRequest(@NotNull ApiUtil.Request request, @Nullable CacheKey cacheKey, @NotNull Supplier<CompletableFuture<String>> futureSupplier, @Nullable java.time.Duration maxAge) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(futureSupplier, (String)"futureSupplier");
        this.evictCache();
        if (cacheKey == null) {
            this.traceApiRequest(request, "uncacheable request (probably POST)");
            CompletableFuture<String> completableFuture = futureSupplier.get();
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"futureSupplier.get()");
            return completableFuture;
        }
        if (maxAge == null) {
            this.traceApiRequest(request, "manually specified as uncacheable");
            CompletableFuture<String> completableFuture = futureSupplier.get();
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"futureSupplier.get()");
            return completableFuture;
        }
        ApiCache apiCache = this;
        synchronized (apiCache) {
            CompletableFuture<String> completableFuture;
            CacheResult cachedRequest;
            block12: {
                boolean bl = false;
                cachedRequest = cachedRequests.get(cacheKey);
                if (cachedRequest != null) break block12;
                INSTANCE.traceApiRequest(request, "no cache found");
                CompletableFuture<String> completableFuture2 = ApiCache.cacheRequest$recache(futureSupplier, cacheKey);
                return completableFuture2;
            }
            if (cachedRequest.isAvailable()) {
                java.time.Duration duration = maxAge;
                if (Duration.compareTo-LRDsOJo((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)cachedRequest.getFiredAt-z9LOYto()), (long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS))) > 0) {
                    INSTANCE.traceApiRequest(request, "outdated cache");
                    completableFuture = ApiCache.cacheRequest$recache(futureSupplier, cacheKey);
                } else {
                    INSTANCE.traceApiRequest(request, null);
                    completableFuture = cachedRequest.getCachedFuture();
                }
            } else if (Duration.compareTo-LRDsOJo((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)cachedRequest.getFiredAt-z9LOYto()), (long)timeout) > 0) {
                INSTANCE.traceApiRequest(request, "suspiciously slow api response");
                completableFuture = ApiCache.cacheRequest$recache(futureSupplier, cacheKey);
            } else {
                INSTANCE.traceApiRequest(request, null);
                completableFuture = cachedRequest.getCachedFuture();
            }
            CompletableFuture<String> completableFuture3 = completableFuture;
            return completableFuture3;
        }
    }

    private static final CompletableFuture<String> cacheRequest$recache(Supplier<CompletableFuture<String>> $futureSupplier, CacheKey $cacheKey) {
        CompletableFuture<String> completableFuture;
        CompletableFuture<String> completableFuture2 = $futureSupplier.get();
        Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"futureSupplier.get()");
        CompletableFuture<String> it = completableFuture = completableFuture2;
        boolean bl = false;
        CacheResult cacheResult = cachedRequests.get($cacheKey);
        if (cacheResult != null) {
            cacheResult.dispose$NotEnoughUpdates();
        }
        cachedRequests.put($cacheKey, new CacheResult(it, TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), null));
        return completableFuture;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheKey;", "", "baseUrl", "", "requestParameters", "", "Lorg/apache/http/NameValuePair;", "shouldGunzip", "", "(Ljava/lang/String;Ljava/util/List;Z)V", "getBaseUrl", "()Ljava/lang/String;", "getRequestParameters", "()Ljava/util/List;", "getShouldGunzip", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "NotEnoughUpdates"})
    public static final class CacheKey {
        @NotNull
        private final String baseUrl;
        @NotNull
        private final List<NameValuePair> requestParameters;
        private final boolean shouldGunzip;

        public CacheKey(@NotNull String baseUrl, @NotNull List<? extends NameValuePair> requestParameters, boolean shouldGunzip) {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter(requestParameters, (String)"requestParameters");
            this.baseUrl = baseUrl;
            this.requestParameters = requestParameters;
            this.shouldGunzip = shouldGunzip;
        }

        @NotNull
        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @NotNull
        public final List<NameValuePair> getRequestParameters() {
            return this.requestParameters;
        }

        public final boolean getShouldGunzip() {
            return this.shouldGunzip;
        }

        @NotNull
        public final String component1() {
            return this.baseUrl;
        }

        @NotNull
        public final List<NameValuePair> component2() {
            return this.requestParameters;
        }

        public final boolean component3() {
            return this.shouldGunzip;
        }

        @NotNull
        public final CacheKey copy(@NotNull String baseUrl, @NotNull List<? extends NameValuePair> requestParameters, boolean shouldGunzip) {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter(requestParameters, (String)"requestParameters");
            return new CacheKey(baseUrl, requestParameters, shouldGunzip);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string, List list, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = cacheKey.baseUrl;
            }
            if ((n & 2) != 0) {
                list = cacheKey.requestParameters;
            }
            if ((n & 4) != 0) {
                bl = cacheKey.shouldGunzip;
            }
            return cacheKey.copy(string, list, bl);
        }

        @NotNull
        public String toString() {
            return "CacheKey(baseUrl=" + this.baseUrl + ", requestParameters=" + this.requestParameters + ", shouldGunzip=" + this.shouldGunzip + ')';
        }

        public int hashCode() {
            int result2 = this.baseUrl.hashCode();
            result2 = result2 * 31 + ((Object)this.requestParameters).hashCode();
            int n = this.shouldGunzip ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.baseUrl, (Object)cacheKey.baseUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requestParameters, cacheKey.requestParameters)) {
                return false;
            }
            return this.shouldGunzip == cacheKey.shouldGunzip;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001$B \b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007B\u001a\b\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J\u0019\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0010J*\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0013\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0004H\u00d6\u0001R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006%"}, d2={"Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult;", "", "future", "Ljava/util/concurrent/CompletableFuture;", "", "firedAt", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "(Ljava/util/concurrent/CompletableFuture;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "cacheState", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;", "(Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCacheState", "()Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;", "setCacheState", "(Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;)V", "getFiredAt-z9LOYto", "()J", "J", "isAvailable", "", "()Z", "component1", "component2", "component2-z9LOYto", "copy", "copy-qo9EpN4", "(Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;J)Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult;", "dispose", "", "dispose$NotEnoughUpdates", "equals", "other", "getCachedFuture", "hashCode", "", "toString", "CacheState", "NotEnoughUpdates"})
    @SourceDebugExtension(value={"SMAP\nApiCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiCache.kt\nio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult\n+ 2 completablefuture.kt\nio/github/moulberry/notenoughupdates/util/kotlin/CompletablefutureKt\n*L\n1#1,224:1\n25#2,7:225\n25#2,7:232\n*S KotlinDebug\n*F\n+ 1 ApiCache.kt\nio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult\n*L\n81#1:225,7\n85#1:232,7\n*E\n"})
    public static final class CacheResult {
        @NotNull
        private CacheState cacheState;
        private final long firedAt;

        private CacheResult(CacheState cacheState, long firedAt) {
            Intrinsics.checkNotNullParameter((Object)cacheState, (String)"cacheState");
            this.cacheState = cacheState;
            this.firedAt = firedAt;
        }

        @NotNull
        public final CacheState getCacheState() {
            return this.cacheState;
        }

        public final void setCacheState(@NotNull CacheState cacheState) {
            Intrinsics.checkNotNullParameter((Object)cacheState, (String)"<set-?>");
            this.cacheState = cacheState;
        }

        public final long getFiredAt-z9LOYto() {
            return this.firedAt;
        }

        private CacheResult(CompletableFuture<String> future, long firedAt) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            this(new CacheState.WaitingForFuture(future), firedAt, null);
            future.thenAccept(arg_0 -> CacheResult._init_$lambda$0((Function1)new Function1<String, Unit>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(String text) {
                    CacheResult cacheResult = this;
                    CacheResult cacheResult2 = this;
                    CacheResult cacheResult3 = cacheResult;
                    synchronized (cacheResult3) {
                        boolean bl = false;
                        Path f = Files.createTempFile(INSTANCE.getCacheBaseDir(), "api-cache", ".bin", new FileAttribute[0]);
                        INSTANCE.log("Writing cache to disk: " + f);
                        f.toFile().deleteOnExit();
                        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                        PathsKt.writeText$default((Path)f, (CharSequence)text, null, (OpenOption[])new OpenOption[0], (int)2, null);
                        cacheResult2.setCacheState(new CacheState.FileCached(f));
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }, arg_0));
        }

        public final boolean isAvailable() {
            return this.cacheState instanceof CacheState.FileCached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CompletableFuture<String> getCachedFuture() {
            CacheResult cacheResult = this;
            synchronized (cacheResult) {
                CompletableFuture<String> completableFuture;
                CompletableFuture<String> cf$iv;
                boolean $i$f$supplyImmediate;
                boolean bl = false;
                CacheState cs = this.cacheState;
                if (Intrinsics.areEqual((Object)cs, (Object)CacheState.Disposed.INSTANCE)) {
                    $i$f$supplyImmediate = false;
                    cf$iv = new CompletableFuture<String>();
                    try {
                        boolean bl2 = false;
                        throw new IllegalStateException("Attempting to read from a disposed future. Most likely caused by non synchronized access to ApiCache.cachedRequests");
                    }
                    catch (Throwable t$iv) {
                        cf$iv.completeExceptionally(t$iv);
                        completableFuture = cf$iv;
                    }
                } else if (cs instanceof CacheState.FileCached) {
                    $i$f$supplyImmediate = false;
                    cf$iv = new CompletableFuture();
                    try {
                        CompletableFuture<String> completableFuture2 = cf$iv;
                        boolean bl3 = false;
                        completableFuture2.complete(PathsKt.readText$default((Path)((CacheState.FileCached)cs).getFile(), null, (int)1, null));
                    }
                    catch (Throwable t$iv) {
                        cf$iv.completeExceptionally(t$iv);
                    }
                    completableFuture = cf$iv;
                } else if (cs instanceof CacheState.WaitingForFuture) {
                    completableFuture = ((CacheState.WaitingForFuture)cs).getFuture();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                CompletableFuture<String> completableFuture3 = completableFuture;
                return completableFuture3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dispose$NotEnoughUpdates() {
            CacheResult cacheResult = this;
            synchronized (cacheResult) {
                boolean bl = false;
                CacheState cacheState = this.cacheState;
                CacheState.FileCached fileCached = cacheState instanceof CacheState.FileCached ? (CacheState.FileCached)cacheState : null;
                Path file = fileCached != null ? fileCached.getFile() : null;
                INSTANCE.log("Disposing cache for " + file);
                this.cacheState = CacheState.Disposed.INSTANCE;
                Path path = file;
                Boolean bl2 = path != null ? Boolean.valueOf(Files.deleteIfExists(path)) : null;
            }
        }

        @NotNull
        public final CacheState component1() {
            return this.cacheState;
        }

        public final long component2-z9LOYto() {
            return this.firedAt;
        }

        @NotNull
        public final CacheResult copy-qo9EpN4(@NotNull CacheState cacheState, long firedAt) {
            Intrinsics.checkNotNullParameter((Object)cacheState, (String)"cacheState");
            return new CacheResult(cacheState, firedAt, null);
        }

        public static /* synthetic */ CacheResult copy-qo9EpN4$default(CacheResult cacheResult, CacheState cacheState, long l, int n, Object object) {
            if ((n & 1) != 0) {
                cacheState = cacheResult.cacheState;
            }
            if ((n & 2) != 0) {
                l = cacheResult.firedAt;
            }
            return cacheResult.copy-qo9EpN4(cacheState, l);
        }

        @NotNull
        public String toString() {
            return "CacheResult(cacheState=" + this.cacheState + ", firedAt=" + TimeSource.Monotonic.ValueTimeMark.toString-impl((long)this.firedAt) + ')';
        }

        public int hashCode() {
            int result2 = this.cacheState.hashCode();
            result2 = result2 * 31 + TimeSource.Monotonic.ValueTimeMark.hashCode-impl((long)this.firedAt);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheResult)) {
                return false;
            }
            CacheResult cacheResult = (CacheResult)other;
            if (!Intrinsics.areEqual((Object)this.cacheState, (Object)cacheResult.cacheState)) {
                return false;
            }
            return TimeSource.Monotonic.ValueTimeMark.equals-impl0((long)this.firedAt, (long)cacheResult.firedAt);
        }

        private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ CacheResult(CacheState cacheState, long firedAt, DefaultConstructorMarker $constructor_marker) {
            this(cacheState, firedAt);
        }

        public /* synthetic */ CacheResult(CompletableFuture future, long firedAt, DefaultConstructorMarker $constructor_marker) {
            this(future, firedAt);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;", "", "Disposed", "FileCached", "WaitingForFuture", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState$Disposed;", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState$FileCached;", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState$WaitingForFuture;", "NotEnoughUpdates"})
        public static interface CacheState {

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState$Disposed;", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;", "()V", "NotEnoughUpdates"})
            public static final class Disposed
            implements CacheState {
                @NotNull
                public static final Disposed INSTANCE = new Disposed();

                private Disposed() {
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState$FileCached;", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getFile", "()Ljava/nio/file/Path;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "NotEnoughUpdates"})
            public static final class FileCached
            implements CacheState {
                @NotNull
                private final Path file;

                public FileCached(@NotNull Path file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    this.file = file;
                }

                @NotNull
                public final Path getFile() {
                    return this.file;
                }

                @NotNull
                public final Path component1() {
                    return this.file;
                }

                @NotNull
                public final FileCached copy(@NotNull Path file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return new FileCached(file);
                }

                public static /* synthetic */ FileCached copy$default(FileCached fileCached, Path path, int n, Object object) {
                    if ((n & 1) != 0) {
                        path = fileCached.file;
                    }
                    return fileCached.copy(path);
                }

                @NotNull
                public String toString() {
                    return "FileCached(file=" + this.file + ')';
                }

                public int hashCode() {
                    return ((Object)this.file).hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FileCached)) {
                        return false;
                    }
                    FileCached fileCached = (FileCached)other;
                    return Intrinsics.areEqual((Object)this.file, (Object)fileCached.file);
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState$WaitingForFuture;", "Lio/github/moulberry/notenoughupdates/util/ApiCache$CacheResult$CacheState;", "future", "Ljava/util/concurrent/CompletableFuture;", "", "(Ljava/util/concurrent/CompletableFuture;)V", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "NotEnoughUpdates"})
            public static final class WaitingForFuture
            implements CacheState {
                @NotNull
                private final CompletableFuture<String> future;

                public WaitingForFuture(@NotNull CompletableFuture<String> future) {
                    Intrinsics.checkNotNullParameter(future, (String)"future");
                    this.future = future;
                }

                @NotNull
                public final CompletableFuture<String> getFuture() {
                    return this.future;
                }

                @NotNull
                public final CompletableFuture<String> component1() {
                    return this.future;
                }

                @NotNull
                public final WaitingForFuture copy(@NotNull CompletableFuture<String> future) {
                    Intrinsics.checkNotNullParameter(future, (String)"future");
                    return new WaitingForFuture(future);
                }

                public static /* synthetic */ WaitingForFuture copy$default(WaitingForFuture waitingForFuture, CompletableFuture completableFuture, int n, Object object) {
                    if ((n & 1) != 0) {
                        completableFuture = waitingForFuture.future;
                    }
                    return waitingForFuture.copy(completableFuture);
                }

                @NotNull
                public String toString() {
                    return "WaitingForFuture(future=" + this.future + ')';
                }

                public int hashCode() {
                    return this.future.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof WaitingForFuture)) {
                        return false;
                    }
                    WaitingForFuture waitingForFuture = (WaitingForFuture)other;
                    return Intrinsics.areEqual(this.future, waitingForFuture.future);
                }
            }
        }
    }
}

