/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.io.IOUtils;

public class MoulSigner {
    static PublicKey publicKey;

    private MoulSigner() {
    }

    public static boolean verifySignature(byte[] data, byte[] signatureBytes) {
        if (Boolean.getBoolean("neu.noverifysignature")) {
            return true;
        }
        if (publicKey == null) {
            NotEnoughUpdates.LOGGER.warn("MoulSigner could not be initialized, will fail this request");
            return false;
        }
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(signatureBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e2) {
            NotEnoughUpdates.LOGGER.error("Error while verifying signature. Considering this as invalid signature", (Throwable)e2);
            return false;
        }
    }

    public static boolean verifySignature(File file) {
        try {
            return MoulSigner.verifySignature(IOUtils.toByteArray((URI)file.toURI()), IOUtils.toByteArray((URI)new File(file.getParentFile(), file.getName() + ".asc").toURI()));
        }
        catch (IOException e2) {
            NotEnoughUpdates.LOGGER.error("Ran into an IOException while verifying a signature", (Throwable)e2);
            return false;
        }
    }

    static {
        try (InputStream is = MoulSigner.class.getResourceAsStream("/moulberry.key");){
            byte[] publicKeyBytes = IOUtils.toByteArray((InputStream)is);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKeyBytes);
            publicKey = KeyFactory.getInstance("RSA").generatePublic(x509EncodedKeySpec);
        }
        catch (IOException | NullPointerException | NoSuchAlgorithmException | InvalidKeySpecException e2) {
            NotEnoughUpdates.LOGGER.error("Cannot initialize MoulSigner", (Throwable)e2);
        }
    }
}

