/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.TooltipTextScrolling;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.miscfeatures.SlotLocking;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.LerpingFloat;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SkytilsCompat;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C0DPacketCloseWindow;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Matrix4f;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class Utils {
    private static final LinkedList<Integer> guiScales = new LinkedList();
    private static final FloatBuffer projectionMatrixOld = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer modelviewMatrixOld = BufferUtils.createFloatBuffer((int)16);
    private static final EnumChatFormatting[] rainbow = new EnumChatFormatting[]{EnumChatFormatting.RED, EnumChatFormatting.GOLD, EnumChatFormatting.YELLOW, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.DARK_PURPLE};
    private static final Pattern CHROMA_REPLACE_PATTERN = Pattern.compile("\u00a7z(.+?)(?=\u00a7|$)");
    static final Pattern GUILD_OR_PARTY_MESSAGE_PATTERN = Pattern.compile("(?:Party|Guild|Officer|P|G|O) > (?:\\[.*\\] )?([a-zA-Z0-9_]+):? (?:\\[.*\\]: )?");
    private static final char[] c = new char[]{'k', 'm', 'b', 't'};
    private static final LerpingFloat scrollY = new LerpingFloat(0.0f, 100);
    public static boolean hasEffectOverride = false;
    public static boolean disableCustomDungColours = false;
    public static String[] rarityArr = new String[]{"COMMON", "UNCOMMON", "RARE", "EPIC", "LEGENDARY", "MYTHIC", "SPECIAL", "VERY SPECIAL", "SUPREME", "^^ THAT ONE IS DIVINE ^^"};
    public static String[] rarityArrC = new String[]{EnumChatFormatting.WHITE + EnumChatFormatting.BOLD.toString() + "COMMON", EnumChatFormatting.GREEN + EnumChatFormatting.BOLD.toString() + "UNCOMMON", EnumChatFormatting.BLUE + EnumChatFormatting.BOLD.toString() + "RARE", EnumChatFormatting.DARK_PURPLE + EnumChatFormatting.BOLD.toString() + "EPIC", EnumChatFormatting.GOLD + EnumChatFormatting.BOLD.toString() + "LEGENDARY", EnumChatFormatting.LIGHT_PURPLE + EnumChatFormatting.BOLD.toString() + "MYTHIC", EnumChatFormatting.RED + EnumChatFormatting.BOLD.toString() + "SPECIAL", EnumChatFormatting.RED + EnumChatFormatting.BOLD.toString() + "VERY SPECIAL", EnumChatFormatting.AQUA + EnumChatFormatting.BOLD.toString() + "DIVINE"};
    public static final HashMap<String, String> rarityArrMap = new HashMap<String, String>(){
        {
            this.put("COMMON", rarityArrC[0]);
            this.put("UNCOMMON", rarityArrC[1]);
            this.put("RARE", rarityArrC[2]);
            this.put("EPIC", rarityArrC[3]);
            this.put("LEGENDARY", rarityArrC[4]);
            this.put("MYTHIC", rarityArrC[5]);
            this.put("SPECIAL", rarityArrC[6]);
            this.put("VERY SPECIAL", rarityArrC[7]);
            this.put("DIVINE", rarityArrC[8]);
        }
    };
    public static Splitter PATH_SPLITTER = Splitter.on((String)".").omitEmptyStrings().limit(2);
    private static ScaledResolution lastScale = new ScaledResolution(Minecraft.func_71410_x());
    private static long startTime = 0L;
    private static final DecimalFormat simpleDoubleFormat = new DecimalFormat("0.0");
    private static long lastError = -1L;
    private static String clipboardCache = "";
    private static long lastClipboard = -1L;
    private static final String DISCORD_INVITE = "tNSkq8KjA8";

    @SafeVarargs
    public static <T> ArrayList<T> createList(T ... values) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, values);
        return list;
    }

    public static void resetGuiScale() {
        guiScales.clear();
    }

    public static ScaledResolution peekGuiScale() {
        return lastScale;
    }

    public static ScaledResolution pushGuiScale(int scale) {
        int newScale;
        if (guiScales.isEmpty() && Loader.isModLoaded((String)"labymod")) {
            GL11.glGetFloat((int)2983, (FloatBuffer)projectionMatrixOld);
            GL11.glGetFloat((int)2982, (FloatBuffer)modelviewMatrixOld);
        }
        if (scale < 0) {
            if (!guiScales.isEmpty()) {
                guiScales.pop();
            }
        } else if (scale == 0) {
            guiScales.push(Minecraft.func_71410_x().field_71474_y.field_74335_Z);
        } else {
            guiScales.push(scale);
        }
        int n = newScale = !guiScales.isEmpty() ? Math.max(0, guiScales.peek()) : Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        if (newScale == 0) {
            newScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        }
        int oldScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = newScale;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = oldScale;
        if (!guiScales.isEmpty()) {
            GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        } else if (Loader.isModLoaded((String)"labymod") && projectionMatrixOld.limit() > 0 && modelviewMatrixOld.limit() > 0) {
            GlStateManager.func_179128_n((int)5889);
            GL11.glLoadMatrix((FloatBuffer)projectionMatrixOld);
            GlStateManager.func_179128_n((int)5888);
            GL11.glLoadMatrix((FloatBuffer)modelviewMatrixOld);
        } else {
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
        lastScale = scaledresolution;
        return scaledresolution;
    }

    public static boolean getHasEffectOverride() {
        return hasEffectOverride;
    }

    public static void drawItemStackWithoutGlint(ItemStack stack, int x, int y) {
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        disableCustomDungColours = true;
        RenderHelper.func_74520_c();
        itemRender.field_77023_b = -145.0f;
        hasEffectOverride = true;
        try {
            itemRender.func_180450_b(stack, x, y);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, x, y, null);
        hasEffectOverride = false;
        itemRender.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        disableCustomDungColours = false;
    }

    public static void drawItemStackWithText(ItemStack stack, int x, int y, String text) {
        Utils.drawItemStackWithText(stack, x, y, text, false);
    }

    public static void drawItemStackWithText(ItemStack stack, int x, int y, String text, boolean skytilsRarity) {
        if (stack == null) {
            return;
        }
        if (skytilsRarity) {
            SkytilsCompat.renderSkytilsRarity(stack, x, y);
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        disableCustomDungColours = true;
        RenderHelper.func_74520_c();
        itemRender.field_77023_b = -145.0f;
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, x, y, text);
        itemRender.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        disableCustomDungColours = false;
    }

    public static void drawItemStack(ItemStack stack, int x, int y) {
        Utils.drawItemStackWithText(stack, x, y, null);
    }

    public static void drawItemStack(ItemStack stack, int x, int y, boolean skytilsRarity) {
        Utils.drawItemStackWithText(stack, x, y, null, skytilsRarity);
    }

    public static String chromaString(String str) {
        return Utils.chromaString(str, 0.0f, false);
    }

    public static String chromaStringByColourCode(String str) {
        if (str.contains("\u00a7z")) {
            Matcher matcher = CHROMA_REPLACE_PATTERN.matcher(str);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, Utils.chromaString(matcher.group(1)).replace("\\", "\\\\").replace("$", "\\$"));
            }
            matcher.appendTail(sb);
            str = sb.toString();
        }
        return str;
    }

    public static String chromaString(String str, float offset, boolean bold) {
        return Utils.chromaString(str, offset, bold ? "\u00a7l" : "");
    }

    public static String chromaString(String str, float offset, String extraFormatting) {
        int chromaSpeed;
        str = Utils.cleanColour(str);
        boolean bold = extraFormatting.contains("\u00a7l");
        long currentTimeMillis = System.currentTimeMillis();
        if (startTime == 0L) {
            startTime = currentTimeMillis;
        }
        if ((chromaSpeed = NotEnoughUpdates.INSTANCE.config.misc.chromaSpeed) < 10) {
            chromaSpeed = 10;
        }
        if (chromaSpeed > 5000) {
            chromaSpeed = 5000;
        }
        StringBuilder rainbowText = new StringBuilder();
        int len2 = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int index = (int)(offset + (float)len2 / 12.0f - (float)((currentTimeMillis - startTime) / (long)chromaSpeed)) % rainbow.length;
            len2 += Minecraft.func_71410_x().field_71466_p.func_78263_a(c);
            if (bold) {
                ++len2;
            }
            if (index < 0) {
                index += rainbow.length;
            }
            rainbowText.append(rainbow[index]);
            rainbowText.append(extraFormatting);
            rainbowText.append(c);
        }
        return rainbowText.toString();
    }

    public static String shortNumberFormat(double n, int iteration) {
        boolean isRound;
        if (n < 3.0 && n > 0.0) {
            return simpleDoubleFormat.format(n);
        }
        if (n < 1000.0 && iteration == 0) {
            return String.valueOf((int)n);
        }
        double d = (double)((long)n / 100L) / 10.0;
        boolean bl = isRound = d * 10.0 % 10.0 == 0.0;
        return d < 1000.0 ? (isRound || d > 9.99 ? Integer.valueOf((int)d * 10 / 10) : String.valueOf(d)) + String.valueOf(c[iteration]) : Utils.shortNumberFormat(d, iteration + 1);
    }

    public static String trimIgnoreColour(String str) {
        return Utils.trimIgnoreColourStart(Utils.trimIgnoreColourEnd(str));
    }

    public static String trimIgnoreColourStart(String str) {
        str = str.trim();
        boolean colourCodeLast = false;
        StringBuilder colours = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (colourCodeLast) {
                colours.append('\u00a7').append(c);
                colourCodeLast = false;
                continue;
            }
            if (c == '\u00a7') {
                colourCodeLast = true;
                continue;
            }
            if (c == ' ') continue;
            return colours.append(str.substring(i)).toString();
        }
        return "";
    }

    public static String trimIgnoreColourEnd(String str) {
        str = str.trim();
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c == ' ') continue;
            if (i > 0 && str.charAt(i - 1) == '\u00a7') {
                --i;
                continue;
            }
            return str.substring(0, i + 1);
        }
        return "";
    }

    public static String trimWhitespaceAndFormatCodes(String str) {
        int startIndex = Utils.indexOfFirstNonWhitespaceNonFormatCode(str);
        int endIndex = Utils.lastIndexOfNonWhitespaceNonFormatCode(str);
        if (startIndex == -1 || endIndex == -1) {
            return "";
        }
        return str.substring(startIndex, endIndex + 1);
    }

    private static int indexOfFirstNonWhitespaceNonFormatCode(String str) {
        int len2 = str.length();
        for (int i = 0; i < len2; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '\u00a7') {
                ++i;
                continue;
            }
            return i;
        }
        return -1;
    }

    private static int lastIndexOfNonWhitespaceNonFormatCode(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch) || ch == '\u00a7' || i > 0 && str.charAt(i - 1) == '\u00a7') continue;
            return i;
        }
        return -1;
    }

    public static List<String> getRawTooltip(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        String s = stack.func_82833_r();
        if (stack.func_82837_s()) {
            s = EnumChatFormatting.ITALIC + s;
        }
        s = s + EnumChatFormatting.RESET;
        if (!stack.func_82837_s() && stack.func_77973_b() == Items.field_151098_aY) {
            s = s + " #" + stack.func_77952_i();
        }
        list.add(s);
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10)) {
            NBTTagList nbttaglist1;
            NBTTagCompound nbttagcompound = stack.func_77978_p().func_74775_l("display");
            if (nbttagcompound.func_150297_b("color", 3)) {
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.dyed"));
            }
            if (nbttagcompound.func_150299_b("Lore") == 9 && (nbttaglist1 = nbttagcompound.func_150295_c("Lore", 8)).func_74745_c() > 0) {
                for (int j1 = 0; j1 < nbttaglist1.func_74745_c(); ++j1) {
                    list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + nbttaglist1.func_150307_f(j1));
                }
            }
        }
        return list;
    }

    public static String floatToString(float f, int decimals) {
        if (decimals <= 0) {
            return String.valueOf(Math.round(f));
        }
        return String.format("%." + decimals + "f", Float.valueOf(f + 1.0E-5f));
    }

    public static void drawItemStackLinear(ItemStack stack, int x, int y) {
        if (stack == null) {
            return;
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        RenderHelper.func_74520_c();
        itemRender.field_77023_b = -145.0f;
        IBakedModel ibakedmodel = itemRender.func_175037_a().func_178089_a(stack);
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(true, true);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.setupGuiTransform(x, y, ibakedmodel.func_177556_c());
        ibakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI);
        itemRender.func_180454_a(stack, ibakedmodel);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        itemRender.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, x, y);
        itemRender.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    private static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)5.0f);
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        if (isGui3d) {
            GlStateManager.func_179152_a((float)40.0f, (float)40.0f, (float)40.0f);
            GlStateManager.func_179114_b((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179152_a((float)64.0f, (float)64.0f, (float)64.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179140_f();
        }
    }

    public static Method getMethod(Class<?> clazz, Class<?>[] params, String ... methodNames) {
        for (String methodName : methodNames) {
            try {
                return clazz.getDeclaredMethod(methodName, params);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static Object getField(Class<?> clazz, Object o, String ... fieldNames) {
        Field field = null;
        for (String fieldName : fieldNames) {
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (Exception exception) {
            }
        }
        if (field != null) {
            field.setAccessible(true);
            try {
                return field.get(o);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Slot getSlotUnderMouse(GuiContainer container) {
        Slot slot = (Slot)Utils.getField(GuiContainer.class, container, "theSlot", "field_147006_u");
        if (slot == null) {
            slot = SlotLocking.getInstance().getRealSlot();
        }
        return slot;
    }

    public static void drawTexturedRect(float x, float y, float width, float height) {
        Utils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void drawPvSideButton(int yIndex, ItemStack itemStack, boolean pressed, GuiProfileViewer guiProfileViewer, int mouseX, int mouseY) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        int x = guiLeft - 28;
        int y = guiTop + yIndex * 28;
        float uMin = 0.75390625f;
        float uMax = 0.87109375f;
        float vMin = 0.78125f;
        float vMax = 0.890625f;
        if (pressed) {
            uMin = 0.875f;
            uMax = 1.0f;
            if (yIndex != 0) {
                vMin = 0.890625f;
                vMax = 1.0f;
            }
            guiProfileViewer.renderBlurredBackground(guiProfileViewer.field_146294_l, guiProfileViewer.field_146295_m, x + 2, y + 2, 30, 24);
        } else {
            guiProfileViewer.renderBlurredBackground(guiProfileViewer.field_146294_l, guiProfileViewer.field_146295_m, x + 2, y + 2, 26, 24);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
        Utils.drawTexturedRect(x, y, pressed ? 32.0f : 28.0f, 28.0f, uMin, uMax, vMin, vMax, 9728);
        GlStateManager.func_179126_j();
        Utils.drawItemStack(itemStack, x + 8, y + 7);
        if (mouseY > y && mouseX > x && mouseY < y + 28 && mouseX < x + 28) {
            guiProfileViewer.tooltipToDisplay = Collections.singletonList(itemStack.func_82833_r());
        }
    }

    public static void drawTexturedRect(float x, float y, float width, float height, int filter) {
        Utils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, filter);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax) {
        Utils.drawTexturedRect(x, y, width, height, uMin, uMax, vMin, vMax, 9729);
    }

    public static String cleanColour(String in) {
        return in.replaceAll("(?i)\\u00A7.", "");
    }

    public static String cleanColourNotModifiers(String in) {
        return in.replaceAll("(?i)\\u00A7[0-9a-f]", "");
    }

    public static String fixBrokenAPIColour(String in) {
        return in.replaceAll("(?i)\\u00C2(\\u00A7.)", "$1");
    }

    public static String prettyCase(String str) {
        return str.substring(0, 1).toUpperCase(Locale.ROOT) + str.substring(1).toLowerCase(Locale.ROOT);
    }

    public static String getRarityFromInt(int rarity) {
        if (rarity < 0 || rarity >= rarityArr.length) {
            return rarityArr[0];
        }
        return rarityArr[rarity];
    }

    public static int checkItemTypePet(List<String> lore) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = Utils.cleanColour(lore.get(i));
            for (int i1 = 0; i1 < rarityArr.length; ++i1) {
                if (!line.equals(rarityArr[i1])) continue;
                return i1;
            }
        }
        return -1;
    }

    public static int checkItemType(JsonArray lore, boolean contains, String ... typeMatches) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = lore.get(i).getAsString();
            int returnType = Utils.checkItemType(line, contains, typeMatches);
            if (returnType == -1) continue;
            return returnType;
        }
        return -1;
    }

    public static int checkItemType(String[] lore, boolean contains, String ... typeMatches) {
        for (int i = lore.length - 1; i >= 0; --i) {
            String line = lore[i];
            int returnType = Utils.checkItemType(line, contains, typeMatches);
            if (returnType == -1) continue;
            return returnType;
        }
        return -1;
    }

    public static int checkItemType(List<String> lore, boolean contains, String ... typeMatches) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = lore.get(i);
            int returnType = Utils.checkItemType(line, contains, typeMatches);
            if (returnType == -1) continue;
            return returnType;
        }
        return -1;
    }

    private static int checkItemType(String line, boolean contains, String ... typeMatches) {
        for (String rarity : rarityArr) {
            for (int j = 0; j < typeMatches.length; ++j) {
                if (contains) {
                    if (line.trim().contains(rarity + " " + typeMatches[j])) {
                        return j;
                    }
                    if (!line.trim().contains(rarity + " DUNGEON " + typeMatches[j])) continue;
                    return j;
                }
                if (line.trim().endsWith(rarity + " " + typeMatches[j])) {
                    return j;
                }
                if (!line.trim().endsWith(rarity + " DUNGEON " + typeMatches[j])) continue;
                return j;
            }
        }
        return -1;
    }

    public static float round(float value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (float)Math.round(value * (float)scale) / (float)scale;
    }

    public static int roundToNearestInt(double value) {
        return (int)Math.round(value);
    }

    public static int parseRomanNumeral(String input) {
        int prevVal = 0;
        int total = 0;
        for (int i = input.length() - 1; i >= 0; --i) {
            int val;
            char ch = input.charAt(i);
            switch (ch) {
                case 'I': {
                    val = 1;
                    break;
                }
                case 'V': {
                    val = 5;
                    break;
                }
                case 'X': {
                    val = 10;
                    break;
                }
                case 'L': {
                    val = 50;
                    break;
                }
                case 'C': {
                    val = 100;
                    break;
                }
                case 'D': {
                    val = 500;
                    break;
                }
                case 'M': {
                    val = 1000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Roman Numeral Character: " + ch);
                }
            }
            if (val < prevVal) {
                val = -val;
            }
            total += val;
            prevVal = val;
        }
        return total;
    }

    public static int parseIntOrRomanNumeral(String input) {
        if (input.charAt(0) < 'A') {
            return Integer.parseInt(input);
        }
        return Utils.parseRomanNumeral(input);
    }

    public static void playPressSound() {
        Utils.playSound(new ResourceLocation("gui.button.press"), true);
    }

    public static void playSound(ResourceLocation sound, boolean gui) {
        if (NotEnoughUpdates.INSTANCE.config.misc.guiButtonClicks || !gui) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)sound, (float)1.0f));
        }
    }

    public static String cleanDuplicateColourCodes(String line) {
        StringBuilder sb = new StringBuilder();
        char currentColourCode = 'r';
        boolean sectionSymbolLast = false;
        for (char c : line.toCharArray()) {
            if (c > '\uc350') continue;
            if (c == '\u00a7') {
                sectionSymbolLast = true;
                continue;
            }
            if (sectionSymbolLast) {
                if (currentColourCode != c) {
                    sb.append('\u00a7');
                    sb.append(c);
                    currentColourCode = c;
                }
                sectionSymbolLast = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax, int filter) {
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)uMin, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)uMax, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)uMax, (double)vMin).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRectNoBlend(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax, int filter) {
        GlStateManager.func_179098_w();
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)uMin, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)uMax, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)uMax, (double)vMin).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public static ItemStack createItemStack(Item item, String displayName, String ... lore) {
        return Utils.createItemStack(item, displayName, 0, lore);
    }

    public static ItemStack createItemStackArray(Item item, String displayName, String[] lore) {
        return Utils.createItemStack(item, displayName, 0, lore);
    }

    public static ItemStack createItemStack(Block item, String displayName, String ... lore) {
        return Utils.createItemStack(Item.func_150898_a((Block)item), displayName, lore);
    }

    public static ItemStack createItemStack(Item item, String displayName, int damage, String ... lore) {
        return Utils.createItemStack(item, displayName, damage, 1, lore);
    }

    public static ItemStack createItemStack(Item item, String displayName, int damage, int amount, String ... lore) {
        ItemStack stack = new ItemStack(item, amount, damage);
        NBTTagCompound tag = new NBTTagCompound();
        Utils.addNameAndLore(tag, displayName, lore);
        tag.func_74768_a("HideFlags", 254);
        stack.func_77982_d(tag);
        return stack;
    }

    private static void addNameAndLore(NBTTagCompound tag, String displayName, String[] lore) {
        NBTTagCompound display = new NBTTagCompound();
        display.func_74778_a("Name", displayName);
        if (lore != null) {
            NBTTagList tagLore = new NBTTagList();
            for (String line : lore) {
                tagLore.func_74742_a((NBTBase)new NBTTagString(line));
            }
            display.func_74782_a("Lore", (NBTBase)tagLore);
        }
        tag.func_74782_a("display", (NBTBase)display);
    }

    public static ItemStack editItemStackInfo(ItemStack itemStack, String displayName, boolean disableNeuToolTips, String ... lore) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        NBTTagCompound display = tag.func_74775_l("display");
        NBTTagList Lore = new NBTTagList();
        for (String line : lore) {
            Lore.func_74742_a((NBTBase)new NBTTagString(line));
        }
        display.func_74778_a("Name", displayName);
        display.func_74782_a("Lore", (NBTBase)Lore);
        tag.func_74782_a("display", (NBTBase)display);
        tag.func_74768_a("HideFlags", 254);
        if (disableNeuToolTips) {
            tag.func_74757_a("disableNeuTooltip", true);
        }
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    public static ItemStack createSkull(String displayName, String uuid, String value) {
        return Utils.createSkull(displayName, uuid, value, null);
    }

    public static ItemStack createSkull(String displayName, String uuid, String value, String[] lore) {
        ItemStack render = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound skullOwner = new NBTTagCompound();
        NBTTagCompound properties = new NBTTagCompound();
        NBTTagList textures = new NBTTagList();
        NBTTagCompound textures_0 = new NBTTagCompound();
        skullOwner.func_74778_a("Id", uuid);
        skullOwner.func_74778_a("Name", uuid);
        textures_0.func_74778_a("Value", value);
        textures.func_74742_a((NBTBase)textures_0);
        Utils.addNameAndLore(tag, displayName, lore);
        properties.func_74782_a("textures", (NBTBase)textures);
        skullOwner.func_74782_a("Properties", (NBTBase)properties);
        tag.func_74782_a("SkullOwner", (NBTBase)skullOwner);
        render.func_77982_d(tag);
        return render;
    }

    public static void drawStringF(String str, float x, float y, boolean shadow, int colour) {
        Utils.drawStringF(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, colour);
    }

    @Deprecated
    public static void drawStringF(String str, FontRenderer fr, float x, float y, boolean shadow, int colour) {
        fr.func_175065_a(str, x, y, colour, shadow);
    }

    public static int getCharVertLen(char c) {
        if ("acegmnopqrsuvwxyz".indexOf(c) >= 0) {
            return 5;
        }
        return 7;
    }

    public static float getVerticalHeight(String str) {
        str = Utils.cleanColour(str);
        float height = 0.0f;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int charHeight = Utils.getCharVertLen(c);
            height += (float)charHeight + 1.5f;
        }
        return height;
    }

    public static void drawStringVertical(String str, float x, float y, boolean shadow, int colour) {
        Utils.drawStringVertical(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, colour);
    }

    @Deprecated
    public static void drawStringVertical(String str, FontRenderer fr, float x, float y, boolean shadow, int colour) {
        String format2 = FontRenderer.func_78282_e((String)str);
        str = Utils.cleanColour(str);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int charHeight = Utils.getCharVertLen(c);
            int charWidth = fr.func_78263_a(c);
            fr.func_175065_a(format2 + c, x + (float)(5 - charWidth) / 2.0f, y - 7.0f + (float)charHeight, colour, shadow);
            y += (float)charHeight + 1.5f;
        }
    }

    public static void renderShadowedString(String str, float x, float y, int maxLength) {
        float factor;
        int strLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(str);
        if (maxLength < 0) {
            factor = 1.0f;
        } else {
            factor = (float)maxLength / (float)strLen;
            factor = Math.min(1.0f, factor);
        }
        for (int xOff = -2; xOff <= 2; ++xOff) {
            for (int yOff = -2; yOff <= 2; ++yOff) {
                if (Math.abs(xOff) == Math.abs(yOff)) continue;
                Utils.drawStringCenteredScaledMaxWidth(Utils.cleanColourNotModifiers(str), x + (float)xOff / 2.0f * factor, y + 4.0f + (float)yOff / 2.0f * factor, false, maxLength, new Color(0, 0, 0, 200 / Math.max(Math.abs(xOff), Math.abs(yOff))).getRGB());
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawStringCenteredScaledMaxWidth(str, x, y + 4.0f, false, maxLength, 421075);
    }

    public static void renderShadowedString(String str, int x, int y, int maxLength) {
        Utils.renderShadowedString(str, (float)x, (float)y, maxLength);
    }

    public static void renderAlignedString(String first, String second, float x, float y, int length) {
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        if (fontRendererObj.func_78256_a(first + " " + second) >= length) {
            Utils.renderShadowedString(first + " " + second, x + (float)length / 2.0f, y, length);
        } else {
            for (int xOff = -2; xOff <= 2; ++xOff) {
                for (int yOff = -2; yOff <= 2; ++yOff) {
                    if (Math.abs(xOff) == Math.abs(yOff)) continue;
                    fontRendererObj.func_175065_a(Utils.cleanColourNotModifiers(first), x + (float)xOff / 2.0f, y + (float)yOff / 2.0f, new Color(0, 0, 0, 200 / Math.max(Math.abs(xOff), Math.abs(yOff))).getRGB(), false);
                }
            }
            int secondLen = fontRendererObj.func_78256_a(second);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fontRendererObj.func_175065_a(first, x, y, 0x404040, false);
            for (int xOff = -2; xOff <= 2; ++xOff) {
                for (int yOff = -2; yOff <= 2; ++yOff) {
                    if (Math.abs(xOff) == Math.abs(yOff)) continue;
                    fontRendererObj.func_175065_a(Utils.cleanColourNotModifiers(second), x + (float)length - (float)secondLen + (float)xOff / 2.0f, y + (float)yOff / 2.0f, new Color(0, 0, 0, 200 / Math.max(Math.abs(xOff), Math.abs(yOff))).getRGB(), false);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fontRendererObj.func_175065_a(second, x + (float)length - (float)secondLen, y, 0x404040, false);
        }
    }

    public static void drawStringScaledMaxWidth(String str, float x, float y, boolean shadow, int len2, int colour) {
        Utils.drawStringScaledMaxWidth(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, len2, colour);
    }

    @Deprecated
    public static void drawStringScaledMaxWidth(String str, FontRenderer fr, float x, float y, boolean shadow, int len2, int colour) {
        int strLen = fr.func_78256_a(str);
        float factor = (float)len2 / (float)strLen;
        factor = Math.min(1.0f, factor);
        Utils.drawStringScaled(str, x, y, shadow, colour, factor);
    }

    public static void drawStringCentered(String str, float x, float y, boolean shadow, int colour) {
        Utils.drawStringCentered(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, colour);
    }

    public static void drawStringCentered(String str, int x, int y, boolean shadow, int colour) {
        Utils.drawStringCentered(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, colour);
    }

    @Deprecated
    public static void drawStringCentered(String str, FontRenderer fr, float x, float y, boolean shadow, int colour) {
        int strLen = fr.func_78256_a(str);
        float x2 = x - (float)strLen / 2.0f;
        float y2 = y - (float)fr.field_78288_b / 2.0f;
        GL11.glTranslatef((float)x2, (float)y2, (float)0.0f);
        fr.func_175065_a(str, 0.0f, 0.0f, colour, shadow);
        GL11.glTranslatef((float)(-x2), (float)(-y2), (float)0.0f);
    }

    public static void drawStringScaled(String str, float x, float y, boolean shadow, int colour, float factor) {
        Utils.drawStringScaled(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, colour, factor);
    }

    @Deprecated
    public static void drawStringScaled(String str, FontRenderer fr, float x, float y, boolean shadow, int colour, float factor) {
        GlStateManager.func_179152_a((float)factor, (float)factor, (float)1.0f);
        fr.func_175065_a(str, x / factor, y / factor, colour, shadow);
        GlStateManager.func_179152_a((float)(1.0f / factor), (float)(1.0f / factor), (float)1.0f);
    }

    public static void drawStringRightAligned(String str, FontRenderer fr, float x, float y, boolean shadow, int colour, float factor) {
        Utils.drawStringScaled(str, x - (float)fr.func_78256_a(str) * factor, y, shadow, colour, factor);
    }

    public static void drawStringScaledFillWidth(String str, float x, float y, boolean shadow, int colour, int availableSpace) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(str);
        float scale = (float)availableSpace / (float)width;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        fr.func_175065_a(str, (float)(-width) / 2.0f, 0.0f, colour, shadow);
        GlStateManager.func_179121_F();
    }

    public static void drawStringScaledMax(String str, float x, float y, boolean shadow, int colour, float factor, int len2) {
        Utils.drawStringScaledMax(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, colour, factor, len2);
    }

    @Deprecated
    public static void drawStringScaledMax(String str, FontRenderer fr, float x, float y, boolean shadow, int colour, float factor, int len2) {
        int strLen = fr.func_78256_a(str);
        float f = (float)len2 / (float)strLen;
        factor = Math.min(factor, f);
        GlStateManager.func_179152_a((float)factor, (float)factor, (float)1.0f);
        fr.func_175065_a(str, x / factor, y / factor, colour, shadow);
        GlStateManager.func_179152_a((float)(1.0f / factor), (float)(1.0f / factor), (float)1.0f);
    }

    public static void drawStringCenteredScaledMaxWidth(String str, float x, float y, boolean shadow, int len2, int colour) {
        Utils.drawStringCenteredScaledMaxWidth(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, len2, colour);
    }

    @Deprecated
    public static void drawStringCenteredScaledMaxWidth(String str, FontRenderer fr, float x, float y, boolean shadow, int len2, int colour) {
        int strLen = fr.func_78256_a(str);
        float factor = (float)len2 / (float)strLen;
        factor = Math.min(1.0f, factor);
        int newLen = Math.min(strLen, len2);
        float fontHeight = 8.0f * factor;
        Utils.drawStringScaled(str, x - (float)(newLen / 2), y - fontHeight / 2.0f, shadow, colour, factor);
    }

    public static Matrix4f createProjectionMatrix(int width, int height) {
        Matrix4f projMatrix = new Matrix4f();
        projMatrix.setIdentity();
        projMatrix.m00 = 2.0f / (float)width;
        projMatrix.m11 = 2.0f / (float)(-height);
        projMatrix.m22 = -0.0020001999f;
        projMatrix.m33 = 1.0f;
        projMatrix.m03 = -1.0f;
        projMatrix.m13 = 1.0f;
        projMatrix.m23 = -1.0001999f;
        return projMatrix;
    }

    public static void drawStringCenteredScaled(String str, float x, float y, boolean shadow, int len2, int colour) {
        int strLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(str);
        float factor = (float)len2 / (float)strLen;
        float fontHeight = 8.0f * factor;
        Utils.drawStringScaled(str, x - (float)(len2 / 2), y - fontHeight / 2.0f, shadow, colour, factor);
    }

    public static void drawStringCenteredScaled(String str, float x, float y, boolean shadow, float factor) {
        Utils.drawStringCenteredScaled(str, Minecraft.func_71410_x().field_71466_p, x, y, shadow, factor);
    }

    @Deprecated
    public static void drawStringCenteredScaled(String str, FontRenderer fr, float x, float y, boolean shadow, float factor) {
        int strLen = fr.func_78256_a(str);
        float x2 = x - (float)strLen / 2.0f;
        float y2 = y - (float)fr.field_78288_b / 2.0f;
        Utils.drawStringScaled(str, x2, y2, shadow, 0, factor);
    }

    public static void drawStringCenteredYScaled(String str, FontRenderer fr, float x, float y, boolean shadow, int len2, int colour) {
        int strLen = fr.func_78256_a(str);
        float factor = (float)len2 / (float)strLen;
        float fontHeight = 8.0f * factor;
        Utils.drawStringScaled(str, x, y - fontHeight / 2.0f, shadow, colour, factor);
    }

    public static void drawStringCenteredYScaledMaxWidth(String str, FontRenderer fr, float x, float y, boolean shadow, int len2, int colour) {
        int strLen = fr.func_78256_a(str);
        float factor = (float)len2 / (float)strLen;
        factor = Math.min(1.0f, factor);
        float fontHeight = 8.0f * factor;
        Utils.drawStringScaled(str, x, y - fontHeight / 2.0f, shadow, colour, factor);
    }

    public static int renderStringTrimWidth(String str, boolean shadow, int x, int y, int len2, int colour, int maxLines) {
        return Utils.renderStringTrimWidth(str, shadow, x, y, len2, colour, maxLines, 1.0f);
    }

    public static int renderStringTrimWidth(String str, boolean shadow, int x, int y, int len2, int colour, int maxLines, float scale) {
        len2 = (int)((float)len2 / scale);
        int yOff = 0;
        String trimmed = Utils.trimToWidth(str, len2);
        String colourCodes = "";
        Pattern pattern = Pattern.compile("\\u00A7.");
        Matcher matcher = pattern.matcher(trimmed);
        while (matcher.find()) {
            colourCodes = colourCodes + matcher.group();
        }
        boolean firstLine = true;
        int trimmedCharacters = trimmed.length();
        int lines = 0;
        while (lines++ < maxLines || maxLines < 0) {
            if (trimmed.length() == str.length()) {
                Utils.drawStringScaled(trimmed, x, y + yOff, shadow, colour, scale);
                break;
            }
            if (trimmed.isEmpty()) {
                yOff = (int)((float)yOff - 12.0f * scale);
                break;
            }
            if (firstLine) {
                Utils.drawStringScaled(trimmed, x, y + yOff, shadow, colour, scale);
                firstLine = false;
            } else {
                if (trimmed.startsWith(" ")) {
                    trimmed = trimmed.substring(1);
                }
                Utils.drawStringScaled(colourCodes + trimmed, x, y + yOff, shadow, colour, scale);
            }
            String excess = str.substring(trimmedCharacters);
            trimmed = Utils.trimToWidth(excess, len2);
            trimmedCharacters += trimmed.length();
            yOff = (int)((float)yOff + 12.0f * scale);
        }
        return yOff;
    }

    public static String trimToWidth(String str, int len2) {
        String[] split;
        String last;
        char next2;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String trim = fr.func_78269_a(str, len2);
        if (str.length() != trim.length() && !trim.endsWith(" ") && (next2 = str.charAt(trim.length())) != ' ' && (last = (split = trim.split(" "))[split.length - 1]).length() < 8) {
            trim = trim.substring(0, trim.length() - last.length());
        }
        return trim;
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawGradientRectHorz(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawHoveringText(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth) {
        Utils.drawHoveringText(textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, Minecraft.func_71410_x().field_71466_p);
    }

    public static JsonObject getConstant(String constant, Gson gson) {
        return Utils.getConstant(constant, gson, JsonObject.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getConstant(String constant, Gson gson, Class<T> clazz) {
        File repo = NotEnoughUpdates.INSTANCE.manager.repoLocation;
        if (!repo.exists()) return null;
        File jsonFile = new File(repo, "constants/" + constant + ".json");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8));){
            T t = gson.fromJson((Reader)reader, clazz);
            return t;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static float getElementAsFloat(JsonElement element, float def2) {
        if (element == null) {
            return def2;
        }
        if (!element.isJsonPrimitive()) {
            return def2;
        }
        JsonPrimitive prim = element.getAsJsonPrimitive();
        if (!prim.isNumber()) {
            return def2;
        }
        return prim.getAsFloat();
    }

    public static int getElementAsInt(JsonElement element, int def2) {
        if (element == null) {
            return def2;
        }
        if (!element.isJsonPrimitive()) {
            return def2;
        }
        JsonPrimitive prim = element.getAsJsonPrimitive();
        if (!prim.isNumber()) {
            return def2;
        }
        return prim.getAsInt();
    }

    public static long getElementAsLong(JsonElement element, long def2) {
        if (element == null) {
            return def2;
        }
        if (!element.isJsonPrimitive()) {
            return def2;
        }
        JsonPrimitive prim = element.getAsJsonPrimitive();
        if (!prim.isNumber()) {
            return def2;
        }
        return prim.getAsLong();
    }

    public static String getElementAsString(JsonElement element, String def2) {
        if (element == null) {
            return def2;
        }
        if (!element.isJsonPrimitive()) {
            return def2;
        }
        JsonPrimitive prim = element.getAsJsonPrimitive();
        if (!prim.isString()) {
            return def2;
        }
        return prim.getAsString();
    }

    public static boolean getElementAsBool(JsonElement element, boolean def2) {
        if (element == null) {
            return def2;
        }
        if (!element.isJsonPrimitive()) {
            return def2;
        }
        JsonPrimitive prim = element.getAsJsonPrimitive();
        if (!prim.isBoolean()) {
            return def2;
        }
        return prim.getAsBoolean();
    }

    public static JsonElement getElement(JsonElement element, String path) {
        List path_split = PATH_SPLITTER.splitToList((CharSequence)path);
        if (element instanceof JsonObject) {
            JsonElement e2 = element.getAsJsonObject().get((String)path_split.get(0));
            if (path_split.size() > 1) {
                return Utils.getElement(e2, (String)path_split.get(1));
            }
            return e2;
        }
        return element;
    }

    public static JsonElement getElementOrDefault(JsonElement element, String path, JsonElement def2) {
        JsonElement result2 = Utils.getElement(element, path);
        return result2 != null ? result2 : def2;
    }

    public static ChatStyle createClickStyle(ClickEvent.Action action, String value) {
        ChatStyle style = new ChatStyle();
        style.func_150241_a(new ClickEvent(action, value));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + value)));
        return style;
    }

    public static ChatStyle createClickStyle(ClickEvent.Action action, String value, String message) {
        ChatStyle style = Utils.createClickStyle(action, value);
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(message)));
        return style;
    }

    public static void recursiveDelete(File file) {
        if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
            for (File child : file.listFiles()) {
                Utils.recursiveDelete(child);
            }
        }
        file.delete();
    }

    public static char getPrimaryColourCode(String displayName) {
        int lastColourCode = -99;
        int currentColour = 0;
        int colourIndex = 0;
        int[] mostCommon = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (c == '\u00a7') {
                lastColourCode = i;
                continue;
            }
            if (lastColourCode == i - 1) {
                colourIndex = "0123456789abcdef".indexOf(c);
                if (colourIndex == -1) continue;
                currentColour = colourIndex;
                continue;
            }
            if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) < 0 || currentColour <= 0) continue;
            int n = currentColour;
            mostCommon[n] = mostCommon[n] + 1;
        }
        int mostCommonCount = 0;
        for (int index = 0; index < mostCommon.length; ++index) {
            if (mostCommon[index] <= mostCommonCount) continue;
            mostCommonCount = mostCommon[index];
            currentColour = index;
        }
        return "0123456789abcdef".charAt(currentColour);
    }

    public static Color getPrimaryColour(String displayName) {
        int colourInt = Minecraft.func_71410_x().field_71466_p.func_175064_b(Utils.getPrimaryColourCode(displayName));
        return new Color(colourInt).darker();
    }

    public static void scrollTooltip(int dY) {
        scrollY.setTarget(scrollY.getTarget() + (float)dY / 10.0f);
        scrollY.resetTimer();
    }

    @Deprecated
    public static void drawHoveringText(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        if (!textLines.isEmpty()) {
            int borderColorStart = 0x505000FF;
            if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.tooltipBorderColours && !textLines.isEmpty()) {
                String first = textLines.get(0);
                borderColorStart = Utils.getPrimaryColour(first).getRGB() & 0xFFFFFF | NotEnoughUpdates.INSTANCE.config.tooltipTweaks.tooltipBorderOpacity << 24;
            }
            textLines = TooltipTextScrolling.handleTextLineRendering(textLines);
            if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale != 0) {
                ScaledResolution scaledResolution = Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale);
                mouseX = Mouse.getX() * scaledResolution.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
                mouseY = scaledResolution.func_78328_b() - Mouse.getY() * scaledResolution.func_78328_b() / Minecraft.func_71410_x().field_71440_d;
                screenWidth = scaledResolution.func_78326_a();
                screenHeight = scaledResolution.func_78328_b();
            }
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179126_j();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.scrollableTooltips) {
                if (tooltipHeight + 6 > screenHeight) {
                    if (scrollY.getTarget() < 0.0f) {
                        scrollY.setTarget(0.0f);
                        scrollY.resetTimer();
                    } else if (screenHeight - tooltipHeight - 12 + (int)scrollY.getTarget() > 0) {
                        scrollY.setTarget(-screenHeight + tooltipHeight + 12);
                        scrollY.resetTimer();
                    }
                } else {
                    scrollY.setValue(0.0f);
                    scrollY.resetTimer();
                }
                scrollY.tick();
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6 + (int)scrollY.getValue();
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            Utils.drawGradientRect(300, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, -267386864, -267386864);
            Utils.drawGradientRect(300, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, -267386864, -267386864);
            Utils.drawGradientRect(300, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            Utils.drawGradientRect(300, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            Utils.drawGradientRect(300, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            Utils.drawGradientRect(300, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            Utils.drawGradientRect(300, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            Utils.drawGradientRect(300, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
            Utils.drawGradientRect(300, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
            GlStateManager.func_179097_i();
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line;
                line = textLines.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale != 0) {
                Utils.pushGuiScale(0);
            }
        }
        GlStateManager.func_179140_f();
    }

    public static void drawGradientRect(int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawRectNoBlend(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void drawRect(float left, float top, float right, float bottom, int color) {
        float i;
        if (left < right) {
            i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            i = top;
            top = bottom;
            bottom = i;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float j = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)g, (float)h, (float)j, (float)f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawHoverOverlay(int x, int y) {
        Utils.drawHoverOverlay(x, y, 16, 16);
    }

    public static void drawHoverOverlay(int x, int y, int width, int height) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Utils.drawGradientRect(x, y, x + 16, y + 16, -2130706433, -2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static String prettyTime(Duration time) {
        return Utils.prettyTime(time.toMillis());
    }

    public static String prettyTime(long millis) {
        long seconds = millis / 1000L % 60L;
        long minutes = millis / 1000L / 60L % 60L;
        long hours = millis / 1000L / 60L / 60L % 24L;
        long days = millis / 1000L / 60L / 60L / 24L;
        String endsIn = "";
        endsIn = millis < 0L ? endsIn + "Ended!" : (minutes == 0L && hours == 0L && days == 0L ? endsIn + seconds + "s" : (hours == 0L && days == 0L ? endsIn + minutes + "m" + seconds + "s" : (days == 0L ? (hours <= 6L ? endsIn + hours + "h" + minutes + "m" + seconds + "s" : endsIn + hours + "h") : endsIn + days + "d" + hours + "h")));
        return endsIn;
    }

    public static void drawLine(float sx, float sy, float ex, float ey, int width, int color) {
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)sx, (double)sy);
        GL11.glVertex2d((double)ex, (double)ey);
        GL11.glEnd();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void drawDottedLine(float sx, float sy, float ex, float ey, int width, int factor, int color) {
        GlStateManager.func_179094_E();
        GL11.glLineStipple((int)factor, (short)-21846);
        GL11.glEnable((int)2852);
        Utils.drawLine(sx, sy, ex, ey, width, color);
        GL11.glDisable((int)2852);
        GlStateManager.func_179121_F();
    }

    public static void drawTexturedQuad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float uMin, float uMax, float vMin, float vMax, int filter) {
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x1, (double)y1, 0.0).func_181673_a((double)uMin, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)x2, (double)y2, 0.0).func_181673_a((double)uMax, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)x3, (double)y3, 0.0).func_181673_a((double)uMax, (double)vMin).func_181675_d();
        worldrenderer.func_181662_b((double)x4, (double)y4, 0.0).func_181673_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179084_k();
    }

    public static boolean sendCloseScreenPacket() {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer.field_71070_bA == null) {
            return false;
        }
        thePlayer.field_71174_a.func_147297_a((Packet)new C0DPacketCloseWindow(thePlayer.field_71070_bA.field_75152_c));
        return true;
    }

    public static String formatNumberWithDots(long number2) {
        if (number2 == 0L) {
            return "0";
        }
        String work = "";
        boolean isNegative = false;
        if (number2 < 0L) {
            isNegative = true;
            number2 = -number2;
        }
        while (number2 != 0L) {
            work = String.format("%03d.%s", number2 % 1000L, work);
            number2 /= 1000L;
        }
        work = work.substring(0, work.length() - 1);
        while (work.startsWith("0")) {
            work = work.substring(1);
        }
        if (isNegative) {
            return "-" + work;
        }
        return work;
    }

    public static int getMouseY() {
        int height = Utils.peekGuiScale().func_78328_b();
        return height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
    }

    public static int getMouseX() {
        return Mouse.getX() * Utils.peekGuiScale().func_78326_a() / Minecraft.func_71410_x().field_71443_c;
    }

    public static boolean isWithinRect(int x, int y, int left, int top, int width, int height) {
        return left <= x && x < left + width && top <= y && y < top + height;
    }

    public static boolean isWithinRect(int x, int y, Rectangle rectangle) {
        return Utils.isWithinRect(x, y, rectangle.getLeft(), rectangle.getTop(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static int getNumberOfStars(ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b("ExtraAttributes", 10)) {
            NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
            if (ea.func_150297_b("upgrade_level", 99)) {
                return ea.func_74762_e("upgrade_level");
            }
            if (ea.func_74764_b("dungeon_item_level")) {
                return ea.func_74762_e("dungeon_item_level");
            }
        }
        return -1;
    }

    public static String getStarsString(int stars) {
        EnumChatFormatting colorCode = null;
        EnumChatFormatting defaultColorCode = EnumChatFormatting.GOLD;
        int amount = 0;
        if (stars > 5 && stars < 11) {
            colorCode = EnumChatFormatting.LIGHT_PURPLE;
            amount = stars - 5;
            stars = 5;
        }
        if (stars > 10) {
            colorCode = EnumChatFormatting.AQUA;
            defaultColorCode = EnumChatFormatting.LIGHT_PURPLE;
            amount = stars - 10;
            stars = 5;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stars; ++i) {
            if (i < amount) {
                stringBuilder.append(colorCode).append('\u272a');
                continue;
            }
            stringBuilder.append(defaultColorCode).append('\u272a');
        }
        return stringBuilder.toString();
    }

    public static void showOutdatedRepoNotification(String missingFile) {
        Utils.showOutdatedRepoNotification(missingFile, null);
    }

    public static void showOutdatedRepoNotification(String missingFile, Throwable exception) {
        if (NotEnoughUpdates.INSTANCE.config.notifications.outdatedRepo) {
            NotificationHandler.displayNotification(Lists.newArrayList((Object[])new String[]{"\u00a7c\u00a7lMissing repo data", "\u00a7cData used for many NEU features is not up to date, this should normally not be the case.", "\u00a7cYou can try \u00a7l/neuresetrepo\u00a7r\u00a7c and restart your game to see if that fixes the issue.", "\u00a7cIf the problem persists please join \u00a7l" + Utils.getDiscordInvite() + "\u00a7r\u00a7c and message in \u00a7l#neu-support\u00a7r\u00a7c to get support"}), false, true);
        }
        if (System.currentTimeMillis() - lastError > 1000L) {
            NotEnoughUpdates.LOGGER.error("Repo issue: " + missingFile, exception);
            lastError = System.currentTimeMillis();
        }
    }

    public static int getRarityFromLore(JsonArray lore) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = lore.get(i).getAsString();
            for (int j = 0; j < rarityArrC.length; ++j) {
                if (!line.startsWith(rarityArrC[j])) continue;
                return j;
            }
        }
        return -1;
    }

    public static UUID parseDashlessUUID(String dashlessUuid) {
        BigInteger most = new BigInteger(dashlessUuid.substring(0, 16), 16);
        BigInteger least = new BigInteger(dashlessUuid.substring(16, 32), 16);
        return new UUID(most.longValue(), least.longValue());
    }

    @NotNull
    public static String getOpenChestName() {
        return SBInfo.getInstance().currentlyOpenChestName;
    }

    public static String getLastOpenChestName() {
        return SBInfo.getInstance().lastOpenChestName;
    }

    public static String getNameFromChatComponent(IChatComponent chatComponent) {
        String unformattedText = Utils.cleanColour(((IChatComponent)chatComponent.func_150253_a().get(0)).func_150260_c());
        Matcher matcher = GUILD_OR_PARTY_MESSAGE_PATTERN.matcher(unformattedText);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        System.out.println("[NEU] getNameFromChatComponent ERROR: " + unformattedText);
        return "idk_bruh";
    }

    public static void addChatMessage(@NotNull String message) {
        Utils.addChatMessage((IChatComponent)new ChatComponentText(message));
    }

    public static void addClickableChatMessage(@NotNull String message, @NotNull String command2, @Nullable String hoverText) {
        if (hoverText == null) {
            hoverText = "\u00a7eClick to run \u00a7a" + command2;
        }
        Utils.addChatMessage(new ChatComponentText(message).func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command2)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(hoverText)))));
    }

    public static void addChatMessage(@NotNull IChatComponent message) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer != null) {
            thePlayer.func_145747_a(message);
        } else {
            System.out.println(message);
        }
    }

    public static boolean openUrl(String url) {
        try {
            Desktop desk = Desktop.getDesktop();
            desk.browse(new URI(url));
            return true;
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException ignored) {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + url);
                return true;
            }
            catch (IOException e2) {
                Utils.playSound(new ResourceLocation("game.player.hurt"), true);
                return false;
            }
        }
    }

    public static void sendLeftMouseClick(int windowId, int slot) {
        Minecraft.func_71410_x().field_71442_b.func_78753_a(windowId, slot, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public static void sendMiddleMouseClick(int windowId, int slot) {
        Minecraft.func_71410_x().field_71442_b.func_78753_a(windowId, slot, 2, 3, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public static String timeSinceMillisecond(long time) {
        Instant lastSave = Instant.ofEpochMilli(time);
        LocalDateTime lastSaveTime = LocalDateTime.ofInstant(lastSave, TimeZone.getDefault().toZoneId());
        long timeDiff = System.currentTimeMillis() - lastSave.toEpochMilli();
        LocalDateTime sinceOnline = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeDiff), ZoneId.of("UTC"));
        String renderText = timeDiff < 60000L ? sinceOnline.getSecond() + " seconds ago" : (timeDiff < 3600000L ? sinceOnline.getMinute() + " minutes ago" : (timeDiff < 86400000L ? sinceOnline.getHour() + " hours ago" : (timeDiff < 31556952000L ? sinceOnline.getDayOfYear() + " days ago" : lastSaveTime.format(DateTimeFormatter.ofPattern("dd-MM-yyyy")))));
        return renderText;
    }

    public static boolean canPetBeTierBoosted(PetInfoOverlay.Pet pet, PetInfoOverlay.Rarity rarityToBeBoostedTo) {
        if (rarityToBeBoostedTo == null) {
            return false;
        }
        ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(pet.petType + ";" + rarityToBeBoostedTo.petId).resolveToItemStack(false);
        return itemStack != null;
    }

    public static void copyToClipboard(String str) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), null);
    }

    public static void copyToClipboard(StringSelection stringSelection, ClipboardOwner owner) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, owner);
    }

    public static String getClipboard() {
        if (System.currentTimeMillis() - lastClipboard < 500L) {
            return clipboardCache;
        }
        lastClipboard = System.currentTimeMillis();
        try {
            Transferable clipboard = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (clipboard != null && clipboard.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String clipboardText;
                clipboardCache = clipboardText = (String)clipboard.getTransferData(DataFlavor.stringFlavor);
                return clipboardText;
            }
            clipboardCache = null;
            return null;
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException | IllegalStateException ignored) {
            clipboardCache = null;
            return null;
        }
    }

    public static String getDiscordInvite() {
        if (NotEnoughUpdates.INSTANCE.manager.onBackupRepo) {
            return "discord.gg/tNSkq8KjA8";
        }
        JsonObject misc = Constants.MISC;
        if (misc == null || !misc.has("discordInvite")) {
            return "discord.gg/tNSkq8KjA8";
        }
        return "discord.gg/" + misc.get("discordInvite").getAsString();
    }
}

