/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public class ModelFluid
implements IModelCustomData<ModelFluid> {
    public static final ModelFluid waterModel = new ModelFluid(FluidRegistry.WATER);
    public static final ModelFluid lavaModel = new ModelFluid(FluidRegistry.LAVA);
    private final Fluid fluid;

    public ModelFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public Collection<jy> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public Collection<jy> getTextures() {
        return ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing());
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        ImmutableMap<bgr.b, TRSRTransformation> map = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        return new BakedFluid(state.apply((Optional<? extends IModelPart>)Optional.absent()), map, format, this.fluid.getColor(), (bmi)bakedTextureGetter.apply((Object)this.fluid.getStill()), (bmi)bakedTextureGetter.apply((Object)this.fluid.getFlowing()), this.fluid.isGaseous(), (Optional<IExtendedBlockState>)Optional.absent());
    }

    @Override
    public IModelState getDefaultState() {
        return bor.a;
    }

    @Override
    public IModel process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"fluid")) {
            return this;
        }
        String fluidStr = (String)customData.get((Object)"fluid");
        JsonElement e = new JsonParser().parse(fluidStr);
        String fluid = e.getAsString();
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FMLLog.severe("fluid '%s' not found", fluid);
            return waterModel;
        }
        return new ModelFluid(FluidRegistry.getFluid(fluid));
    }

    public static class BakedFluid
    implements IFlexibleBakedModel,
    ISmartBlockModel,
    IPerspectiveAwareModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) throws Exception {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                return new BakedFluid((Optional<TRSRTransformation>)BakedFluid.this.transformation, (ImmutableMap<bgr.b, TRSRTransformation>)BakedFluid.this.transforms, BakedFluid.this.format, BakedFluid.this.color, BakedFluid.this.still, BakedFluid.this.flowing, BakedFluid.this.gas, statePresent, cornerRound, flowRound);
            }
        });
        private final Optional<TRSRTransformation> transformation;
        private final ImmutableMap<bgr.b, TRSRTransformation> transforms;
        private final bmu format;
        private final int color;
        private final bmi still;
        private final bmi flowing;
        private final boolean gas;
        private final EnumMap<cq, List<bgg>> faceQuads;

        public BakedFluid(Optional<TRSRTransformation> transformation, bmu format, int color, bmi still, bmi flowing, boolean gas) {
            this(transformation, format, color, still, flowing, gas, (Optional<IExtendedBlockState>)Optional.absent());
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, bmu format, int color, bmi still, bmi flowing, boolean gas, Optional<IExtendedBlockState> stateOption) {
            this(transformation, (ImmutableMap<bgr.b, TRSRTransformation>)ImmutableMap.of(), format, color, still, flowing, gas, stateOption);
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<bgr.b, TRSRTransformation> transforms, bmu format, int color, bmi still, bmi flowing, boolean gas, Optional<IExtendedBlockState> stateOption) {
            this(transformation, transforms, format, color, still, flowing, gas, stateOption.isPresent(), BakedFluid.getCorners(stateOption), BakedFluid.getFlow(stateOption));
        }

        private static int[] getCorners(Optional<IExtendedBlockState> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IExtendedBlockState state = (IExtendedBlockState)stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Float level = state.getValue(BlockFluidBase.LEVEL_CORNERS[i]);
                    cornerRound[i] = Math.round((level == null ? 0.875f : level.floatValue()) * 768.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IExtendedBlockState> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = ((IExtendedBlockState)stateOption.get()).getValue(BlockFluidBase.FLOW_DIRECTION)) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = ns.a((int)flowRound, (int)-1000, (int)1000);
            return flowRound;
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<bgr.b, TRSRTransformation> transforms, bmu format, int color, bmi still, bmi flowing, boolean gas, boolean statePresent, int[] cornerRound, int flowRound) {
            int i;
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.gas = gas;
            this.faceQuads = Maps.newEnumMap(cq.class);
            for (cq side : cq.values()) {
                this.faceQuads.put(side, (List<bgg>)ImmutableList.of());
            }
            if (statePresent) {
                int i2;
                float[] y = new float[4];
                for (i = 0; i < 4; ++i) {
                    y[i] = gas ? 1.0f - (float)cornerRound[i] / 768.0f : (float)cornerRound[i] / 768.0f;
                }
                float flow = (float)Math.toRadians(flowRound);
                bmi topSprite = flowing;
                float scale = 4.0f;
                if (flow < -17.0f) {
                    flow = 0.0f;
                    scale = 8.0f;
                    topSprite = still;
                }
                float c2 = ns.b((float)flow) * scale;
                float s = ns.a((float)flow) * scale;
                cq side = gas ? cq.a : cq.b;
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setQuadColored();
                for (i2 = gas ? 3 : 0; i2 != (gas ? -1 : 4); i2 += gas ? -1 : 1) {
                    this.putVertex(builder, side, x[i2], y[i2], z[i2], topSprite.a((double)(8.0f + c2 * (float)(x[i2] * 2 - 1) + s * (float)(z[i2] * 2 - 1))), topSprite.b((double)(8.0f + c2 * (float)(x[(i2 + 1) % 4] * 2 - 1) + s * (float)(z[(i2 + 1) % 4] * 2 - 1))));
                }
                this.faceQuads.put(side, (List<bgg>)ImmutableList.of((Object)((Object)builder.build())));
                side = side.d();
                builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setQuadColored();
                for (i2 = gas ? 3 : 0; i2 != (gas ? -1 : 4); i2 += gas ? -1 : 1) {
                    this.putVertex(builder, side, z[i2], gas ? 1.0f : 0.0f, x[i2], still.a((double)(z[i2] * 16)), still.b((double)(x[i2] * 16)));
                }
                this.faceQuads.put(side, (List<bgg>)ImmutableList.of((Object)((Object)builder.build())));
                for (i2 = 0; i2 < 4; ++i2) {
                    side = cq.b((int)((5 - i2) % 4));
                    bgg[] q = new bgg[2];
                    for (int k2 = 0; k2 < 2; ++k2) {
                        builder = new UnpackedBakedQuad.Builder(format);
                        builder.setQuadOrientation(side);
                        builder.setQuadColored();
                        for (int j2 = 0; j2 < 4; ++j2) {
                            int l = k2 * 3 + (1 - 2 * k2) * j2;
                            float yl = (float)z[l] * y[(i2 + x[l]) % 4];
                            if (gas && z[l] == 0) {
                                yl = 1.0f;
                            }
                            this.putVertex(builder, side, x[(i2 + x[l]) % 4], yl, z[(i2 + x[l]) % 4], flowing.a((double)(x[l] * 8)), flowing.b((double)((gas ? yl : 1.0f - yl) * 8.0f)));
                        }
                        q[k2] = builder.build();
                    }
                    this.faceQuads.put(side, (List<bgg>)ImmutableList.of((Object)q[0], (Object)q[1]));
                }
            } else {
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(cq.b);
                builder.setQuadColored();
                for (i = 0; i < 4; ++i) {
                    this.putVertex(builder, cq.b, z[i], x[i], 0.0f, still.a((double)(z[i] * 16)), still.b((double)(x[i] * 16)));
                }
                this.faceQuads.put(cq.d, (List<bgg>)ImmutableList.of((Object)((Object)builder.build())));
            }
        }

        private void putVertex(UnpackedBakedQuad.Builder builder, cq side, float x, float y, float z, float u, float v) {
            block6: for (int e = 0; e < this.format.i(); ++e) {
                switch (this.format.c(e).b()) {
                    case a: {
                        float[] data = new float[]{x - (float)side.m().n() * 0.001f, y, z - (float)side.m().p() * 0.001f, 1.0f};
                        if (this.transformation.isPresent() && this.transformation.get() != TRSRTransformation.identity()) {
                            Vector4f vec = new Vector4f(data);
                            ((TRSRTransformation)this.transformation.get()).getMatrix().transform((Tuple4f)vec);
                            vec.get(data);
                        }
                        builder.put(e, data);
                        continue block6;
                    }
                    case c: {
                        float d2 = LightUtil.diffuseLight(side);
                        builder.put(e, d2 * (float)(this.color >> 16 & 0xFF) / 255.0f, d2 * (float)(this.color >> 8 & 0xFF) / 255.0f, d2 * (float)(this.color & 0xFF) / 255.0f, (float)(this.color >> 24 & 0xFF) / 255.0f);
                        continue block6;
                    }
                    case d: {
                        if (this.format.c(e).d() == 0) {
                            builder.put(e, u, v, 0.0f, 1.0f);
                            continue block6;
                        }
                    }
                    case b: {
                        builder.put(e, side.g(), side.h(), side.i(), 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public boolean d() {
            return false;
        }

        public bmi e() {
            return this.still;
        }

        public bgr f() {
            return bgr.a;
        }

        public List<bgg> a(cq side) {
            return this.faceQuads.get(side);
        }

        public List<bgg> a() {
            return ImmutableList.of();
        }

        @Override
        public bmu getFormat() {
            return this.format;
        }

        @Override
        public boq handleBlockState(alz state) {
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)state;
                int[] cornerRound = BakedFluid.getCorners((Optional<IExtendedBlockState>)Optional.of((Object)exState));
                int flowRound = BakedFluid.getFlow((Optional<IExtendedBlockState>)Optional.of((Object)exState));
                long key = flowRound + 1024;
                for (int i = 3; i >= 0; --i) {
                    key <<= 10;
                    key |= (long)cornerRound[i];
                }
                key <<= 1;
                return (boq)this.modelCache.getUnchecked((Object)(key |= 1L));
            }
            return this;
        }

        @Override
        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(bgr.b type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, type);
        }
    }

    public static enum FluidLoader implements ICustomModelLoader
    {
        instance;


        public void a(bni resourceManager) {
        }

        @Override
        public boolean accepts(jy modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("fluid") || modelLocation.a().equals("models/block/fluid") || modelLocation.a().equals("models/item/fluid"));
        }

        @Override
        public IModel loadModel(jy modelLocation) {
            return waterModel;
        }
    }
}

