/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class MultiLayerModel
implements IModelCustomData<MultiLayerModel> {
    public static final MultiLayerModel instance = new MultiLayerModel((ImmutableMap<Optional<adf>, bov>)ImmutableMap.of());
    private final ImmutableMap<Optional<adf>, bov> models;

    public MultiLayerModel(ImmutableMap<Optional<adf>, bov> models) {
        this.models = models;
    }

    @Override
    public Collection<jy> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<jy> getTextures() {
        return ImmutableList.of();
    }

    private static ImmutableMap<Optional<adf>, IFlexibleBakedModel> buildModels(ImmutableMap<Optional<adf>, bov> models, IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model;
            try {
                model = ModelLoaderRegistry.getModel((jy)models.get((Object)key));
            }
            catch (IOException e) {
                FMLLog.log(Level.ERROR, e, "Couldn't load MultiLayerModel dependency: %s", models.get((Object)key));
                model = ModelLoaderRegistry.getMissingModel();
            }
            builder.put((Object)key, (Object)model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), format, IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public IModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (adf layer : adf.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)layer), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return instance;
        }
        return new MultiLayerModel((ImmutableMap<Optional<adf>, bov>)models);
    }

    private bov getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new bov(e.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new bov("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        instance;


        public void a(bni resourceManager) {
        }

        @Override
        public boolean accepts(jy modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(jy modelLocation) {
            return instance;
        }
    }

    public static class MultiLayerBakedModel
    implements IFlexibleBakedModel,
    ISmartBlockModel,
    IPerspectiveAwareModel {
        private final ImmutableMap<Optional<adf>, IFlexibleBakedModel> models;
        private final bmu format;
        private final ImmutableMap<bgr.b, TRSRTransformation> cameraTransforms;
        private final IFlexibleBakedModel base;
        private final IFlexibleBakedModel missing;
        private final ImmutableMap<Optional<cq>, ImmutableList<bgg>> quads;
        private static final Function<jy, bmi> defaultTextureGetter = new Function<jy, bmi>(){

            public bmi apply(jy location) {
                return ave.A().T().a(location.toString());
            }
        };

        @Deprecated
        public MultiLayerBakedModel(ImmutableMap<Optional<adf>, bov> models, bmu format, ImmutableMap<bgr.b, TRSRTransformation> cameraTransforms) {
            this((ImmutableMap<Optional<adf>, IFlexibleBakedModel>)MultiLayerModel.buildModels((ImmutableMap<Optional<adf>, bov>)models, TRSRTransformation.identity(), format, (Function<jy, bmi>)MultiLayerBakedModel.defaultTextureGetter), ModelLoaderRegistry.getMissingModel().bake(ModelLoaderRegistry.getMissingModel().getDefaultState(), format, defaultTextureGetter), format, cameraTransforms);
        }

        public MultiLayerBakedModel(ImmutableMap<Optional<adf>, IFlexibleBakedModel> models, IFlexibleBakedModel missing, bmu format, ImmutableMap<bgr.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.format = format;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.containsKey((Object)Optional.absent()) ? (IFlexibleBakedModel)models.get((Object)Optional.absent()) : missing;
            ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
            quadBuilder.put((Object)Optional.absent(), MultiLayerBakedModel.buildQuads(models, (Optional<cq>)Optional.absent()));
            for (cq side : cq.values()) {
                quadBuilder.put((Object)Optional.of((Object)side), MultiLayerBakedModel.buildQuads(models, (Optional<cq>)Optional.of((Object)side)));
            }
            this.quads = quadBuilder.build();
        }

        private static ImmutableList<bgg> buildQuads(ImmutableMap<Optional<adf>, IFlexibleBakedModel> models, Optional<cq> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (boq model : models.values()) {
                if (side.isPresent()) {
                    builder.addAll((Iterable)model.a((cq)side.get()));
                    continue;
                }
                builder.addAll((Iterable)model.a());
            }
            return builder.build();
        }

        public List<bgg> a(cq side) {
            return (List)this.quads.get((Object)Optional.of((Object)side));
        }

        public List<bgg> a() {
            return (List)this.quads.get((Object)Optional.absent());
        }

        public boolean b() {
            return this.base.b();
        }

        public boolean c() {
            return this.base.c();
        }

        public boolean d() {
            return this.base.d();
        }

        public bmi e() {
            return this.base.e();
        }

        public bgr f() {
            return bgr.a;
        }

        @Override
        public boq handleBlockState(alz state) {
            Optional layer = Optional.of((Object)MinecraftForgeClient.getRenderLayer());
            if (!this.models.containsKey((Object)layer)) {
                return this.missing;
            }
            return (boq)this.models.get((Object)layer);
        }

        @Override
        public bmu getFormat() {
            return this.format;
        }

        @Override
        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(bgr.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.cameraTransforms, cameraTransformType);
        }
    }
}

