/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.ForgeTimeTracker;

public class ForgeCommand
extends i {
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000");
    private WeakReference<MinecraftServer> server;

    public ForgeCommand(MinecraftServer server) {
        this.server = new WeakReference<MinecraftServer>(server);
    }

    public String c() {
        return "forge";
    }

    public String c(m icommandsender) {
        return "commands.forge.usage";
    }

    public int a() {
        return 2;
    }

    public void a(m sender, String[] args) throws bz {
        if (args.length == 0) {
            throw new cf("commands.forge.usage", new Object[0]);
        }
        if ("help".equals(args[0])) {
            throw new cf("commands.forge.usage", new Object[0]);
        }
        if ("tps".equals(args[0])) {
            this.displayTPS(sender, args);
        } else if ("tpslog".equals(args[0])) {
            this.doTPSLog(sender, args);
        } else if ("track".equals(args[0])) {
            this.handleTracking(sender, args);
        } else {
            throw new cf("commands.forge.usage", new Object[0]);
        }
    }

    public List<String> a(m sender, String[] args, cj pos) {
        if (args.length == 1) {
            return ForgeCommand.a((String[])args, (String[])new String[]{"tps", "track"});
        }
        if (args.length == 2) {
            if ("tps".equals(args[0])) {
                return ForgeCommand.a((String[])args, this.getServer().worldTickTimes.keySet());
            }
            if ("track".equals(args[0])) {
                return ForgeCommand.a((String[])args, (String[])new String[]{"te"});
            }
        }
        return null;
    }

    private void handleTracking(m sender, String[] args) throws bz {
        if (args.length != 3) {
            throw new cf("commands.forge.usage.tracking", new Object[0]);
        }
        String type = args[1];
        int duration = ForgeCommand.a((String)args[2], (int)1, (int)60);
        if (!"te".equals(type)) {
            throw new cf("commands.forge.usage.tracking", new Object[0]);
        }
        this.doTurnOnTileEntityTracking(sender, duration);
    }

    private void doTurnOnTileEntityTracking(m sender, int duration) {
        ForgeTimeTracker.tileEntityTrackingDuration = duration;
        ForgeTimeTracker.tileEntityTracking = true;
        sender.a((eu)new fb("commands.forge.tracking.te.enabled", new Object[]{duration}));
    }

    private void doTPSLog(m sender, String[] args) {
    }

    private void displayTPS(m sender, String[] args) throws bz {
        int dim = 0;
        boolean summary = true;
        if (args.length > 1) {
            dim = ForgeCommand.a((String)args[1]);
            summary = false;
        }
        if (summary) {
            for (Integer dimId : DimensionManager.getIDs()) {
                double worldTickTime = (double)ForgeCommand.mean((long[])this.getServer().worldTickTimes.get(dimId)) * 1.0E-6;
                double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
                sender.a((eu)new fb("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dimId), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
            }
            double meanTickTime = (double)ForgeCommand.mean(this.getServer().h) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            sender.a((eu)new fb("commands.forge.tps.summary", new Object[]{"Overall", timeFormatter.format(meanTickTime), timeFormatter.format(meanTPS)}));
        } else {
            double worldTickTime = (double)ForgeCommand.mean((long[])this.getServer().worldTickTimes.get(dim)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            sender.a((eu)new fb("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dim), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
        }
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private MinecraftServer getServer() {
        return (MinecraftServer)this.server.get();
    }
}

