/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;

public class MinecraftForgeClient {
    private static BitSet stencilBits = new BitSet(8);
    private static final LoadingCache<Pair<adm, cj>, bff> regionCache;

    public static int getRenderPass() {
        return ForgeHooksClient.renderPass;
    }

    public static adf getRenderLayer() {
        return ForgeHooksClient.renderLayer.get();
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < stencilBits.length()) {
            stencilBits.set(bit);
        }
    }

    public static void onRebuildChunk(adm world, cj position, bff cache) {
        regionCache.put((Object)Pair.of((Object)world, (Object)position), (Object)cache);
    }

    public static bff getRegionRenderCache(adm world, cj pos) {
        int x = pos.n() & 0xFFFFFFF0;
        int y = pos.o() & 0xFFFFFFF0;
        int z = pos.p() & 0xFFFFFFF0;
        return (bff)regionCache.getUnchecked((Object)Pair.of((Object)world, (Object)new cj(x, y, z)));
    }

    static {
        stencilBits.set(0, 8);
        regionCache = CacheBuilder.newBuilder().maximumSize(500L).concurrencyLevel(5).expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<adm, cj>, bff>(){

            public bff load(Pair<adm, cj> key) throws Exception {
                return new bff((adm)key.getLeft(), ((cj)key.getRight()).a(-1, -1, -1), ((cj)key.getRight()).a(16, 16, 16), 1);
            }
        });
    }
}

