/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;

public class GuiSlotModList
extends GuiScrollingList {
    private GuiModList parent;
    private ArrayList<ModContainer> mods;

    public GuiSlotModList(GuiModList parent, ArrayList<ModContainer> mods, int listWidth) {
        super(parent.getMinecraftInstance(), listWidth, parent.m, 32, parent.m - 88 + 4, 10, 35, parent.l, parent.m);
        this.parent = parent;
        this.mods = mods;
    }

    @Override
    protected int getSize() {
        return this.mods.size();
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectModIndex(index);
    }

    @Override
    protected boolean isSelected(int index) {
        return this.parent.modIndexSelected(index);
    }

    @Override
    protected void drawBackground() {
        this.parent.c();
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * 35 + 1;
    }

    ArrayList<ModContainer> getMods() {
        return this.mods;
    }

    @Override
    protected void drawSlot(int idx, int right, int top, int height, bfx tess) {
        ModContainer mc = this.mods.get(idx);
        String name = nx.a((String)mc.getName());
        String version = nx.a((String)mc.getDisplayVersion());
        avn font = this.parent.getFontRenderer();
        ForgeVersion.CheckResult vercheck = ForgeVersion.getResult(mc);
        if (Loader.instance().getModState(mc) == LoaderState.ModState.DISABLED) {
            font.a(font.a(name, this.listWidth - 10), this.left + 3, top + 2, 0xFF2222);
            font.a(font.a(version, this.listWidth - 10), this.left + 3, top + 12, 0xFF2222);
            font.a(font.a("DISABLED", this.listWidth - 10), this.left + 3, top + 22, 0xFF2222);
        } else {
            font.a(font.a(name, this.listWidth - 10), this.left + 3, top + 2, 0xFFFFFF);
            font.a(font.a(version, this.listWidth - 10), this.left + 3, top + 12, 0xCCCCCC);
            font.a(font.a(mc.getMetadata() != null ? mc.getMetadata().getChildModCountString() : "Metadata not found", this.listWidth - 10), this.left + 3, top + 22, 0xCCCCCC);
            switch (vercheck.status) {
                case BETA_OUTDATED: 
                case OUTDATED: {
                    font.a("U", right - font.a('U') - 1, top + height - font.a + 2, 0x22FF22);
                    break;
                }
            }
        }
    }
}

