/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class FMLNetworkEvent<T extends ep>
extends Event {
    public final T handler;
    public final ek manager;
    private final Class<T> type;

    FMLNetworkEvent(T thing, Class<T> type, ek manager) {
        this.handler = thing;
        this.type = type;
        this.manager = manager;
    }

    public Class<T> getHandlerType() {
        return this.type;
    }

    public static class CustomNetworkEvent
    extends Event {
        public final Object wrappedEvent;

        public CustomNetworkEvent(Object wrappedEvent) {
            this.wrappedEvent = wrappedEvent;
        }
    }

    public static class ServerCustomPacketEvent
    extends CustomPacketEvent<ic> {
        public ServerCustomPacketEvent(ek manager, FMLProxyPacket packet) {
            super((ic)manager.i(), ic.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.SERVER;
        }
    }

    public static class ClientCustomPacketEvent
    extends CustomPacketEvent<fj> {
        public ClientCustomPacketEvent(ek manager, FMLProxyPacket packet) {
            super((fj)manager.i(), fj.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.CLIENT;
        }
    }

    public static abstract class CustomPacketEvent<S extends ep>
    extends FMLNetworkEvent<S> {
        public final FMLProxyPacket packet;
        public FMLProxyPacket reply;

        CustomPacketEvent(S thing, Class<S> type, ek manager, FMLProxyPacket packet) {
            super(thing, type, manager);
            this.packet = packet;
        }

        public abstract Side side();
    }

    public static class CustomPacketRegistrationEvent<S extends ep>
    extends FMLNetworkEvent<S> {
        public final ImmutableSet<String> registrations;
        public final String operation;
        public final Side side;

        public CustomPacketRegistrationEvent(ek manager, Set<String> registrations, String operation, Side side, Class<S> type) {
            super((ep)type.cast(manager.i()), type, manager);
            this.registrations = ImmutableSet.copyOf(registrations);
            this.side = side;
            this.operation = operation;
        }
    }

    public static class ClientDisconnectionFromServerEvent
    extends FMLNetworkEvent<fj> {
        public ClientDisconnectionFromServerEvent(ek manager) {
            super((fj)manager.i(), fj.class, manager);
        }
    }

    public static class ServerDisconnectionFromClientEvent
    extends FMLNetworkEvent<ic> {
        public ServerDisconnectionFromClientEvent(ek manager) {
            super((ic)manager.i(), ic.class, manager);
        }
    }

    public static class ServerConnectionFromClientEvent
    extends FMLNetworkEvent<ic> {
        public final boolean isLocal;

        public ServerConnectionFromClientEvent(ek manager) {
            super((ic)manager.i(), ic.class, manager);
            this.isLocal = manager.c();
        }
    }

    public static class ClientConnectedToServerEvent
    extends FMLNetworkEvent<fj> {
        public final boolean isLocal;
        public final String connectionType;

        public ClientConnectedToServerEvent(ek manager, String connectionType) {
            super((fj)manager.i(), fj.class, manager);
            this.isLocal = manager.c();
            this.connectionType = connectionType;
        }
    }
}

