/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.functions.GenericIterableFactory;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.registry.LanguageRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;

    private FMLServerHandler() {
        FMLCommonHandler.instance().beginLoading(this);
    }

    @Override
    public void beginServerLoading(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        Loader.instance().loadMods();
        Loader.instance().preinitializeMods();
    }

    @Override
    public void finishServerLoading() {
        Loader.instance().initializeMods();
    }

    @Override
    public void haltGame(String message, Throwable exception) {
        throw new RuntimeException(message, exception);
    }

    @Override
    public File getSavesDirectory() {
        return ((atn)this.server.Y()).a;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            FMLLog.warning("%s", query.getText());
            query.finish();
        } else {
            String text = query.getText() + "\n\nRun the command /fml confirm or or /fml cancel to proceed." + "\nAlternatively start the server with -Dfml.queryResult=confirm or -Dfml.queryResult=cancel to preselect the answer.";
            FMLLog.warning("%s", text);
            if (!query.isSynchronous()) {
                return;
            }
            boolean done = false;
            while (!done && this.server.v()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ko dedServer = (ko)this.server;
                List list = dedServer.l;
                synchronized (list) {
                    Iterator<kd> it = GenericIterableFactory.newCastingIterable(dedServer.l, kd.class).iterator();
                    while (it.hasNext()) {
                        String cmd = it.next().a.trim().toLowerCase();
                        if (cmd.equals("/fml confirm")) {
                            FMLLog.info("confirmed", new Object[0]);
                            query.setResult(true);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (cmd.equals("/fml cancel")) {
                            FMLLog.info("cancelled", new Object[0]);
                            query.setResult(false);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (!cmd.equals("/stop")) continue;
                        StartupQuery.abort();
                    }
                }
                Thread.sleep(10L);
            }
            query.finish();
        }
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return false;
    }

    @Override
    public void addModAsResource(ModContainer container) {
        LanguageRegistry.instance().loadLanguagesFor(container, Side.SERVER);
    }

    @Override
    public String getCurrentLanguage() {
        return "en_US";
    }

    @Override
    public void serverStopped() {
    }

    @Override
    public ek getClientToServerNetworkManager() {
        throw new RuntimeException("Missing");
    }

    @Override
    public ep getClientPlayHandler() {
        return null;
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus, ek manager, Set<String> channelSet, String channel, Side side) {
        bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<lm>(manager, channelSet, channel, side, lm.class));
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return ko.allowPlayerLogins;
    }

    @Override
    public void allowLogins() {
        ko.allowPlayerLogins = true;
    }

    @Override
    public od getWorldThread(ep net) {
        return this.getServer();
    }

    @Override
    public void processWindowMessages() {
    }

    @Override
    public String stripSpecialChars(String message) {
        return message;
    }
}

