/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class BlockPlatformFrame
extends BlockPlatformType.Singles {
    public BlockPlatformFrame() {
        super(EnumPlatformType.FRAME);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformFrame.getTile(world, pos);
        if (tile != null && (torch = TileHelper.getTorch(tile)) != null) {
            switch (torch) {
                case REDSTONE_ON: {
                    return Blocks.f_50174_.m_49966_().m_60791_();
                }
                case LIGHT: {
                    return Blocks.f_50081_.m_49966_().m_60791_();
                }
                case GLOWSTONE: 
                case SOULSTONE: {
                    return Blocks.f_50141_.m_49966_().m_60791_();
                }
                case LAMP_ON: {
                    return ((BlockState)Blocks.f_50261_.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true))).m_60791_();
                }
                case SOUL: {
                    return Blocks.f_50139_.m_49966_().m_60791_();
                }
            }
        }
        return super.getLightEmission(state, world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformFrame.getTile((BlockGetter)world, pos);
        if (TileHelper.hasTorch(tile) && (torch = TileHelper.getTorch(tile)) != null) {
            double x = (float)pos.m_123341_() + 0.5f;
            double y = (float)pos.m_123342_() + 0.75f;
            double z = (float)pos.m_123343_() + 0.5f;
            switch (torch) {
                case REDSTONE_ON: 
                case LAMP_ON: {
                    world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x += (double)(rand.nextFloat() - 0.5f) * 0.2, y += (double)(rand.nextFloat() - 0.5f) * 0.2, z += (double)(rand.nextFloat() - 0.5f) * 0.2, 0.0, 0.0, 0.0);
                    break;
                }
                case LIGHT: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUL: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

