/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.math;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class Sphere {
    public static ArrayList<BlockPos> checkSphereSolid(BlockState state, Level world, BlockPos pos, Integer radius, boolean defaultstate) {
        int fixedradius = radius - 1;
        ArrayList<BlockPos> exitList = new ArrayList<BlockPos>();
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double sx = fixedradius * -1;
        double sy = 0.0;
        double sz = 0.0;
        for (int index0 = 0; index0 < radius * 2 - 1; ++index0) {
            sy = fixedradius * -1;
            for (int index1 = 0; index1 < radius * 2 - 1; ++index1) {
                sz = fixedradius * -1;
                for (int index2 = 0; index2 < radius * 2 - 1; ++index2) {
                    if (Math.sqrt(Math.pow(sx, 2.0) + Math.pow(sy, 2.0) + Math.pow(sz, 2.0)) <= (double)radius.intValue() && defaultstate && world.m_8055_(new BlockPos(x + sx, y + sy, z + sz)).m_60804_((BlockGetter)world, new BlockPos(x + sx, y + sy, z + sz))) {
                        exitList.add(new BlockPos(x + sx, y + sy, z + sz));
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
        return exitList;
    }

    public static ArrayList<BlockPos> checkSpherePos(BlockState state, Level world, BlockPos pos, Integer radius, boolean defaultstate) {
        int fixedradius = radius - 1;
        ArrayList<BlockPos> exitList = new ArrayList<BlockPos>();
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double sx = fixedradius * -1;
        double sy = 0.0;
        double sz = 0.0;
        for (int index0 = 0; index0 < radius * 2 - 1; ++index0) {
            sy = fixedradius * -1;
            for (int index1 = 0; index1 < radius * 2 - 1; ++index1) {
                sz = fixedradius * -1;
                for (int index2 = 0; index2 < radius * 2 - 1; ++index2) {
                    if (Math.sqrt(Math.pow(sx, 2.0) + Math.pow(sy, 2.0) + Math.pow(sz, 2.0)) <= (double)radius.intValue() && defaultstate && world.m_8055_(new BlockPos(x + sx, y + sy, z + sz)) == state) {
                        exitList.add(new BlockPos(x + sx, y + sy, z + sz));
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
        return exitList;
    }

    public static boolean checkSphere(BlockState state, Level world, BlockPos pos, Integer radius) {
        int fixedradius = radius - 1;
        boolean exit = false;
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double sx = fixedradius * -1;
        double sy = 0.0;
        double sz = 0.0;
        for (int index0 = 0; index0 < radius * 2 - 1; ++index0) {
            sy = fixedradius * -1;
            for (int index1 = 0; index1 < radius * 2 - 1; ++index1) {
                sz = fixedradius * -1;
                for (int index2 = 0; index2 < radius * 2 - 1; ++index2) {
                    if (Math.sqrt(Math.pow(sx, 2.0) + Math.pow(sy, 2.0) + Math.pow(sz, 2.0)) <= (double)radius.intValue() && world.m_8055_(new BlockPos(x + sx, y + sy, z + sz)) == state) {
                        exit = true;
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
        return exit;
    }

    public static boolean checkSphereWithPLace(BlockState state, Level world, BlockPos pos, Integer radius, BlockState placeBlock) {
        int fixedradius = radius - 1;
        boolean exit = false;
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double sx = fixedradius * -1;
        double sy = 0.0;
        double sz = 0.0;
        for (int index0 = 0; index0 < radius * 2 - 1; ++index0) {
            sy = fixedradius * -1;
            for (int index1 = 0; index1 < radius * 2 - 1; ++index1) {
                sz = fixedradius * -1;
                for (int index2 = 0; index2 < radius * 2 - 1; ++index2) {
                    if (Math.sqrt(Math.pow(sx, 2.0) + Math.pow(sy, 2.0) + Math.pow(sz, 2.0)) <= (double)radius.intValue() && world.m_8055_(new BlockPos(x + sx, y + sy, z + sz)) == state) {
                        world.m_46597_(new BlockPos(x + sx, y + sy, z + sz), placeBlock);
                        exit = true;
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
        return exit;
    }

    public static boolean checkSphereWithParticle(BlockState state, Level world, BlockPos pos, Integer radius, ParticleOptions particleEffect) {
        int fixedradius = radius - 1;
        boolean exit = false;
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double sx = fixedradius * -1;
        double sy = 0.0;
        double sz = 0.0;
        for (int index0 = 0; index0 < radius * 2 - 1; ++index0) {
            sy = fixedradius * -1;
            for (int index1 = 0; index1 < radius * 2 - 1; ++index1) {
                sz = fixedradius * -1;
                for (int index2 = 0; index2 < radius * 2 - 1; ++index2) {
                    if (Math.sqrt(Math.pow(sx, 2.0) + Math.pow(sy, 2.0) + Math.pow(sz, 2.0)) <= (double)radius.intValue() && world.m_8055_(new BlockPos(x + sx, y + sy, z + sz)) == state) {
                        world.m_7106_(particleEffect, x + sx, y + sy, z + sz, 0.0, 1.0, 0.0);
                        exit = true;
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
        return exit;
    }

    public static boolean checkSphereWithPLaceAndParticles(BlockState state, Level world, BlockPos pos, Integer radius, BlockState placeBlock, ParticleOptions particleEffect, double deltax, double deltay, double deltaz, int amount, int speed) {
        int fixedradius = radius - 1;
        boolean exit = false;
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double sx = fixedradius * -1;
        double sy = 0.0;
        double sz = 0.0;
        for (int index0 = 0; index0 < radius * 2 - 1; ++index0) {
            sy = fixedradius * -1;
            for (int index1 = 0; index1 < radius * 2 - 1; ++index1) {
                sz = fixedradius * -1;
                for (int index2 = 0; index2 < radius * 2 - 1; ++index2) {
                    if (Math.sqrt(Math.pow(sx, 2.0) + Math.pow(sy, 2.0) + Math.pow(sz, 2.0)) <= (double)radius.intValue() && world.m_8055_(new BlockPos(x + sx, y + sy, z + sz)) == state) {
                        world.m_46597_(new BlockPos(x + sx, y + sy, z + sz), placeBlock);
                        if (!world.m_5776_()) {
                            // empty if block
                        }
                        exit = true;
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
        return exit;
    }
}

