/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mca.client.gui.InteractScreen;
import mca.cobalt.network.NetworkHandler;
import mca.entity.ai.relationship.MarriageState;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.network.c2s.GetFamilyTreeRequest;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FamilyTreeScreen
extends Screen {
    private static final int HORIZONTAL_SPACING = 20;
    private static final int VERTICAL_SPACING = 60;
    private static final int SPOUSE_HORIZONTAL_SPACING = 50;
    private UUID focusedEntityId;
    private final Map<UUID, FamilyTreeNode> family = new HashMap<UUID, FamilyTreeNode>();
    private final Map<UUID, TreeNode> nodes = new HashMap<UUID, TreeNode>();
    private final TreeNode emptyNode;
    private TreeNode tree = this.emptyNode = new TreeNode();
    @Nullable
    private TreeNode focused;
    private double scrollX;
    private double scrollY;
    private final Screen parent;

    public FamilyTreeScreen(UUID entityId) {
        super((Component)new TranslatableComponent("gui.family_tree.title"));
        this.focusedEntityId = entityId;
        this.parent = Minecraft.m_91087_().f_91080_;
    }

    public boolean m_7043_() {
        return false;
    }

    public void setFamilyData(UUID uuid, Map<UUID, FamilyTreeNode> family) {
        this.focusedEntityId = uuid;
        this.family.putAll(family);
        this.rebuildTree();
    }

    private boolean focusEntity(UUID id) {
        this.focusedEntityId = id;
        NetworkHandler.sendToServer(new GetFamilyTreeRequest(id));
        return false;
    }

    public void m_7856_() {
        this.focusEntity(this.focusedEntityId);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 25, 200, 20, (Component)new TranslatableComponent("gui.done"), sender -> this.m_7379_()));
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.scrollX += deltaX;
            this.scrollY += deltaY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.focused != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            if (this.focusEntity(this.focused.id)) {
                this.rebuildTree();
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        FamilyTreeScreen.m_93172_((PoseStack)matrices, (int)0, (int)30, (int)this.f_96543_, (int)(this.f_96544_ - 30), (int)0x66000000);
        this.focused = null;
        Window window = Minecraft.m_91087_().m_91268_();
        double f = window.m_85449_();
        int windowHeight = (int)Math.round((double)window.m_85446_() * f);
        int x = 0;
        int y = (int)(30.0 * f);
        int w = (int)((double)this.f_96543_ * f);
        int h = (int)((double)(this.f_96544_ - 60) * f);
        GL11.glScissor((int)x, (int)(windowHeight - h - y), (int)w, (int)h);
        GL11.glEnable((int)3089);
        matrices.m_85836_();
        int xx = (int)(this.scrollX + (double)(this.f_96543_ / 2));
        int yy = (int)(this.scrollY + (double)(this.f_96544_ / 2));
        matrices.m_85837_((double)xx, (double)yy, 0.0);
        this.tree.render(matrices, mouseX - xx, mouseY - yy);
        matrices.m_85849_();
        GL11.glDisable((int)3089);
        FamilyTreeNode selected = this.family.get(this.focusedEntityId);
        Component label = selected == null ? this.f_96539_ : new TextComponent(selected.getName()).m_130946_("'s ").m_7220_(this.f_96539_);
        FamilyTreeScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)label, (int)(this.f_96543_ / 2), (int)10, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private void rebuildTree() {
        this.scrollX = 14.0;
        this.scrollY = -69.0;
        FamilyTreeNode focusedNode = this.family.get(this.focusedEntityId);
        this.focused = null;
        this.tree = this.emptyNode;
        this.nodes.clear();
        if (focusedNode != null) {
            this.tree = this.insertParents(new TreeNode(focusedNode, true), focusedNode, 2);
        }
    }

    private TreeNode insertParents(TreeNode root, FamilyTreeNode focusedNode, int levels) {
        @Nullable FamilyTreeNode father = this.family.get(focusedNode.father());
        @Nullable FamilyTreeNode mother = this.family.get(focusedNode.mother());
        @Nullable FamilyTreeNode newRoot = father != null ? father : mother;
        TreeNode fNode = newRoot == null ? new TreeNode() : new TreeNode(newRoot, false);
        fNode.children.add(root);
        @Nullable FamilyTreeNode spouse = newRoot == father ? mother : father;
        TreeNode treeNode = fNode.spouse = spouse == null ? new TreeNode() : new TreeNode(spouse, false);
        if (newRoot != null && levels > 0) {
            return this.insertParents(fNode, newRoot, levels - 1);
        }
        return fNode;
    }

    private final class TreeNode {
        private boolean widthComputed;
        private int width;
        private int labelWidth;
        private final List<Component> label = new ArrayList<Component>();
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private Bounds bounds;
        TreeNode spouse;
        final UUID id;
        final boolean deceased;
        @Nullable
        private TreeNode previous;
        private final String defaultNodeName = "???";

        private TreeNode() {
            this.id = null;
            this.deceased = false;
            this.label.add((Component)new TextComponent("???"));
        }

        public TreeNode(FamilyTreeNode node, boolean recurse) {
            this(node, new HashSet<UUID>(), recurse);
        }

        public TreeNode(FamilyTreeNode node, Set<UUID> parsed, boolean recurse) {
            FamilyTreeScreen.this.nodes.put(node.id(), this);
            this.id = node.id();
            this.deceased = node.isDeceased();
            TextComponent text = new TextComponent(node.getName().isEmpty() ? "???" : node.getName());
            this.label.add((Component)text.m_6270_(text.m_7383_().m_178520_(node.gender().getColor())));
            this.label.add((Component)new TranslatableComponent("entity.minecraft.villager." + node.getProfessionName()).m_130940_(ChatFormatting.GRAY));
            FamilyTreeNode father = FamilyTreeScreen.this.family.get(node.father());
            FamilyTreeNode mother = FamilyTreeScreen.this.family.get(node.mother());
            if ((father == null || father.isDeceased()) && (mother == null || mother.isDeceased())) {
                this.label.add((Component)new TranslatableComponent("gui.family_tree.label.orphan").m_130940_(ChatFormatting.GRAY));
            }
            if (node.getMarriageState() != MarriageState.SINGLE) {
                this.label.add((Component)new TranslatableComponent("marriage." + node.getMarriageState().base().getIcon()));
            }
            if (recurse) {
                node.children().forEach(child -> {
                    FamilyTreeNode e = FamilyTreeScreen.this.family.get(child);
                    if (e != null) {
                        this.children.add(new TreeNode(e, parsed, parsed.add((UUID)child)));
                    }
                });
                FamilyTreeNode spouse = FamilyTreeScreen.this.family.get(node.spouse());
                if (spouse != null) {
                    this.spouse = new TreeNode(spouse, parsed, false);
                } else if (!this.children.isEmpty()) {
                    this.spouse = new TreeNode();
                }
            }
        }

        public void render(PoseStack matrices, int mouseX, int mouseY) {
            boolean isFocused;
            Bounds bounds = this.getBounds();
            boolean bl = isFocused = this.id != null && bounds.contains(mouseX, mouseY);
            if (isFocused) {
                FamilyTreeScreen.this.focused = this;
            }
            int childrenStartX = -this.getWidth() / 2;
            for (TreeNode node : this.children) {
                int x = (childrenStartX += (node.getWidth() + 20) / 2) + 10;
                int y = 60;
                this.drawHook(matrices, x, y);
                matrices.m_85836_();
                matrices.m_85837_((double)x, (double)y, 0.0);
                node.render(matrices, mouseX - x, mouseY - y);
                matrices.m_85849_();
                childrenStartX += (node.getWidth() + 20) / 2;
            }
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 400.0);
            int fillColor = isFocused ? -267386816 : -267386864;
            int borderColor = isFocused ? -14155649 : 0x505000FF;
            GuiComponent.m_93172_((PoseStack)matrices, (int)bounds.left, (int)(bounds.top + 1), (int)(bounds.left + 1), (int)(bounds.bottom - 1), (int)fillColor);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(bounds.right - 1), (int)(bounds.top + 1), (int)bounds.right, (int)(bounds.bottom - 1), (int)fillColor);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(bounds.left + 1), (int)bounds.top, (int)(bounds.right - 1), (int)bounds.bottom, (int)fillColor);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(bounds.left + 1), (int)(bounds.top + 1), (int)(bounds.left + 2), (int)(bounds.bottom - 1), (int)borderColor);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(bounds.right - 2), (int)(bounds.top + 1), (int)(bounds.right - 1), (int)(bounds.bottom - 1), (int)borderColor);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(bounds.left + 2), (int)(bounds.top + 1), (int)(bounds.right - 2), (int)(bounds.top + 2), (int)borderColor);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(bounds.left + 2), (int)(bounds.bottom - 2), (int)(bounds.right - 2), (int)(bounds.bottom - 1), (int)borderColor);
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            int l = bounds.top + 5;
            int k = bounds.left + 6;
            if (this.deceased) {
                k += 20;
            }
            Matrix4f matrix4f = matrices.m_85850_().m_85861_();
            Font r = Minecraft.m_91087_().f_91062_;
            for (int s = 0; s < this.label.size(); ++s) {
                Component line = this.label.get(s);
                if (line != null) {
                    r.m_92841_(line, (float)k, (float)l, -1, true, matrix4f, (MultiBufferSource)immediate, false, 0, 0xF000F0);
                }
                if (s == 0) {
                    l += 2;
                }
                l += 10;
            }
            immediate.m_109911_();
            matrices.m_85849_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)InteractScreen.ICON_TEXTURES);
            if (this.deceased) {
                GuiComponent.m_93143_((PoseStack)matrices, (int)(bounds.left + 6), (int)(bounds.top + 6), (int)0, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)256, (int)256);
                if (isFocused && mouseX <= bounds.left + 20) {
                    matrices.m_85836_();
                    matrices.m_85837_(0.0, 0.0, 20.0);
                    FamilyTreeScreen.this.m_96602_(matrices, (Component)new TranslatableComponent("gui.family_tree.label.deceased"), mouseX, mouseY);
                    matrices.m_85849_();
                }
            }
            if (this.spouse != null) {
                int x = bounds.left - 50;
                int y = bounds.top + bounds.bottom / 2;
                FamilyTreeScreen.this.m_93154_(matrices, x, bounds.left - 1, y, -1);
                GuiComponent.m_93143_((PoseStack)matrices, (int)(bounds.left - 25 - 8), (int)(y - 8), (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
                int n = this.spouse.label.size();
                Objects.requireNonNull(FamilyTreeScreen.this.f_96547_);
                matrices.m_85836_();
                matrices.m_85837_((double)(x -= this.spouse.getWidth() / 2 - 6), (double)(y -= n * 9 / 2), 0.0);
                this.spouse.render(matrices, mouseX - x, mouseY - y);
                matrices.m_85849_();
            }
        }

        private void drawHook(PoseStack matrices, int endX, int endY) {
            int midY = endY / 2;
            FamilyTreeScreen.this.m_93222_(matrices, 0, 0, midY, -1);
            FamilyTreeScreen.this.m_93154_(matrices, 0, endX, midY, -1);
            FamilyTreeScreen.this.m_93222_(matrices, endX, midY, endY, -1);
        }

        public int getWidth() {
            if (!this.widthComputed) {
                this.widthComputed = true;
                this.labelWidth = this.label.stream().mapToInt(arg_0 -> ((Font)FamilyTreeScreen.this.f_96547_).m_92852_(arg_0)).max().orElse(0);
                if (this.deceased) {
                    this.labelWidth += 20;
                }
                this.width = Math.max(this.labelWidth + 10, this.children.stream().mapToInt(TreeNode::getWidth).sum()) + 10;
                if (this.spouse != null) {
                    this.width += this.spouse.getWidth() + 50;
                }
            }
            return this.width;
        }

        public Bounds getBounds() {
            if (this.bounds == null) {
                this.getWidth();
                int padding = 4;
                int n = -this.labelWidth / 2 - padding;
                int n2 = this.labelWidth / 2 + padding * 2;
                int n3 = -padding;
                Objects.requireNonNull(FamilyTreeScreen.this.f_96547_);
                this.bounds = new Bounds(n, n2, n3, 9 * this.label.size() + padding * 2);
            }
            return this.bounds;
        }
    }

    static final class Bounds {
        final int left;
        final int right;
        final int top;
        final int bottom;

        public Bounds(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public Bounds add(int x, int y) {
            return new Bounds(this.left + x, this.right + x, this.top + y, this.bottom + y);
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX <= this.right && mouseY <= this.bottom;
        }
    }
}

