/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mca.MCA;
import mca.client.gui.widget.ColorPickerWidget;
import mca.client.gui.widget.GeneSliderWidget;
import mca.client.gui.widget.NamedTextFieldWidget;
import mca.cobalt.network.NetworkHandler;
import mca.entity.EntitiesMCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.VillagerLike;
import mca.entity.ai.Genetics;
import mca.entity.ai.Memories;
import mca.entity.ai.ProfessionsMCA;
import mca.entity.ai.Traits;
import mca.entity.ai.relationship.AgeState;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.Personality;
import mca.network.c2s.GetVillagerRequest;
import mca.network.c2s.VillagerEditorSyncRequest;
import mca.network.c2s.VillagerNameRequest;
import mca.resources.data.Hair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VillagerEditorScreen
extends Screen {
    private final UUID villagerUUID;
    private final UUID playerUUID;
    private int villagerBreedingAge;
    protected String page;
    protected final VillagerEntityMCA villager;
    protected static final int DATA_WIDTH = 175;
    private int traitPage;
    private static final int TRAITS_PER_PAGE = 8;
    private long initialTime;
    protected CompoundTag villagerData;
    private EditBox villagerNameField;
    private Button genderButtonFemale;
    private Button genderButtonMale;

    public VillagerEditorScreen(UUID villagerUUID, UUID playerUUID) {
        super((Component)new TranslatableComponent("gui.VillagerEditorScreen.title"));
        this.villager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).m_20615_((Level)Minecraft.m_91087_().f_91073_);
        this.traitPage = 0;
        this.villagerUUID = villagerUUID;
        this.playerUUID = playerUUID;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        this.requestVillagerData();
        this.setPage("loading");
    }

    private int doubleGeneSliders(int y, Genetics.GeneType ... genes) {
        boolean right = false;
        assert (this.villager != null);
        Genetics genetics = this.villager.getGenetics();
        for (Genetics.GeneType g : genes) {
            this.m_142416_((GuiEventListener)new GeneSliderWidget(this.f_96543_ / 2 + (right ? 87 : 0), y, 87, 20, (Component)new TranslatableComponent(g.getTranslationKey()), genetics.getGene(g), b -> genetics.setGene(g, b.floatValue())));
            if (right) {
                y += 20;
            }
            right = !right;
        }
        return y + 4 + (right ? 20 : 0);
    }

    private int integerChanger(int y, Consumer<Integer> onClick, Supplier<Component> content) {
        int bw = 22;
        Button current = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + bw * 2, y, 175 - bw * 4, 20, content.get(), b -> {}));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, y, bw, 20, (Component)new TextComponent("-1"), b -> {
            onClick.accept(-1);
            current.m_93666_((Component)content.get());
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + bw, y, bw, 20, (Component)new TextComponent("-10"), b -> {
            onClick.accept(-10);
            current.m_93666_((Component)content.get());
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 175 - bw * 2, y, bw, 20, (Component)new TextComponent("+10"), b -> {
            onClick.accept(10);
            current.m_93666_((Component)content.get());
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 175 - bw, y, bw, 20, (Component)new TextComponent("+1"), b -> {
            onClick.accept(1);
            current.m_93666_((Component)content.get());
        }));
        return y + 22;
    }

    protected void setPage(String page) {
        assert (this.villager != null);
        this.page = page;
        this.m_169413_();
        if (page.equals("loading")) {
            return;
        }
        String[] pages = this.getPages();
        int w = 350 / pages.length;
        int x = (int)((double)this.f_96543_ / 2.0 - (double)pages.length / 2.0 * (double)w);
        for (String p : pages) {
            ((Button)this.m_142416_((GuiEventListener)new Button((int)x, (int)(this.f_96544_ / 2 - 105), (int)w, (int)20, (Component)new TranslatableComponent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"gui.villager_editor.page.\u0001"}, (String)p))), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$setPage$6(java.lang.String net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((VillagerEditorScreen)this, (String)p)))).f_93623_ = !p.equals(page);
            x += w;
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 175 + 20, this.f_96544_ / 2 + 85, 135, 20, (Component)new TranslatableComponent("gui.done"), sender -> {
            this.syncVillagerData();
            this.m_7379_();
        }));
        int y = this.f_96544_ / 2 - 80;
        int margin = 40;
        Genetics genetics = this.villager.getGenetics();
        switch (page) {
            case "general": {
                EditBox field;
                this.drawName(this.f_96543_ / 2, y);
                this.drawGender(this.f_96543_ / 2, y += 20);
                this.m_142416_((GuiEventListener)new GeneSliderWidget(this.f_96543_ / 2, y += 22, 175, 20, (Component)new TranslatableComponent("gui.villager_editor.age"), 1.0 + (double)this.villagerBreedingAge / (double)AgeState.getMaxAge(), b -> {
                    this.villagerBreedingAge = -((int)((1.0 - b) * (double)AgeState.getMaxAge())) + 1;
                    this.villager.m_146762_(this.villagerBreedingAge);
                    this.villager.m_6210_();
                }));
                y += 28;
                for (String who : new String[]{"father", "mother", "spouse"}) {
                    field = (EditBox)this.m_142416_((GuiEventListener)new NamedTextFieldWidget(this.f_96547_, this.f_96543_ / 2, y, 175, 18, (Component)new TranslatableComponent("gui.villager_editor.relation." + who)));
                    field.m_94199_(64);
                    field.m_94144_(this.villagerData.m_128461_("tree_" + who + "_name"));
                    field.m_94151_(name -> this.villagerData.m_128359_("tree_" + who + "_new", name));
                    y += 20;
                }
                field = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2, y += 4, 175, 18, (Component)new TextComponent("UUID")));
                field.m_94199_(64);
                field.m_94144_(this.villagerUUID.toString());
                break;
            }
            case "body": {
                y = this.doubleGeneSliders(y, Genetics.SIZE, Genetics.WIDTH, Genetics.BREAST, Genetics.SKIN);
                EditBox field = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2, y, 175, 18, (Component)new TranslatableComponent("structure_block.structure_name")));
                field.m_94199_(32);
                field.m_94144_(this.villager.getClothes());
                field.m_94151_(this.villager::setClothes);
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, y += 20, 87, 20, (Component)new TranslatableComponent("gui.villager_editor.prevClothing"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.m_128405_("offset", -1);
                    this.sendCommand("clothing", compound);
                }));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 87, y, 87, 20, (Component)new TranslatableComponent("gui.villager_editor.nextClothing"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.m_128405_("offset", 1);
                    this.sendCommand("clothing", compound);
                }));
                this.m_142416_((GuiEventListener)new ColorPickerWidget(this.f_96543_ / 2 + margin, y += 22, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.HEMOGLOBIN), genetics.getGene(Genetics.MELANIN), MCA.locate("textures/colormap/villager_skin.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.HEMOGLOBIN, vx.floatValue());
                    genetics.setGene(Genetics.MELANIN, vy.floatValue());
                }));
                y += 175 - margin * 2;
                break;
            }
            case "head": {
                y = this.doubleGeneSliders(y, Genetics.FACE);
                EditBox field = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2, y, 175, 18, (Component)new TranslatableComponent("structure_block.structure_name")));
                field.m_94199_(32);
                field.m_94144_(this.villager.getHair().texture());
                field.m_94151_(name -> this.villager.setHair(new Hair((String)name, this.villager.getHair().overlay())));
                EditBox field2 = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2, y += 20, 175, 18, (Component)new TranslatableComponent("structure_block.structure_name")));
                field2.m_94199_(32);
                field2.m_94144_(this.villager.getHair().overlay());
                field2.m_94151_(name -> this.villager.setHair(new Hair(this.villager.getHair().texture(), (String)name)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, y += 20, 87, 20, (Component)new TranslatableComponent("gui.villager_editor.prevHair"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.m_128405_("offset", -1);
                    this.sendCommand("hair", compound);
                }));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 87, y, 87, 20, (Component)new TranslatableComponent("gui.villager_editor.nextHair"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.m_128405_("offset", 1);
                    this.sendCommand("hair", compound);
                }));
                this.m_142416_((GuiEventListener)new ColorPickerWidget(this.f_96543_ / 2 + margin, y += 22, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.PHEOMELANIN), genetics.getGene(Genetics.EUMELANIN), MCA.locate("textures/colormap/villager_hair.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.PHEOMELANIN, vx.floatValue());
                    genetics.setGene(Genetics.EUMELANIN, vy.floatValue());
                }));
                y += 175 - margin * 2;
                break;
            }
            case "personality": {
                LinkedList<Button> personalityButtons = new LinkedList<Button>();
                int row = 0;
                int BUTTONS_PER_ROW = 2;
                for (Personality p : Personality.values()) {
                    if (p == Personality.UNASSIGNED) continue;
                    if (row == 2) {
                        row = 0;
                        y += 20;
                    }
                    Button widget = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 87 * row, y, 87, 20, p.getName(), b -> {
                        this.villager.getVillagerBrain().setPersonality(p);
                        personalityButtons.forEach(v -> {
                            v.f_93623_ = true;
                        });
                        b.f_93623_ = false;
                    }));
                    widget.f_93623_ = p != this.villager.getVillagerBrain().getPersonality();
                    personalityButtons.add(widget);
                    ++row;
                }
                y += 22;
                break;
            }
            case "traits": {
                int index;
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, y, 32, 20, (Component)new TextComponent("<"), b -> this.setTraitPage(this.traitPage - 1)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 175 - 32, y, 32, 20, (Component)new TextComponent(">"), b -> this.setTraitPage(this.traitPage + 1)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 32, y, 111, 20, (Component)new TranslatableComponent("gui.villager_editor.page", new Object[]{this.traitPage + 1}), b -> ++this.traitPage));
                y += 22;
                Traits.Trait[] traits = Traits.Trait.values();
                for (int i = 0; i < 8 && (index = i + this.traitPage * 8) < traits.length; ++i) {
                    Traits.Trait t = traits[index];
                    MutableComponent name2 = t.getName().m_6879_().m_130940_(this.villager.getTraits().hasTrait(t) ? ChatFormatting.GREEN : ChatFormatting.GRAY);
                    this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, y, 175, 20, (Component)name2, b -> {
                        if (this.villager.getTraits().hasTrait(t)) {
                            this.villager.getTraits().removeTrait(t);
                        } else {
                            this.villager.getTraits().addTrait(t);
                        }
                        b.m_93666_((Component)t.getName().m_6879_().m_130940_(this.villager.getTraits().hasTrait(t) ? ChatFormatting.GREEN : ChatFormatting.GRAY));
                    }));
                    y += 20;
                }
                y += 22;
                break;
            }
            case "debug": {
                boolean right = false;
                LinkedList<Button> professionButtons = new LinkedList<Button>();
                for (VillagerProfession p : new VillagerProfession[]{VillagerProfession.f_35585_, (VillagerProfession)ProfessionsMCA.GUARD.get(), (VillagerProfession)ProfessionsMCA.ARCHER.get(), (VillagerProfession)ProfessionsMCA.OUTLAW.get()}) {
                    TranslatableComponent text = new TranslatableComponent("entity.minecraft.villager." + p);
                    Button widget = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + (right ? 87 : 0), y, 87, 20, (Component)text, b -> {
                        CompoundTag compound = new CompoundTag();
                        compound.m_128359_("profession", Registry.f_122869_.m_7981_((Object)p).toString());
                        this.syncVillagerData();
                        NetworkHandler.sendToServer(new VillagerEditorSyncRequest("profession", this.villagerUUID, compound));
                        this.requestVillagerData();
                        professionButtons.forEach(button -> {
                            button.f_93623_ = true;
                        });
                        b.f_93623_ = false;
                    }));
                    professionButtons.add(widget);
                    boolean bl = widget.f_93623_ = this.villager.getProfession() != p;
                    if (right) {
                        y += 20;
                    }
                    right = !right;
                }
                this.m_142416_((GuiEventListener)new GeneSliderWidget(this.f_96543_ / 2, y += 4, 175, 20, (Component)new TranslatableComponent("gui.villager_editor.infection"), this.villager.getInfectionProgress() / 255.0f, b -> {
                    this.villager.setInfected(b > 0.0);
                    this.villager.setInfectionProgress(b.floatValue() * 255.0f);
                }));
                y += 22;
                Memories player = this.villager.getVillagerBrain().getMemoriesForPlayer((Player)this.f_96541_.f_91074_);
                y = this.integerChanger(y, player::modHearts, () -> new TextComponent(player.getHearts() + " hearts"));
                y = this.integerChanger(y, v -> this.villager.getVillagerBrain().modifyMoodValue((int)v), () -> new TextComponent(this.villager.getVillagerBrain().getMoodValue() + " mood"));
            }
        }
    }

    protected String[] getPages() {
        if (this.villagerUUID.equals(this.playerUUID)) {
            return new String[]{"general", "body", "head", "traits"};
        }
        return new String[]{"general", "body", "head", "personality", "traits", "debug"};
    }

    protected void drawName(int x, int y) {
        Component villagerName = this.villager.m_7755_();
        if ((villagerName == null || villagerName.m_6111_().isEmpty()) && this.villagerUUID.equals(this.playerUUID)) {
            villagerName = this.f_96541_.f_91074_.m_7755_();
        }
        this.villagerNameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x, y, 116, 18, (Component)new TranslatableComponent("structure_block.structure_name")));
        this.villagerNameField.m_94199_(32);
        this.villagerNameField.m_94144_(villagerName.m_6111_());
        this.villagerNameField.m_94151_(name -> this.villager.setTrackedValue(VillagerLike.VILLAGER_NAME, name));
        this.m_142416_((GuiEventListener)new Button(x + 116 + 1, y - 1, 56, 20, (Component)new TranslatableComponent("gui.button.random"), b -> NetworkHandler.sendToServer(new VillagerNameRequest(this.villager.getGenetics().getGender()))));
    }

    void drawGender(int x, int y) {
        assert (this.villager != null);
        this.genderButtonFemale = new Button(x, y, 87, 20, (Component)new TranslatableComponent("gui.villager_editor.female"), sender -> {
            this.villager.getGenetics().setGender(Gender.FEMALE);
            this.genderButtonFemale.f_93623_ = false;
            this.genderButtonMale.f_93623_ = true;
        });
        this.m_142416_((GuiEventListener)this.genderButtonFemale);
        this.genderButtonMale = new Button(x + 87, y, 87, 20, (Component)new TranslatableComponent("gui.villager_editor.male"), sender -> {
            this.villager.getGenetics().setGender(Gender.MALE);
            this.genderButtonFemale.f_93623_ = true;
            this.genderButtonMale.f_93623_ = false;
        });
        this.m_142416_((GuiEventListener)this.genderButtonMale);
        this.genderButtonFemale.f_93623_ = this.villager.getGenetics().getGender() != Gender.FEMALE;
        this.genderButtonMale.f_93623_ = this.villager.getGenetics().getGender() != Gender.MALE;
    }

    private void sendCommand(String command, CompoundTag nbt) {
        this.syncVillagerData();
        NetworkHandler.sendToServer(new VillagerEditorSyncRequest(command, this.villagerUUID, nbt));
        this.requestVillagerData();
    }

    private void setTraitPage(int i) {
        Traits.Trait[] traits = Traits.Trait.values();
        int maxPage = (int)((double)traits.length / 8.0);
        this.traitPage = Math.max(0, Math.min(maxPage, i));
        this.setPage("traits");
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        VillagerEditorScreen.m_93172_((PoseStack)matrices, (int)0, (int)20, (int)this.f_96543_, (int)(this.f_96544_ - 20), (int)0x66000000);
        if (this.villager == null) {
            return;
        }
        long time = this.f_96541_.f_91073_.m_46467_();
        this.villager.f_19797_ = (int)((long)this.villager.f_19797_ + (time - this.initialTime));
        this.initialTime = time;
        if (this.shouldDrawEntity()) {
            InventoryScreen.m_98850_((int)(this.f_96543_ / 2 - 87), (int)(this.f_96544_ / 2 + 70), (int)60, (float)0.0f, (float)0.0f, (LivingEntity)this.villager);
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    protected boolean shouldDrawEntity() {
        return !this.page.equals("loading");
    }

    public void setVillagerName(String name) {
        this.villagerNameField.m_94144_(name);
        this.villager.setTrackedValue(VillagerLike.VILLAGER_NAME, name);
    }

    public void setVillagerData(CompoundTag villagerData) {
        if (this.villager != null) {
            this.villagerData = villagerData;
            this.villager.m_7378_(villagerData);
            this.villagerBreedingAge = villagerData.m_128451_("Age");
            this.villager.m_146762_(this.villagerBreedingAge);
            this.villager.m_6210_();
            this.initialTime = this.f_96541_.f_91073_.m_46467_();
        }
        if (this.page.equals("loading")) {
            this.setPage("general");
        } else {
            this.setPage(this.page);
        }
    }

    private void requestVillagerData() {
        NetworkHandler.sendToServer(new GetVillagerRequest(this.villagerUUID));
    }

    private void syncVillagerData() {
        assert (this.villager != null);
        CompoundTag nbt = this.villagerData;
        this.villager.m_7380_(nbt);
        nbt.m_128405_("Age", this.villagerBreedingAge);
        NetworkHandler.sendToServer(new VillagerEditorSyncRequest("sync", this.villagerUUID, nbt));
    }

    private /* synthetic */ void lambda$setPage$6(String p, Button sender) {
        this.setPage(p);
    }
}

