/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.Function;
import mca.client.model.VillagerEntityBaseModelMCA;
import mca.client.model.VillagerEntityModelMCA;
import mca.entity.VillagerLike;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public abstract class VillagerLayer<T extends Mob, M extends VillagerEntityModelMCA<T>>
extends RenderLayer<T, M> {
    private static final float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = Maps.newHashMap();
    public final M model;

    public VillagerLayer(RenderLayerParent<T, M> renderer, M model) {
        super(renderer);
        this.model = model;
    }

    @Nullable
    protected ResourceLocation getSkin(T villager) {
        return null;
    }

    @Nullable
    protected ResourceLocation getOverlay(T villager) {
        return null;
    }

    protected float[] getColor(T villager) {
        return DEFAULT_COLOR;
    }

    protected boolean isTranslucent() {
        return false;
    }

    public void render(PoseStack transform, MultiBufferSource provider, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ResourceLocation overlay;
        if (((VillagerLike)entity).hasCustomSkin()) {
            return;
        }
        ((VillagerEntityModelMCA)this.m_117386_()).m_102872_(this.model);
        int tint = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
        ResourceLocation skin = this.getSkin(entity);
        if (this.canUse(skin)) {
            float[] color = this.getColor(entity);
            this.renderModel(transform, provider, light, this.model, color[0], color[1], color[2], skin, tint);
        }
        if (this.canUse(overlay = this.getOverlay(entity))) {
            this.renderModel(transform, provider, light, this.model, 1.0f, 1.0f, 1.0f, overlay, tint);
        }
    }

    private void renderModel(PoseStack transform, MultiBufferSource provider, int light, M model, float r, float g, float b, ResourceLocation texture, int overlay) {
        VertexConsumer buffer = provider.m_6299_(this.isTranslucent() ? RenderType.m_110473_((ResourceLocation)texture) : RenderType.m_110458_((ResourceLocation)texture));
        ((VillagerEntityBaseModelMCA)((Object)model)).m_7695_(transform, buffer, light, overlay, r, g, b, 1.0f);
    }

    protected final boolean canUse(ResourceLocation texture) {
        return texture != null && Minecraft.m_91087_().m_91098_().m_7165_(texture);
    }

    @Nullable
    protected final ResourceLocation cached(String name, Function<String, ResourceLocation> supplier) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return TEXTURE_CACHE.computeIfAbsent(name, s -> {
            try {
                return (ResourceLocation)supplier.apply((String)s);
            }
            catch (ResourceLocationException ignored) {
                return null;
            }
        });
    }
}

