/*
 * Decompiled with CFR 0.152.
 */
package mca.client.resources;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import mca.MCA;
import mca.client.resources.ColorPalette;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class ColorPaletteLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, ColorPalette.Data>> {
    protected static final ResourceLocation ID = new ResourceLocation("mca", "color_palettes");

    protected Map<ResourceLocation, ColorPalette.Data> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return ColorPalette.REGISTRY.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.loadPalette((ResourceLocation)entry.getKey(), manager)));
    }

    private ColorPalette.Data loadPalette(ResourceLocation id, ResourceManager manager) {
        ColorPalette.Data data;
        block8: {
            NativeImage img = NativeImage.m_85058_((InputStream)manager.m_142591_(id).m_6679_());
            try {
                data = new ColorPalette.Data(img.m_84982_(), img.m_85084_(), img.m_85118_());
                if (img == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (img != null) {
                        try {
                            img.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    MCA.LOGGER.error("Failed to load color palette from `{}`", (Object)id, (Object)e);
                    return ColorPalette.EMPTY;
                }
            }
            img.close();
        }
        return data;
    }

    protected void apply(Map<ResourceLocation, ColorPalette.Data> palettes, ResourceManager manager, ProfilerFiller profiler) {
        palettes.forEach((id, data) -> {
            if (ColorPalette.REGISTRY.containsKey(id)) {
                ColorPalette.REGISTRY.get((Object)id).data = data;
            }
        });
    }
}

