/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import mca.TagsMCA;
import mca.advancement.criterion.CriterionMCA;
import mca.block.TombstoneBlock;
import mca.entity.VillagerEntityMCA;
import mca.entity.VillagerLike;
import mca.entity.ai.ActivityMCA;
import mca.entity.ai.relationship.CompassionateEntity;
import mca.entity.ai.relationship.EntityRelationship;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.MarriageState;
import mca.entity.ai.relationship.RelationshipType;
import mca.entity.ai.relationship.family.FamilyTree;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.entity.interaction.gifts.GiftSaturation;
import mca.server.world.data.GraveyardManager;
import mca.util.WorldUtils;
import mca.util.network.datasync.CDataManager;
import mca.util.network.datasync.CParameter;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relationship<T extends Mob>
implements EntityRelationship {
    public static final Predicate IS_MARRIED = (villager, player) -> villager.getRelationships().isMarriedTo(player);
    public static final Predicate IS_RELATIVE = (villager, player) -> villager.getRelationships().getFamilyEntry().isRelative(player);
    public static final Predicate IS_FAMILY = IS_MARRIED.or(IS_RELATIVE);
    public static final Predicate IS_PARENT = (villager, player) -> villager.getRelationships().getFamilyEntry().isParent(player);
    public static final Predicate IS_ORPHAN = (villager, player) -> villager.getRelationships().getFamilyEntry().getParents().allMatch(FamilyTreeNode::isDeceased);
    protected final T entity;
    private final GiftSaturation giftSaturation = new GiftSaturation();

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(new CParameter[0]);
    }

    public Relationship(T entity) {
        this.entity = entity;
    }

    @Override
    public Gender getGender() {
        return ((VillagerLike)this.entity).getGenetics().getGender();
    }

    @Override
    public Optional<Component> getSpouseName() {
        return this.getFamilyTree().getOrEmpty(this.getFamilyEntry().spouse()).map(FamilyTreeNode::getName).map(TextComponent::new);
    }

    @Override
    public Optional<Entity> getSpouse() {
        return Optional.ofNullable(((ServerLevel)((Mob)this.entity).f_19853_).m_8791_(this.getFamilyEntry().spouse()));
    }

    @Override
    public FamilyTree getFamilyTree() {
        return FamilyTree.get((ServerLevel)((Mob)this.entity).f_19853_);
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrCreate((Entity)this.entity);
    }

    @Override
    public Stream<Entity> getFamily(int parents, int children) {
        return this.getFamilyEntry().getRelatives(parents, children).map(id -> ((ServerLevel)((Mob)this.entity).f_19853_).m_8791_(id)).filter(Objects::nonNull).filter(e -> !e.equals(this.entity));
    }

    @Override
    public Stream<Entity> getParents() {
        return this.getFamilyEntry().streamParents().map(arg_0 -> ((ServerLevel)((ServerLevel)((Mob)this.entity).f_19853_)).m_8791_(arg_0)).filter(Objects::nonNull);
    }

    @Override
    public Stream<Entity> getSiblings() {
        return this.getFamilyEntry().siblings().stream().map(id -> ((ServerLevel)((Mob)this.entity).f_19853_).m_8791_(id)).filter(Objects::nonNull).filter(e -> !e.equals(this.entity));
    }

    public boolean onDeath(DamageSource cause) {
        this.getFamilyEntry().setDeceased(true);
        return GraveyardManager.get((ServerLevel)((Mob)this.entity).f_19853_).findNearest(this.entity.m_142538_(), GraveyardManager.TombstoneState.EMPTY, 10).filter(pos -> {
            BlockEntity be;
            if (((Mob)this.entity).f_19853_.m_8055_(pos).m_204336_(TagsMCA.Blocks.TOMBSTONES) && (be = ((Mob)this.entity).f_19853_.m_7702_(pos)) instanceof TombstoneBlock.Data) {
                this.onTragedy(cause, (BlockPos)pos);
                ((TombstoneBlock.Data)be).setEntity((Entity)this.entity);
                return true;
            }
            this.onTragedy(cause, null);
            return false;
        }).isPresent();
    }

    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite) {
        if (!((VillagerLike)this.entity).isHostile()) {
            WorldUtils.getCloseEntities(((Mob)this.entity).f_19853_, this.entity, 32.0, VillagerEntityMCA.class).forEach(villager -> villager.getRelationships().onTragedy(cause, burialSite, RelationshipType.STRANGER, (Entity)this.entity));
        }
        this.onTragedy(cause, burialSite, RelationshipType.SELF, (Entity)this.entity);
    }

    @Override
    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity with) {
        if (!cause.m_19378_()) {
            int moodAffect = 10;
            moodAffect /= type.getInverseProximity();
            ((Mob)this.entity).f_19853_.m_7605_(this.entity, (byte)17);
            ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(-(moodAffect *= type.getProximityAmplifier()));
            Entity entity = cause.m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer(player).modHearts(-20);
            }
        }
        if (burialSite != null && type != RelationshipType.STRANGER) {
            this.entity.m_6274_().m_21889_((Activity)ActivityMCA.GRIEVE.get());
            this.entity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(burialSite, 1.0f, 1));
            this.entity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(burialSite));
        }
        EntityRelationship.super.onTragedy(cause, burialSite, type, with);
    }

    @Override
    public MarriageState getMarriageState() {
        return this.getFamilyEntry().getMarriageState();
    }

    @Override
    public Optional<UUID> getSpouseUuid() {
        UUID spouse = this.getFamilyEntry().spouse();
        if (spouse.equals(Util.f_137441_)) {
            return Optional.empty();
        }
        return Optional.of(spouse);
    }

    @Override
    public void marry(Entity spouse) {
        MarriageState state;
        MarriageState marriageState = state = spouse instanceof Player ? MarriageState.MARRIED_TO_PLAYER : MarriageState.MARRIED_TO_VILLAGER;
        if (spouse instanceof ServerPlayer) {
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger((ServerPlayer)spouse, "marriage");
        }
        this.getFamilyEntry().updateMarriage(spouse, state);
    }

    @Override
    public void endMarriage(MarriageState newState) {
        this.getFamilyEntry().updateMarriage(null, newState);
    }

    public GiftSaturation getGiftSaturation() {
        return this.giftSaturation;
    }

    public void readFromNbt(CompoundTag nbt) {
        this.giftSaturation.readFromNbt(nbt.m_128437_("giftSaturationQueue", 8));
    }

    public void writeToNbt(CompoundTag nbt) {
        nbt.m_128365_("giftSaturationQueue", (Tag)this.giftSaturation.toNbt());
    }

    public static interface Predicate
    extends BiPredicate<CompassionateEntity<?>, Entity> {
        @Override
        public boolean test(CompassionateEntity<?> var1, UUID var2);

        @Override
        default public boolean test(CompassionateEntity<?> villager, Entity partner) {
            return partner != null && this.test(villager, partner.m_142081_());
        }

        default public Predicate or(Predicate b) {
            return (villager, partner) -> this.test(villager, partner) || b.test(villager, partner);
        }

        default public Predicate negate() {
            return (villager, partner) -> !this.test(villager, partner);
        }

        default public BiPredicate<VillagerLike<?>, Entity> asConstraint() {
            return (villager, player) -> villager instanceof CompassionateEntity && this.test((CompassionateEntity<?>)((CompassionateEntity)((Object)villager)), (Entity)player);
        }
    }
}

