/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import mca.Config;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Memories;
import mca.entity.ai.Relationship;
import mca.entity.ai.relationship.CompassionateEntity;
import mca.server.world.data.PlayerSaveData;
import mca.server.world.data.Village;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;

public class GreetPlayerTask
extends Behavior<VillagerEntityMCA> {
    private static final int MAX_COOLDOWN = 2000;
    private Optional<? extends Player> target = Optional.empty();
    private int cooldown;
    private boolean talked;

    public GreetPlayerTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.REGISTERED), 600);
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 2000;
        Optional<? extends Player> player = GreetPlayerTask.getPlayer(villager);
        return player.isPresent() && GreetPlayerTask.isWithinSeeRange(villager, player.get());
    }

    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.target = GreetPlayerTask.getPlayer(villager);
        this.target.ifPresent(player -> {
            villager.m_6274_().m_21879_(MemoryModuleType.f_26374_, player);
            BehaviorUtils.m_22595_((LivingEntity)villager, (LivingEntity)player);
            this.talked = false;
        });
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return !this.talked && !villager.getVillagerBrain().isPanicking() && !villager.m_5803_();
    }

    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.target.ifPresent(player -> {
            BehaviorUtils.m_22595_((LivingEntity)villager, (LivingEntity)player);
            if (GreetPlayerTask.isWithinGreetingDistance(villager, player)) {
                Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((Player)player);
                int day = (int)(villager.f_19853_.m_46468_() / 24000L);
                memories.setLastSeen(day);
                String phrase = memories.getHearts() < 0 ? "welcomeFoe" : "welcome";
                villager.sendChatMessage((Player)player, phrase, new Object[]{player.m_7755_()});
                this.talked = true;
                villager.playWelcomeSound();
            } else {
                BehaviorUtils.m_22590_((LivingEntity)villager, (Entity)player, (float)0.55f, (int)2);
            }
        });
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        if (!this.talked && this.target.isPresent()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer(this.target.get());
            memories.setLastSeen(-1);
        }
        this.target = Optional.empty();
        villager.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        villager.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        villager.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    private static Optional<? extends Player> getPlayer(VillagerEntityMCA villager) {
        return villager.f_19853_.m_6907_().stream().filter(p -> GreetPlayerTask.shouldGreet(villager, p)).findFirst();
    }

    private static boolean shouldGreet(VillagerEntityMCA villager, Player player) {
        Optional<Integer> id = PlayerSaveData.get((ServerLevel)player.f_19853_, player.m_142081_()).getLastSeenVillageId();
        Optional<Village> village = villager.getResidency().getHomeVillage();
        if (id.isPresent() && village.isPresent() && id.get().intValue() == village.get().getId()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer(player);
            int day = (int)(villager.f_19853_.m_46468_() / 24000L);
            if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (Entity)player) || Relationship.IS_RELATIVE.test((CompassionateEntity<?>)villager, (Entity)player) || Math.abs(memories.getHearts()) >= Config.getInstance().greetHeartsThreshold) {
                long diff = (long)day - memories.getLastSeen();
                if (diff > (long)Config.getInstance().greetAfterDays && memories.getLastSeen() > 0L) {
                    return true;
                }
                if (diff > 0L) {
                    memories.setLastSeen(day);
                }
            } else {
                memories.setLastSeen(day);
            }
        }
        return false;
    }

    private static boolean isWithinGreetingDistance(VillagerEntityMCA villager, Player player) {
        return villager.m_142538_().m_123314_((Vec3i)player.m_142538_(), 3.0);
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, Player player) {
        return villager.m_142538_().m_123314_((Vec3i)player.m_142538_(), 32.0);
    }
}

