/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.interaction;

import java.util.Optional;
import mca.cobalt.network.NetworkHandler;
import mca.entity.VillagerLike;
import mca.network.s2c.OpenGuiRequest;
import mca.resources.ClothingList;
import mca.resources.HairList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityCommandHandler<T extends Entity> {
    @Nullable
    protected Player interactingPlayer;
    protected final T entity;

    public EntityCommandHandler(T entity) {
        this.entity = entity;
    }

    public Optional<Player> getInteractingPlayer() {
        return Optional.ofNullable(this.interactingPlayer).filter(player -> player.f_36096_ != null);
    }

    public void stopInteracting() {
        Player player;
        if (!((Entity)this.entity).f_19853_.f_46443_ && (player = this.interactingPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_6915_();
        }
        this.interactingPlayer = null;
    }

    public InteractionResult interactAt(Player player, Vec3 pos, @NotNull InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.INTERACT, (Entity)this.entity), serverPlayer);
        }
        this.interactingPlayer = player;
        return InteractionResult.SUCCESS;
    }

    public boolean handle(ServerPlayer player, String command) {
        switch (command) {
            case "clothing.randClothing": {
                ((VillagerLike)this.entity).setClothes(ClothingList.getInstance().getPool((VillagerLike)this.entity).pickOne());
                break;
            }
            case "clothing.prevClothing": {
                ((VillagerLike)this.entity).setClothes(ClothingList.getInstance().getPool((VillagerLike)this.entity).pickNext(((VillagerLike)this.entity).getClothes(), -1));
                break;
            }
            case "clothing.nextClothing": {
                ((VillagerLike)this.entity).setClothes(ClothingList.getInstance().getPool((VillagerLike)this.entity).pickNext(((VillagerLike)this.entity).getClothes(), 1));
                break;
            }
            case "clothing.randHair": {
                ((VillagerLike)this.entity).setHair(HairList.getInstance().pickOne((VillagerLike)this.entity));
                break;
            }
            case "clothing.prevHair": {
                ((VillagerLike)this.entity).setHair(HairList.getInstance().pickNext((VillagerLike)this.entity, ((VillagerLike)this.entity).getHair(), -1));
                break;
            }
            case "clothing.nextHair": {
                ((VillagerLike)this.entity).setHair(HairList.getInstance().pickNext((VillagerLike)this.entity, ((VillagerLike)this.entity).getHair(), 1));
            }
        }
        return false;
    }
}

