/*
 * Decompiled with CFR 0.152.
 */
package mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mca.MCA;
import mca.entity.VillagerLike;
import mca.entity.ai.relationship.AgeState;
import mca.entity.ai.relationship.Gender;
import mca.resources.Resources;
import mca.resources.WeightedPool;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.npc.VillagerProfession;

public class ClothingList
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("skins/clothing");
    private final Map<Gender, ProfessionPool> clothing = new EnumMap<Gender, ProfessionPool>(Gender.class);
    private static ClothingList INSTANCE;

    public static ClothingList getInstance() {
        return INSTANCE;
    }

    public ClothingList() {
        super(Resources.GSON, "skins/clothing");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.clothing.clear();
        data.forEach((id, file) -> {
            Gender gender = Gender.byName(id.m_135815_().split("\\.")[0]);
            if (gender == Gender.UNASSIGNED) {
                MCA.LOGGER.warn("Invalid gender for clothing pool: {}", id);
                return;
            }
            gender.getTransients().map(this::byGender).forEach(pool -> GsonHelper.m_13918_((JsonElement)file, (String)"root").getAsJsonObject().entrySet().forEach(entry -> pool.addToPool(id.m_135827_(), gender, new ResourceLocation((String)entry.getKey()), GsonHelper.m_13927_((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"count"), GsonHelper.m_13820_((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"chance", (float)1.0f))));
        });
    }

    public ProfessionPool byGender(Gender gender) {
        return this.clothing.computeIfAbsent(gender, ProfessionPool::new);
    }

    public WeightedPool<String> getPool(VillagerLike<?> villager) {
        return switch (villager.getAgeState()) {
            case AgeState.BABY, AgeState.TODDLER -> ClothingList.getInstance().byGender(villager.getGenetics().getGender()).byIdentifier(MCA.locate("baby"));
            case AgeState.CHILD, AgeState.TEEN -> ClothingList.getInstance().byGender(villager.getGenetics().getGender()).byIdentifier(MCA.locate("child"));
            default -> this.getPool(villager.getGenetics().getGender(), villager.m_7141_().m_35571_());
        };
    }

    public WeightedPool<String> getPool(Gender gender, VillagerProfession profession) {
        return this.byGender(gender).byProfession(profession);
    }

    public static class ProfessionPool {
        private static final WeightedPool<String> EMPTY = new WeightedPool<String>("");
        private final Map<ResourceLocation, WeightedPool.Mutable<String>> entries = new HashMap<ResourceLocation, WeightedPool.Mutable<String>>();

        ProfessionPool(Gender gender) {
        }

        public void addToPool(String namespace, Gender gender, ResourceLocation profession, int count, float chance) {
            if (count <= 0) {
                return;
            }
            WeightedPool.Mutable pool = this.entries.computeIfAbsent(profession, p -> new WeightedPool.Mutable<String>(""));
            for (int i = 0; i < count; ++i) {
                pool.add(String.format("%s:%s/%s/%d.png", namespace, gender.getStrName(), profession.m_135815_(), i), chance);
            }
        }

        private Optional<WeightedPool<String>> getOptions(VillagerProfession profession) {
            return this.getOptions(Registry.f_122869_.m_7981_((Object)profession));
        }

        private Optional<WeightedPool<String>> getOptions(ResourceLocation id) {
            return Optional.ofNullable((WeightedPool)this.entries.get(Objects.requireNonNull(id)));
        }

        public WeightedPool<String> byProfession(VillagerProfession profession) {
            return this.getOptions(profession).orElseGet(() -> this.getOptions(VillagerProfession.f_35585_).orElse(EMPTY));
        }

        public WeightedPool<String> byIdentifier(ResourceLocation id) {
            return this.getOptions(id).orElseGet(() -> this.getOptions(VillagerProfession.f_35585_).orElse(EMPTY));
        }
    }
}

