/*
 * Decompiled with CFR 0.152.
 */
package mca.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mca.cobalt.network.NetworkHandler;
import mca.network.s2c.OpenGuiRequest;
import mca.server.ServerInteractionManager;
import mca.server.world.data.PlayerSaveData;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class Command {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mca").then(Command.register("help", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::displayHelp)))).then(Command.register("propose").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::propose)))).then(Command.register("accept").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::accept)))).then(Command.register("proposals", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::displayProposal)))).then(Command.register("procreate", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::procreate)))).then(Command.register("separate", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::separate)))).then(Command.register("reject").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::reject)))).then(Command.register("editor", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::editor)))).then(Command.register("mail", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::mail))));
    }

    private static int editor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.VILLAGER_EDITOR, (Entity)((CommandSourceStack)ctx.getSource()).m_81375_()), ((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    private static int mail(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        PlayerSaveData data = PlayerSaveData.get(((CommandSourceStack)ctx.getSource()).m_81372_(), player.m_142081_());
        while (data.hasMail()) {
            player.m_150109_().m_150079_(data.getMail());
        }
        return 0;
    }

    private static int displayHelp(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "PLAYER COMMANDS" + ChatFormatting.DARK_RED + " ---");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca editor" + ChatFormatting.GOLD + " - Choose your genetics and stuff.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca propose <PlayerName>" + ChatFormatting.GOLD + " - Proposes marriage to the given player.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca proposals " + ChatFormatting.GOLD + " - Shows all active proposals.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca accept <PlayerName>" + ChatFormatting.GOLD + " - Accepts the player's marriage request.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca reject <PlayerName>" + ChatFormatting.GOLD + " - Rejects the player's marriage request.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca procreate " + ChatFormatting.GOLD + " - Starts procreation.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca separate " + ChatFormatting.GOLD + " - Ends your marriage.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "GLOBAL COMMANDS" + ChatFormatting.DARK_RED + " ---");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_81375_(), ChatFormatting.WHITE + " /mca help " + ChatFormatting.GOLD + " - Shows this list of commands.");
        return 0;
    }

    private static int propose(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().sendProposal(((CommandSourceStack)ctx.getSource()).m_81375_(), target);
        return 0;
    }

    private static int accept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().acceptProposal(((CommandSourceStack)ctx.getSource()).m_81375_(), target);
        return 0;
    }

    private static int displayProposal(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().listProposals(((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    private static int procreate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().procreate(((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    private static int separate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().endMarriage(((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    private static int reject(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().rejectProposal(((CommandSourceStack)ctx.getSource()).m_81375_(), target);
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name, com.mojang.brigadier.Command<CommandSourceStack> cmd) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(0))).executes(cmd);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name) {
        return Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(0));
    }

    private static void sendMessage(Entity commandSender, String message) {
        commandSender.m_6352_((Component)new TextComponent(ChatFormatting.GOLD + "[MCA] " + ChatFormatting.RESET + message), Util.f_137441_);
    }
}

