/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.accessor.HttpTextureAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.accessor.SkullSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class SkinUtil {
    private static Cache<AbstractTexture, NativeImage> cache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<AbstractTexture, NativeImage>(){

        public void onRemoval(RemovalNotification<AbstractTexture, NativeImage> notification) {
            try {
                ((NativeImage)notification.getValue()).close();
            }
            catch (Exception ex) {
                SkinLayersModBase.LOGGER.error("Error while closing a texture.", (Throwable)ex);
            }
        }
    }).build();

    private static NativeImage getSkinTexture(AbstractClientPlayer player) {
        return SkinUtil.getTexture(player.m_108560_());
    }

    private static NativeImage getTexture(ResourceLocation resourceLocation) {
        try {
            if (Minecraft.m_91087_().m_91098_().m_7165_(resourceLocation)) {
                Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(resourceLocation);
                NativeImage skin = NativeImage.m_85058_((InputStream)resource.m_6679_());
                return skin;
            }
            AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(resourceLocation);
            if (texture == null) {
                return null;
            }
            NativeImage cachedImage = (NativeImage)cache.getIfPresent((Object)texture);
            if (cachedImage != null) {
                try {
                    cachedImage.m_84985_(0, 0);
                    return cachedImage;
                }
                catch (Exception ex) {
                    cache.invalidate((Object)texture);
                }
            }
            if (texture instanceof HttpTextureAccessor) {
                HttpTextureAccessor httpTexture = (HttpTextureAccessor)texture;
                try {
                    NativeImage img = httpTexture.getImage();
                    cache.put((Object)texture, (Object)img);
                    return img;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (texture instanceof DynamicTexture) {
                try {
                    NativeImage img = ((DynamicTexture)texture).m_117991_();
                    img.m_84985_(0, 0);
                    return img;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SkinLayersModBase.LOGGER.warn("Unable to handle skin " + resourceLocation + ". Potentially a conflict with another mod.");
            return null;
        }
        catch (Exception ex) {
            SkinLayersModBase.LOGGER.error("Error while resolving a skin texture.", (Throwable)ex);
            return null;
        }
    }

    public static boolean setup3dLayers(AbstractClientPlayer abstractClientPlayerEntity, PlayerSettings settings, boolean thinArms, PlayerModel<AbstractClientPlayer> model) {
        ResourceLocation skinLocation = abstractClientPlayerEntity.m_108560_();
        if (skinLocation == null) {
            return false;
        }
        if (skinLocation.equals((Object)settings.getCurrentSkin()) && thinArms == settings.hasThinArms()) {
            return settings.getSkinLayers() != null;
        }
        NativeImage skin = SkinUtil.getSkinTexture(abstractClientPlayerEntity);
        if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
            settings.setCurrentSkin(skinLocation);
            settings.setThinArms(thinArms);
            settings.setupHeadLayers(null);
            settings.setupSkinLayers(null);
            return false;
        }
        CustomizableModelPart[] layers = new CustomizableModelPart[5];
        layers[0] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 0, 48, true, 0.0f);
        layers[1] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 0, 32, true, 0.0f);
        if (thinArms) {
            layers[2] = SolidPixelWrapper.wrapBox(skin, 3, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBox(skin, 3, 12, 4, 40, 32, true, -2.5f);
        } else {
            layers[2] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 40, 32, true, -2.5f);
        }
        layers[4] = SolidPixelWrapper.wrapBox(skin, 8, 12, 4, 16, 32, true, -0.8f);
        settings.setupSkinLayers(layers);
        settings.setupHeadLayers(SolidPixelWrapper.wrapBox(skin, 8, 8, 8, 32, 0, false, 0.6f));
        settings.setCurrentSkin(skinLocation);
        settings.setThinArms(thinArms);
        return true;
    }

    public static boolean setup3dLayers(GameProfile gameprofile, SkullSettings settings) {
        if (gameprofile == null) {
            return false;
        }
        Map map = Minecraft.m_91087_().m_91109_().m_118815_(gameprofile);
        MinecraftProfileTexture texture = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
        if (texture == null) {
            return false;
        }
        ResourceLocation resourceLocation = Minecraft.m_91087_().m_91109_().m_118825_(texture, MinecraftProfileTexture.Type.SKIN);
        NativeImage skin = SkinUtil.getTexture(resourceLocation);
        if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
            return false;
        }
        settings.setupHeadLayers(SolidPixelWrapper.wrapBox(skin, 8, 8, 8, 32, 0, false, 0.6f));
        return true;
    }
}

