/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import java.util.List;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.curio.CurioItem;
import net.mindoth.skillcloaks.registries.SkillCloaksItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class DefenceCloakItem
extends CurioItem {
    private static final String TAG_DEFENCE_COOLDOWN = "preventDeath";

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.skillcloaks.defence_cloak"));
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    @SubscribeEvent
    public static void onDamageEvent(LivingDamageEvent event) {
        if (!event.getEntityLiving().f_19853_.f_46443_) {
            LivingEntity player = event.getEntityLiving();
            CompoundTag playerData = player.getPersistentData();
            CompoundTag data = playerData.m_128469_("PlayerPersisted");
            if (event.getAmount() >= event.getEntityLiving().m_21223_() && (CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillCloaksItems.DEFENCE_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent()) && data.m_128451_(TAG_DEFENCE_COOLDOWN) <= 0) {
                event.setAmount(0.0f);
                player.m_21153_(1.0f);
                player.m_21219_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
                player.m_183503_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                data.m_128405_(TAG_DEFENCE_COOLDOWN, 24000);
                playerData.m_128365_("PlayerPersisted", (Tag)data);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (!player.f_19853_.f_46443_) {
            if (player.f_19797_ % 2 == 0 && data.m_128451_(TAG_DEFENCE_COOLDOWN) > 0) {
                data.m_128405_(TAG_DEFENCE_COOLDOWN, data.m_128451_(TAG_DEFENCE_COOLDOWN) - 1);
                playerData.m_128365_("PlayerPersisted", (Tag)data);
            }
            if (data.m_128451_(TAG_DEFENCE_COOLDOWN) == 1) {
                player.m_5661_((Component)new TextComponent("Defence Cloak power recharged"), true);
                player.m_6330_(SoundEvents.f_12616_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (data.m_128451_(TAG_DEFENCE_COOLDOWN) <= 0) {
                data.m_128473_(TAG_DEFENCE_COOLDOWN);
            }
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.getWearer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            CompoundTag data = playerData.m_128469_("PlayerPersisted");
            if (!player.f_19853_.f_46443_ && data.m_128451_(TAG_DEFENCE_COOLDOWN) > 0) {
                int totalSecs = data.m_128451_(TAG_DEFENCE_COOLDOWN) / 20;
                int mins = totalSecs % 3600 / 60;
                int secs = totalSecs % 60;
                if (mins > 0) {
                    player.m_5661_((Component)new TextComponent("Defence Cloak is still on cooldown for: " + mins + "m " + secs + "s"), true);
                } else {
                    player.m_5661_((Component)new TextComponent("Defence Cloak is still on cooldown for: " + secs + "s"), true);
                }
                player.m_6330_(SoundEvents.f_12217_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }
}

