/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.world.level.LevelAccessor;

public class WorldData {
    static final Map<LevelAccessor, WorldData> DATA_MAP = new ConcurrentHashMap<LevelAccessor, WorldData>();
    final SmokeLocations smokeLocations;
    final LevelAccessor level;

    public WorldData(LevelAccessor level) {
        this.level = level;
        this.smokeLocations = new SmokeLocations(level);
    }

    @Nonnull
    public static WorldData getData(LevelAccessor world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            DATA_MAP.put(world, data);
        }
        return data;
    }

    public LevelAccessor getLevel() {
        return this.level;
    }

    public SmokeLocations getSmokeLocations() {
        return this.smokeLocations;
    }
}

