/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.selene.entities.ImprovedFallingBlockEntity;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SackBlockTile;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SackBlock
extends FallingBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_CLOSED = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});
    public static final VoxelShape SHAPE_OPEN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)});
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
        return 12226410;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            worldIn.m_186460_(pos, (Block)this, this.m_7198_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OPEN, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public static boolean canFall(BlockPos pos, LevelAccessor world) {
        return (world.m_46859_(pos.m_7495_()) || SackBlock.m_53241_((BlockState)world.m_8055_(pos.m_7495_()))) && pos.m_123342_() >= world.m_141937_() && !RopeBlock.isSupportingCeiling(pos.m_7494_(), (LevelReader)world);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SackBlockTile) {
            SackBlockTile tile = (SackBlockTile)blockEntity;
            tile.recheckOpen();
            if (SackBlock.canFall(pos, (LevelAccessor)level)) {
                ImprovedFallingBlockEntity entity2 = ImprovedFallingBlockEntity.fall((EntityType)((EntityType)ModRegistry.FALLING_SACK.get()), (Level)level, (BlockPos)pos, (BlockState)state, (boolean)true);
                entity2.f_31944_ = tile.m_187482_();
                entity2.m_149656_(1.0f, 20);
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SackBlockTile(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SackBlockTile) {
            SackBlockTile tile = (SackBlockTile)blockEntity;
            player.m_5893_((MenuProvider)tile);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SackBlockTile) {
            SackBlockTile tile = (SackBlockTile)blockEntity;
            if (!worldIn.f_46443_ && player.m_7500_() && !tile.m_7983_()) {
                CompoundTag compoundTag = new CompoundTag();
                tile.m_183515_(compoundTag);
                ItemStack itemstack = new ItemStack((ItemLike)this);
                if (!compoundTag.m_128456_()) {
                    itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
                }
                if (tile.m_8077_()) {
                    itemstack.m_41714_(tile.m_7770_());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                worldIn.m_7967_((Entity)itementity);
            } else {
                tile.m_59640_(player);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof SackBlockTile) {
            SackBlockTile tile = (SackBlockTile)((Object)object);
            builder = builder.m_78979_(CONTENTS, (context, stackConsumer) -> {
                for (int i = 0; i < tile.m_6643_(); ++i) {
                    stackConsumer.accept(tile.m_8020_(i));
                }
            });
        }
        return super.m_7381_(state, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemstack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SackBlockTile) {
            SackBlockTile tile = (SackBlockTile)blockEntity;
            CompoundTag compoundTag = new CompoundTag();
            tile.m_183515_(compoundTag);
            if (!compoundTag.m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
            }
        }
        return itemstack;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof SackBlockTile) {
            SackBlockTile tile = (SackBlockTile)blockEntity;
            tile.m_58638_(stack.m_41786_());
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPE_OPEN;
        }
        return SHAPE_CLOSED;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            worldIn.m_46717_(pos, state.m_60734_());
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SackBlockTile) {
            SackBlockTile tile = (SackBlockTile)blockEntity;
            int i = 0;
            float f = 0.0f;
            int slots = tile.getUnlockedSlots();
            for (int j = 0; j < slots; ++j) {
                ItemStack itemstack = tile.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                f += (float)itemstack.m_41613_() / (float)Math.min(tile.m_6893_(), itemstack.m_41741_());
                ++i;
            }
            return Mth.m_14143_((float)((f /= (float)slots) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        return blockEntity instanceof MenuProvider ? (MenuProvider)blockEntity : null;
    }

    public void m_142216_(Level level, BlockPos pos, BlockState state, BlockState state1, FallingBlockEntity blockEntity) {
        super.m_142216_(level, pos, state, state1, blockEntity);
        if (!blockEntity.m_20067_()) {
            level.m_5594_(null, pos, state.m_60827_().m_56777_(), SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
        level.m_186460_(pos, (Block)this, this.m_7198_());
    }
}

