/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class WrenchItem
extends Item {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static Method SET_DIRECTION = null;

    public WrenchItem(Item.Properties pProperties) {
        super(pProperties);
        this.attackDamage = 2.5f;
        float pAttackSpeedModifier = -2.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.f_44980_).contains((Object)enchantment);
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_150930_(Items.f_151052_);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pAttacker.f_19853_.m_6269_(null, (Entity)pTarget, SoundEvents.f_11669_, SoundSource.NEUTRAL, 0.5f, 1.8f);
        pStack.m_41622_(1, pAttacker, entity2 -> entity2.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            boolean shiftDown;
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            ItemStack itemstack = context.m_43722_();
            Direction dir = context.m_43719_();
            Optional<Direction> success = BlockUtils.tryRotatingBlockAndConnected(dir, shiftDown = player.m_6144_(), pos, level, context.m_43720_());
            if (success.isPresent()) {
                dir = success.get();
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, itemstack);
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                } else {
                    this.playTurningEffects(pos, shiftDown, dir, level, player);
                }
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (level.f_46443_) {
                level.m_6269_(context.m_43723_(), (Entity)player, SoundEvents.f_144232_, SoundSource.PLAYERS, 1.4f, 0.8f);
            }
        }
        return InteractionResult.FAIL;
    }

    private void playTurningEffects(BlockPos pos, boolean shiftDown, Direction dir, Level level, Player player) {
        if (ClientConfigs.cached.WRENCH_PARTICLES) {
            if (dir == Direction.DOWN) {
                shiftDown = !shiftDown;
            }
            level.m_7106_((ParticleOptions)ModRegistry.ROTATION_TRAIL_EMITTER.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)dir.m_122411_(), 0.71, shiftDown ? 1.0 : -1.0);
        }
        level.m_5594_(player, pos, SoundEvents.f_12017_, SoundSource.BLOCKS, 1.0f, 0.6f);
        level.m_6269_(player, (Entity)player, SoundEvents.f_144231_, SoundSource.PLAYERS, 1.0f, 1.4f);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity2, InteractionHand pUsedHand) {
        if (entity2 instanceof ArmorStand || entity2.m_6095_().getRegistryName().m_135827_().equals("dummmmmmy")) {
            boolean shiftDown = player.m_6144_();
            float inc = 22.5f * (float)(shiftDown ? -1 : 1);
            entity2.m_146922_(entity2.m_146908_() + inc);
            if (player.f_19853_.f_46443_) {
                this.playTurningEffects(entity2.m_20097_().m_7494_(), shiftDown, Direction.UP, player.f_19853_, player);
            }
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(pUsedHand));
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity2) {
        HangingEntity hangingEntity;
        boolean shiftDown = player.m_6144_();
        if (entity2 instanceof HangingEntity && (hangingEntity = (HangingEntity)entity2).m_6350_().m_122434_().m_122479_()) {
            Direction dir = hangingEntity.m_6350_();
            dir = shiftDown ? dir.m_122428_() : dir.m_122427_();
            try {
                if (SET_DIRECTION == null) {
                    SET_DIRECTION = ObfuscationReflectionHelper.findMethod(HangingEntity.class, (String)"setDirection", (Class[])new Class[]{Direction.class});
                }
                SET_DIRECTION.setAccessible(true);
                SET_DIRECTION.invoke((Object)hangingEntity, dir);
                if (player.f_19853_.f_46443_) {
                    this.playTurningEffects(hangingEntity.m_31748_(), shiftDown, Direction.UP, player.f_19853_, player);
                }
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                return true;
            }
            catch (Exception exception) {}
        } else if (entity2 instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity2;
            this.m_6880_(stack, player, (LivingEntity)armorStand, InteractionHand.MAIN_HAND);
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity2);
    }
}

