/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.rope_maker;

import net.dark_roleplay.projectbrazier.feature.registrars.BrazierItems;
import net.dark_roleplay.projectbrazier.util.Inventories;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class RopeMakerBlockEntity
extends BlockEntity {
    private CraftingStage stage = CraftingStage.ADD_MATERIAL;
    private ItemStackHandler itemHandler = new ItemStackHandler(){

        protected void onContentsChanged(int slot) {
            RopeMakerBlockEntity.this.m_6596_();
        }
    };
    private float twistingProgress = 0.0f;

    public RopeMakerBlockEntity(BlockPos pos, BlockState state) {
        super(null, pos, state);
    }

    public CraftingStage getState() {
        return this.stage;
    }

    public float getTwistingProgress() {
        return this.twistingProgress;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public boolean addStrings(Player player) {
        int missingItems = Inventories.doesPlayerHaveEnoughItems(player, Items.f_42401_, 8);
        if (missingItems > 0) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_5661_((Component)new TranslatableComponent("interaction.projectbrazier.rope_maker.not_enough_string", new Object[]{missingItems}), true);
            }
            return false;
        }
        this.itemHandler.insertItem(0, new ItemStack((ItemLike)Items.f_42401_, 8), false);
        if (this.itemHandler.getStackInSlot(0).m_41613_() == 64) {
            this.stage = CraftingStage.TWIST;
            this.m_6596_();
        }
        Inventories.consumeAmountOfItems(player, Items.f_42401_, 8);
        return true;
    }

    public boolean twist() {
        this.twistingProgress += 1.0f;
        if (this.twistingProgress >= 8.0f) {
            this.itemHandler.extractItem(0, 64, false);
            this.stage = CraftingStage.ADD_MATERIAL;
            this.m_6596_();
            Inventories.dropItems(this.f_58857_, this.m_58899_(), new ItemStack((ItemLike)BrazierItems.ROPE.get(), 8));
        }
        return false;
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.itemHandler.deserializeNBT(data.m_128469_("inventory"));
        this.twistingProgress = data.m_128457_("progress");
        this.stage = CraftingStage.valueOf(data.m_128461_("stage"));
    }

    public void m_183515_(CompoundTag data) {
        data.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        data.m_128350_("progress", this.twistingProgress);
        data.m_128359_("stage", this.stage.name());
    }

    public static enum CraftingStage {
        ADD_MATERIAL,
        TWIST;

    }
}

