/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.selective_item_block;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.dark_roleplay.projectbrazier.experimental_features.selective_item_block.SelectiveBlockItem;
import net.dark_roleplay.projectbrazier.experimental_features.selective_item_block.SelectiveBlockItemPacket;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierPackets;
import net.dark_roleplay.projectbrazier.feature_client.registrars.BrazierKeybinds;
import net.dark_roleplay.projectbrazier.util.screens.KeybindRenderer;
import net.dark_roleplay.projectbrazier.util.screens.ScreenTexture;
import net.dark_roleplay.projectbrazier.util.screens.ScreenTextureWrapper;
import net.dark_roleplay.projectbrazier.util.screens.TextureList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SelectiveBlockItemListeners
extends GuiComponent {
    private static Map<SelectiveBlockItem, ScreenTexture[][]> SELECTIVE_TEXTURES = new HashMap<SelectiveBlockItem, ScreenTexture[][]>();

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        GameProfile profile = Minecraft.m_91087_().f_91074_.m_36316_();
        SelectiveBlockItem item = SelectiveBlockItem.getHeldSelectiveBlockItem((Player)Minecraft.m_91087_().f_91074_);
        if (item == null) {
            return;
        }
        int index = item.getCurrentIndex(profile);
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        PoseStack matrixStack = event.getMatrixStack();
        int xOffset = width - 30;
        int yOffset = (height - 70) / 2;
        GlStateManager.m_84525_();
        TextureList.SELECTIVE_BLOCK_ITEMS.render(matrixStack, xOffset, yOffset);
        GlStateManager.m_84519_();
        ScreenTexture[][] selectiveTextures = SELECTIVE_TEXTURES.computeIfAbsent(item, SelectiveBlockItemListeners::createTexturesForItem);
        int prevIndex = index == 0 ? item.getMaxIndex() : index - 1;
        int nextIndex = index == item.getMaxIndex() ? 0 : index + 1;
        selectiveTextures[prevIndex][1].render(matrixStack, xOffset + 11, yOffset + 3);
        selectiveTextures[nextIndex][1].render(matrixStack, xOffset + 11, yOffset + 51);
        selectiveTextures[index][0].render(matrixStack, xOffset + 3, yOffset + 23);
        KeybindRenderer.renderKeybind(BrazierKeybinds.SELECTIVE_BLOCK_ITEM_PREV, matrixStack, Minecraft.m_91087_().f_91062_, xOffset + 7 - KeybindRenderer.getKeybindWidth(BrazierKeybinds.SELECTIVE_BLOCK_ITEM_PREV, Minecraft.m_91087_().f_91062_), yOffset + 6, false);
        KeybindRenderer.renderKeybind(BrazierKeybinds.SELECTIVE_BLOCK_ITEM_NEXT, matrixStack, Minecraft.m_91087_().f_91062_, xOffset + 7 - KeybindRenderer.getKeybindWidth(BrazierKeybinds.SELECTIVE_BLOCK_ITEM_NEXT, Minecraft.m_91087_().f_91062_), yOffset + 51, false);
    }

    @SubscribeEvent
    public static void keyInput(InputEvent.KeyInputEvent event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        SelectiveBlockItem item = SelectiveBlockItem.getHeldSelectiveBlockItem((Player)Minecraft.m_91087_().f_91074_);
        if (item == null) {
            return;
        }
        int index = 0 - (BrazierKeybinds.SELECTIVE_BLOCK_ITEM_PREV.m_90859_() ? 1 : 0) + (BrazierKeybinds.SELECTIVE_BLOCK_ITEM_NEXT.m_90859_() ? 1 : 0);
        if (index != 0) {
            index = SelectiveBlockItemListeners.changeIndex(item, index);
            BrazierPackets.CHANNEL.sendToServer((Object)new SelectiveBlockItemPacket(index));
        }
    }

    @SubscribeEvent
    public static void mouseScroll(InputEvent.MouseScrollEvent event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (!Minecraft.m_91087_().f_91066_.f_92090_.m_90857_()) {
            return;
        }
        SelectiveBlockItem item = SelectiveBlockItem.getHeldSelectiveBlockItem((Player)Minecraft.m_91087_().f_91074_);
        if (item == null) {
            return;
        }
        int index = (int)Math.round(event.getScrollDelta());
        if (index != 0) {
            index = SelectiveBlockItemListeners.changeIndex(item, index);
            BrazierPackets.CHANNEL.sendToServer((Object)new SelectiveBlockItemPacket(index));
            event.setCanceled(true);
        }
    }

    private static int changeIndex(SelectiveBlockItem item, int val) {
        int index = item.getCurrentIndex(Minecraft.m_91087_().f_91074_.m_36316_());
        if (val < 0) {
            index = index == 0 ? item.getMaxIndex() : --index;
        } else if (val > 0) {
            index = index == item.getMaxIndex() ? 0 : ++index;
        }
        return index;
    }

    private static ScreenTexture[][] createTexturesForItem(SelectiveBlockItem item) {
        ScreenTextureWrapper itemTextureSheet = new ScreenTextureWrapper(new ResourceLocation("projectbrazier", "textures/screen/selective_item_blocks/" + item.getRegistryName().m_135815_() + ".png"), (item.getMaxIndex() + 1) * 24, 40);
        ScreenTexture[][] textures = new ScreenTexture[item.getMaxIndex() + 1][];
        for (int i = 0; i <= item.getMaxIndex(); ++i) {
            textures[i] = new ScreenTexture[]{itemTextureSheet.createTexture(i * 24, 0, i * 24 + 24, 24), itemTextureSheet.createTexture(i * 16, 24, i * 16 + 16, 40)};
        }
        return textures;
    }
}

