/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.player_actions.zipline_creation;

import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.WeakHashMap;
import net.dark_roleplay.projectbrazier.feature.blockentities.ZiplineBlockEntity;
import net.dark_roleplay.projectbrazier.feature.blocks.ZiplineAnchorBlock;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierItems;
import net.dark_roleplay.projectbrazier.util.Inventories;
import net.dark_roleplay.projectbrazier.util.math.bezier.BezierCurve;
import net.dark_roleplay.projectbrazier.util.math.vector.VectorUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ZiplineCreationAction {
    private static Map<Player, ZiplineCreationAction> actions = new WeakHashMap<Player, ZiplineCreationAction>();
    private static TagKey<Item> ROPE_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("projectbrazier", "ropes"));
    private Level level;
    private BlockPos initPos;

    public static InteractionResult handleClick(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ZiplineCreationAction action = actions.computeIfAbsent(player, p -> new ZiplineCreationAction());
        InteractionResultHolder<Component> result = action.handleClickInternal(level, pos, player, hand);
        if (result.m_19095_() != null) {
            player.m_5661_((Component)result.m_19095_(), true);
        }
        return result.m_19089_();
    }

    private ZiplineCreationAction() {
    }

    private InteractionResultHolder<Component> handleClickInternal(Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() != BrazierItems.ROPE.get()) {
            return InteractionResultHolder.m_19098_(null);
        }
        if (this.level == null || this.initPos == null || level.m_46472_() != this.level.m_46472_()) {
            if (!level.m_5776_()) {
                this.level = level;
                this.initPos = pos.m_7949_();
            }
            return InteractionResultHolder.m_19092_((Object)new TranslatableComponent("interaction.projectbrazier.zipline.rope.set").m_130940_(ChatFormatting.GREEN), (boolean)level.f_46443_);
        }
        if (!(level.m_8055_(this.initPos).m_60734_() instanceof ZiplineAnchorBlock)) {
            if (!level.m_5776_()) {
                this.level = level;
                this.initPos = pos.m_7949_();
            }
            return InteractionResultHolder.m_19092_((Object)new TranslatableComponent("interaction.projectbrazier.zipline.rope.set").m_130940_(ChatFormatting.GREEN), (boolean)level.f_46443_);
        }
        BlockPos posAHor = new BlockPos(this.initPos.m_123341_(), 0, this.initPos.m_123343_());
        BlockPos posBHor = new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
        double verticalDistance = Math.abs(this.initPos.m_123342_() - pos.m_123342_());
        double horizontalDistance = Math.sqrt(posAHor.m_123331_((Vec3i)posBHor));
        if (horizontalDistance < 7.0) {
            return InteractionResultHolder.m_19100_((Object)new TranslatableComponent("interaction.projectbrazier.zipline.rope.to_short", new Object[]{7}).m_130940_(ChatFormatting.RED));
        }
        if (horizontalDistance > 256.0) {
            return InteractionResultHolder.m_19100_((Object)new TranslatableComponent("interaction.projectbrazier.zipline.rope.to_far", new Object[]{256}).m_130940_(ChatFormatting.RED));
        }
        if (verticalDistance < Math.ceil(horizontalDistance * 0.05)) {
            return InteractionResultHolder.m_19100_((Object)new TranslatableComponent("interaction.projectbrazier.zipline.rope.not_steep_enough").m_130940_(ChatFormatting.RED));
        }
        BlockPos topPos = this.initPos.m_123342_() > pos.m_123342_() ? this.initPos : pos;
        BlockPos bottomPos = this.initPos.m_123342_() > pos.m_123342_() ? pos : this.initPos;
        BlockEntity be = level.m_7702_(topPos);
        if (!(be instanceof ZiplineBlockEntity)) {
            return InteractionResultHolder.m_19100_(null);
        }
        ZiplineBlockEntity zbe = (ZiplineBlockEntity)be;
        Vector3f start = new Vector3f((float)topPos.m_123341_() + 0.5f, (float)topPos.m_123342_() + 0.5f, (float)topPos.m_123343_() + 0.5f);
        Vector3f end = new Vector3f((float)bottomPos.m_123341_() + 0.5f, (float)bottomPos.m_123342_() + 0.5f, (float)bottomPos.m_123343_() + 0.5f);
        Vector3f mid = VectorUtils.lerpVector(start, end, 0.6);
        float yDist = start.m_122260_() - end.m_122260_();
        float xDist = start.m_122239_() - end.m_122239_();
        float zDist = start.m_122269_() - end.m_122269_();
        float distance = (float)Math.sqrt(yDist * yDist + xDist * xDist + zDist * zDist);
        mid.setY(mid.m_122260_() - Math.min(yDist * 0.4f, 7.0f));
        BezierCurve curve = BezierCurve.createGlobal(start, mid, end, (int)distance);
        int requiredRope = (int)Math.ceil(curve.getLength());
        int missing = 0;
        if (!player.m_7500_() && (missing = Inventories.doesPlayerHaveEnoughItems(player, ROPE_ITEMS, requiredRope)) > 0) {
            return InteractionResultHolder.m_19100_((Object)new TranslatableComponent("interaction.projectbrazier.zipline.rope.not_enough_rope", new Object[]{missing}).m_130940_(ChatFormatting.RED));
        }
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19092_(null, (boolean)level.f_46443_);
        }
        if (!player.m_7500_()) {
            Inventories.consumeAmountOfItems(player, (Item)BrazierItems.ROPE.get(), requiredRope);
        }
        zbe.setPositionInitial(start, mid, end, curve);
        level.markAndNotifyBlock(topPos, level.m_46745_(topPos), level.m_8055_(topPos), level.m_8055_(topPos), 3, 0);
        this.initPos = null;
        this.level = null;
        return InteractionResultHolder.m_19092_(null, (boolean)level.f_46443_);
    }
}

