/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.client.model.FramedSlopeSlabModel;
import xfacthd.framedblocks.common.FBContent;

public class FramedElevatedSlopeSlabModel
extends FramedBlockModel {
    private final Direction facing;
    private final boolean top;

    public FramedElevatedSlopeSlabModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad triangle;
        Direction face = quad.m_111306_();
        if (face == this.facing.m_122424_()) {
            BakedQuad slope = FramedSlopeSlabModel.createSlope(quad, this.facing, this.top);
            BakedQuadTransformer.offsetQuadInDir(slope, this.top ? Direction.DOWN : Direction.UP, 0.5f);
            quadMap.get(null).add(slope);
            BakedQuad slab = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slab, this.top, 0.5f)) {
                quadMap.get(face).add(slab);
            }
        } else if ((face == this.facing.m_122427_() || face == this.facing.m_122428_()) && BakedQuadTransformer.createSideTriangleQuad(triangle = ModelUtils.duplicateQuad(quad), face == this.facing.m_122427_(), this.top, 0.5f, 0.5f)) {
            quadMap.get(face).add(triangle);
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedElevatedSlopeSlab.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

