/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.client.model.FramedSlopePanelModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;

public class FramedExtendedSlopePanelModel
extends FramedBlockModel {
    private final Direction facing;
    private final Rotation rotation;
    private final Direction orientation;

    public FramedExtendedSlopePanelModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rotation = (Rotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation) {
            Direction cutDir = this.facing.m_122424_();
            BakedQuad slabQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis && BakedQuadTransformer.createTopBottomQuad(slabQuad, cutDir, 0.5f) || !yAxis && BakedQuadTransformer.createVerticalSideQuad(slabQuad, cutDir, 0.5f)) {
                quadMap.get(face).add(slabQuad);
            }
        } else if (face == this.facing.m_122424_()) {
            BakedQuad slopeQuad = FramedSlopePanelModel.createSlope(quad, this.facing, this.orientation);
            quadMap.get(null).add(slopeQuad);
        } else if (face.m_122434_() != this.facing.m_122434_() && face.m_122434_() != this.orientation.m_122434_()) {
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis) {
                if (BakedQuadTransformer.createVerticalSideTriangleQuad(triQuad, face == this.facing.m_122427_(), this.rotation == Rotation.DOWN, 1.0f, 0.5f)) {
                    quadMap.get(face).add(triQuad);
                }
            } else if (BakedQuadTransformer.createTopBottomTriangleQuad(triQuad, this.facing.m_122424_(), this.rotation == Rotation.RIGHT, 1.0f, 0.5f)) {
                quadMap.get(face).add(triQuad);
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedExtendedSlopePanel.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

