/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;

public class FramedExtendedSlopePanelBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction orientation = ((Rotation)((Object)((Object)state.m_61143_(PropertyHolder.ROTATION)))).withFacing(facing);
        return side == facing || side == orientation.m_122424_();
    };
    private static final Map<Rotation, VoxelShape> SHAPES = (Map)Util.m_137469_(new EnumMap(Rotation.class), map -> {
        for (Rotation rot : Rotation.values()) {
            VoxelShape shape = Shapes.m_83110_((VoxelShape)FramedExtendedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot).m_83216_(0.0, 0.0, 0.5));
            map.put(rot, shape);
        }
    });

    public FramedExtendedSlopePanelBlock() {
        super(BlockType.FRAMED_EXTENDED_SLOPE_PANEL);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.SOLID, FramedProperties.GLOWING, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        Direction side = context.m_43719_();
        Rotation rotation = side == facing.m_122424_() ? Rotation.fromWallCross(context.m_43720_(), side) : Rotation.fromDirection(facing, side);
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return FramedExtendedSlopePanelBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = SHAPES.get(state.m_61143_(PropertyHolder.ROTATION));
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

