/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedPanelBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> state.m_61143_((Property)PropertyHolder.FACING_HOR) == dir;

    public FramedPanelBlock() {
        super(BlockType.FRAMED_PANEL);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction face = context.m_43719_();
        state = face.m_122434_().m_122479_() ? (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)face.m_122424_()) : (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)context.m_8125_());
        return FramedPanelBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ((Block)FBContent.blockFramedPanel.get()).m_5456_()) {
            Direction facing = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            if (hit.m_82434_() == facing.m_122424_()) {
                if (!level.m_5776_()) {
                    BlockEntity blockEntity;
                    BlockState camoState = Blocks.f_50016_.m_49966_();
                    ItemStack camoStack = ItemStack.f_41583_;
                    boolean glowing = false;
                    boolean intangible = false;
                    BlockEntity blockEntity2 = level.m_7702_(pos);
                    if (blockEntity2 instanceof FramedBlockEntity) {
                        FramedBlockEntity be = (FramedBlockEntity)blockEntity2;
                        camoState = be.getCamoState();
                        camoStack = be.getCamoStack();
                        glowing = be.isGlowing();
                        intangible = be.isIntangible(null);
                    }
                    Direction newFacing = facing == Direction.NORTH || facing == Direction.EAST ? facing : facing.m_122424_();
                    BlockState newState = ((Block)FBContent.blockFramedDoublePanel.get()).m_49966_();
                    level.m_46597_(pos, (BlockState)newState.m_61124_((Property)PropertyHolder.FACING_NE, (Comparable)newFacing));
                    SoundType sound = ((Block)FBContent.blockFramedCube.get()).m_49962_(((Block)FBContent.blockFramedCube.get()).m_49966_());
                    level.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        player.m_150109_().m_6596_();
                    }
                    if ((blockEntity = level.m_7702_(pos)) instanceof FramedDoubleBlockEntity) {
                        FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
                        be.setCamo(camoStack, camoState, facing != newFacing);
                        be.setGlowing(glowing);
                        be.setIntangible(intangible);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = FramedPanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
        }
        return builder.build();
    }
}

