/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;

public class FramedFlowerPotBlockEntity
extends FramedBlockEntity {
    public static final ModelProperty<Block> FLOWER_BLOCK = new ModelProperty();
    private Block flowerBlock = Blocks.f_50016_;

    public FramedFlowerPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedFlowerPot.get(), pos, state);
    }

    public void setFlowerBlock(Block flowerBlock) {
        if (flowerBlock != this.flowerBlock) {
            this.flowerBlock = flowerBlock;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean hasFlowerBlock() {
        return this.flowerBlock != Blocks.f_50016_;
    }

    public Block getFlowerBlock() {
        return this.flowerBlock;
    }

    @Override
    public void addCamoDrops(List<ItemStack> drops) {
        super.addCamoDrops(drops);
        if (this.flowerBlock != Blocks.f_50016_) {
            drops.add(new ItemStack((ItemLike)this.flowerBlock));
        }
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128359_("flower", this.flowerBlock.getRegistryName().toString());
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        boolean update;
        Block flower = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("flower")));
        boolean bl = update = flower != this.flowerBlock;
        if (update) {
            this.flowerBlock = flower;
            this.getModelDataInternal().setData(FLOWER_BLOCK, flower);
        }
        return super.readFromDataPacket(nbt) || update;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128359_("flower", this.flowerBlock.getRegistryName().toString());
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        Block flower = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("flower")));
        if (flower != this.flowerBlock) {
            this.flowerBlock = flower;
            this.getModelDataInternal().setData(FLOWER_BLOCK, flower);
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128359_("flower", this.flowerBlock.getRegistryName().toString());
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.flowerBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("flower")));
    }
}

