/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;

public class PanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_PANEL -> PanelSkipPredicate.testAgainstPanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> PanelSkipPredicate.testAgainstDoublePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> PanelSkipPredicate.testAgainstPillar(level, pos, dir, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> PanelSkipPredicate.testAgainstEdge(level, pos, dir, adjState, side);
                case BlockType.FRAMED_STAIRS -> PanelSkipPredicate.testAgainstStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> PanelSkipPredicate.testAgainstDoubleStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> PanelSkipPredicate.testAgainstVerticalStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> PanelSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> PanelSkipPredicate.testAgainstHalfStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> PanelSkipPredicate.testAgainstSlopePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> PanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> PanelSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> PanelSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.m_122424_()) {
            return false;
        }
        return dir == adjState.m_61143_((Property)PropertyHolder.FACING_HOR) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        return (dir == adjDir || dir == adjDir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (adjDir != dir) {
            return false;
        }
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == Direction.UP && !adjTop || side == Direction.DOWN && adjTop) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && adjTop || side == Direction.DOWN && !adjTop) {
            return adjShape == StairsShape.STRAIGHT && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (dir.m_122434_() != adjDir.m_122434_()) {
            return false;
        }
        if (side == Direction.UP && adjTop || side == Direction.DOWN && !adjTop) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return adjType == StairsType.VERTICAL && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir.m_122428_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side.m_122434_() == dir.m_122434_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (adjRight && adjDir == dir.m_122428_() || !adjRight && adjDir == dir.m_122427_()) {
            if (Utils.isY(side)) {
                return side == Direction.DOWN == adjTop && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            return side == adjDir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION))).withFacing(adjDir);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side.m_122434_() == dir.m_122434_() || side != adjRotDir) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side.m_122434_() == dir.m_122434_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION))).withFacing(adjDir);
        return adjDir == dir && adjRotDir == side.m_122424_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION))).withFacing(adjDir);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side.m_122434_() == dir.m_122434_() || side.m_122434_() != adjRotDir.m_122434_()) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION))).withFacing(adjDir);
        if (side.m_122434_() == dir.m_122434_() || side.m_122434_() != adjRotDir.m_122434_()) {
            return false;
        }
        if (adjDir == dir && side == adjRotDir.m_122424_() || adjDir == dir.m_122424_() && side == adjRotDir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }
}

