/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;

public class VerticalStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType type = (StairsType)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (type == StairsType.VERTICAL && (side == dir || side == dir.m_122428_())) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            return switch (blockType) {
                case BlockType.FRAMED_VERTICAL_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_STAIRS -> VerticalStairsSkipPredicate.testAgainstStairs(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_PANEL -> VerticalStairsSkipPredicate.testAgainstPanel(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> VerticalStairsSkipPredicate.testAgainstDoublePanel(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> VerticalStairsSkipPredicate.testAgainstCorner(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> VerticalStairsSkipPredicate.testAgainstPillar(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> VerticalStairsSkipPredicate.testAgainstEdge(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> VerticalStairsSkipPredicate.testAgainstHalfStairs(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstSlopePanel(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (!type.isBottom() && !adjType.isTop() && side == Direction.DOWN || !type.isTop() && !adjType.isBottom() && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (!type.isBottom() && side == Direction.DOWN || !type.isTop() && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        if (dir == adjDir.m_122424_() && (side == dir.m_122424_() || side == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        boolean adjBottom;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean bl = adjBottom = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM;
        if (type == StairsType.VERTICAL && (side == Direction.UP && !adjBottom || side == Direction.DOWN && adjBottom)) {
            StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
            if (adjDir == dir && adjShape == StairsShape.INNER_LEFT || adjDir == dir.m_122428_() && adjShape == StairsShape.INNER_RIGHT) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
        } else if (type.isTop() == adjBottom && (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        if (side == dir.m_122427_() && (adjDir == dir || adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir.m_122424_() && (adjDir == dir.m_122428_() || adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir.m_122428_(), dir.m_122428_());
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type == StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if ((Utils.isY(side) || side == dir.m_122424_() || side == dir.m_122427_()) && type.isTop() != adjTop && dir == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (type == StairsType.VERTICAL ? (side == dir.m_122427_() || side == dir.m_122424_()) && adjDir == dir : Utils.isY(side) && side == Direction.UP == type.isTop() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type == StairsType.VERTICAL || Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_()) {
            return adjTop != type.isTop() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (type == StairsType.VERTICAL) {
            if (!adjRight && adjDir == dir && side == dir.m_122424_() || adjRight && adjDir == dir.m_122428_() && side == dir.m_122427_()) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
        } else if (adjTop != type.isTop() && (adjRight && adjDir == dir && side == dir.m_122428_() || !adjRight && adjDir == dir.m_122428_() && side == dir)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (!Utils.isY(side) || side == Direction.UP && type == StairsType.TOP_CORNER || side == Direction.DOWN && type == StairsType.BOTTOM_CORNER) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjDir != dir || adjTop != (side == Direction.DOWN)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.m_122424_() && side != dir.m_122427_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (!adjFront && (adjDir == dir && adjRot == Rotation.RIGHT || adjDir == dir.m_122428_() && adjRot == Rotation.LEFT)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (adjFront && (adjDir == dir.m_122424_() && adjRot == Rotation.LEFT || adjDir == dir.m_122427_() && adjRot == Rotation.RIGHT)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.m_122424_() && side != dir.m_122427_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == dir.m_122424_() && adjDir == dir.m_122428_() && adjRot == Rotation.RIGHT) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (side == dir.m_122427_() && adjDir == dir && adjRot == Rotation.LEFT) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.m_122424_() && side != dir.m_122427_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (adjRot.isVertical()) {
            return false;
        }
        if (!(adjFront || adjDir != dir && adjDir != dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (adjFront && (adjDir == dir.m_122424_() || adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.m_122424_() && side != dir.m_122427_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir.m_122434_() == dir.m_122434_() && adjRot == Rotation.LEFT) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (adjDir.m_122434_() == dir.m_122427_().m_122434_() && adjRot == Rotation.RIGHT) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }
}

