/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import top.theillusivec4.comforts.ComfortsMod;

public class ComfortsBaseBlock
extends BedBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Field SLEEP_TIMER = ObfuscationReflectionHelper.findField(Player.class, (String)"f_36110_");
    private final BedType type;

    public ComfortsBaseBlock(BedType type, DyeColor colorIn, BlockBehaviour.Properties properties) {
        super(colorIn, properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)f_49441_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_((Property)f_49440_) != BedPart.HEAD && !(state = worldIn.m_8055_(pos = pos.m_142300_((Direction)state.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!ComfortsBaseBlock.m_49488_((Level)worldIn)) {
            worldIn.m_7471_(pos, false);
            BlockPos blockpos = pos.m_142300_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (worldIn.m_8055_(blockpos).m_60713_((Block)this)) {
                worldIn.m_7471_(blockpos, false);
            }
            worldIn.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)f_49441_)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(worldIn, pos)) {
                player.m_5661_((Component)new TranslatableComponent("block.comforts." + this.type.name + ".occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ComfortsBaseBlock.trySleep((ServerPlayer)player, pos).ifLeft(result -> {
                if (result != null) {
                    player.m_5661_(switch (result) {
                        case Player.BedSleepingProblem.NOT_POSSIBLE_NOW -> this.type == BedType.HAMMOCK ? new TranslatableComponent("block.comforts." + this.type.name + ".no_sleep") : new TranslatableComponent("block.minecraft.bed.no_sleep");
                        case Player.BedSleepingProblem.TOO_FAR_AWAY -> new TranslatableComponent("block.comforts." + this.type.name + ".too_far_away");
                        default -> result.m_36423_();
                    }, true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public static Either<Player.BedSleepingProblem, Unit> trySleep(ServerPlayer playerEntity, BlockPos at) {
        Optional<BlockPos> optAt = Optional.of(at);
        Player.BedSleepingProblem ret = ForgeEventFactory.onPlayerSleepInBed((Player)playerEntity, optAt);
        if (ret != null) {
            return Either.left((Object)ret);
        }
        Direction direction = (Direction)playerEntity.f_19853_.m_8055_(at).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (!playerEntity.m_5803_() && playerEntity.m_6084_()) {
            if (!playerEntity.f_19853_.m_6042_().m_63956_()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            if (!ComfortsBaseBlock.bedInRange(playerEntity, at, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.TOO_FAR_AWAY);
            }
            if (ComfortsBaseBlock.bedBlocked(playerEntity, at, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((Player)playerEntity, optAt)) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            if (!playerEntity.m_7500_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3 vector3d = Vec3.m_82539_((Vec3i)at);
                List list = playerEntity.f_19853_.m_6443_(Monster.class, new AABB(vector3d.m_7096_() - 8.0, vector3d.m_7098_() - 5.0, vector3d.m_7094_() - 8.0, vector3d.m_7096_() + 8.0, vector3d.m_7098_() + 5.0, vector3d.m_7094_() + 8.0), p_241146_1_ -> p_241146_1_.m_6935_((Player)playerEntity));
                if (!list.isEmpty()) {
                    return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
                }
            }
            playerEntity.m_5802_(at);
            try {
                SLEEP_TIMER.setInt(playerEntity, 0);
            }
            catch (IllegalAccessException e) {
                ComfortsMod.LOGGER.error("Error setting sleep timer!");
            }
            playerEntity.m_36220_(Stats.f_12969_);
            CriteriaTriggers.f_10583_.m_53645_(playerEntity);
            ((ServerLevel)playerEntity.f_19853_).m_8878_();
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
    }

    private static boolean bedInRange(ServerPlayer playerEntity, BlockPos p_241147_1_, Direction p_241147_2_) {
        if (p_241147_2_ == null) {
            return false;
        }
        return ComfortsBaseBlock.isReachableBedBlock(playerEntity, p_241147_1_) || ComfortsBaseBlock.isReachableBedBlock(playerEntity, p_241147_1_.m_142300_(p_241147_2_.m_122424_()));
    }

    private static boolean isReachableBedBlock(ServerPlayer playerEntity, BlockPos p_241158_1_) {
        Vec3 vector3d = Vec3.m_82539_((Vec3i)p_241158_1_);
        return Math.abs(playerEntity.m_20185_() - vector3d.m_7096_()) <= 3.0 && Math.abs(playerEntity.m_20186_() - vector3d.m_7098_()) <= 2.0 && Math.abs(playerEntity.m_20189_() - vector3d.m_7094_()) <= 3.0;
    }

    private static boolean bedBlocked(ServerPlayer playerEntity, BlockPos p_241156_1_, Direction p_241156_2_) {
        BlockPos blockpos = p_241156_1_.m_7494_();
        return ComfortsBaseBlock.isAbnormalCube(playerEntity.f_19853_, blockpos) || ComfortsBaseBlock.isAbnormalCube(playerEntity.f_19853_, blockpos.m_142300_(p_241156_2_.m_122424_()));
    }

    private static boolean isAbnormalCube(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60828_((BlockGetter)world, pos);
    }

    private boolean kickVillagerOutOfBed(Level p_226861_1_, BlockPos p_226861_2_) {
        List list = p_226861_1_.m_6443_(Villager.class, new AABB(p_226861_2_), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public void m_5707_(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!worldIn.f_46443_ && player.m_7500_() && (bedpart = (BedPart)state.m_61143_((Property)f_49440_)) == BedPart.FOOT && (blockstate = worldIn.m_8055_(blockpos = pos.m_142300_(ComfortsBaseBlock.getDirectionToOther(bedpart, (Direction)state.m_61143_((Property)f_54117_))))).m_60734_() == this && blockstate.m_61143_((Property)f_49440_) == BedPart.HEAD) {
            if (((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                worldIn.m_7731_(blockpos, Blocks.f_49990_.m_49966_(), 35);
            } else {
                worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            }
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        worldIn.m_5898_(player, 2001, pos, ComfortsBaseBlock.m_49956_((BlockState)state));
        if (state.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)player, (boolean)false);
        }
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
        super.m_7926_(builder);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

