/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities.grapplehook;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.config.GrappleConfigUtils;
import com.yyon.grapplinghook.entities.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.network.GrappleAttachMessage;
import com.yyon.grapplinghook.network.GrappleAttachPosMessage;
import com.yyon.grapplinghook.server.ServerControllerManager;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class GrapplehookEntity
extends ThrowableItemProjectile
implements IEntityAdditionalSpawnData {
    public Entity shootingEntity = null;
    public int shootingEntityID;
    private boolean firstAttach = false;
    public Vec thisPos;
    public boolean rightHand = true;
    public boolean attached = false;
    public double pull;
    public double taut = 1.0;
    public boolean ignoreFrustumCheck = true;
    public boolean isDouble = false;
    public double r;
    public SegmentHandler segmentHandler = null;
    public GrappleCustomization customization = null;
    public Vec prevPos = null;
    public boolean foundBlock = false;
    public boolean wasInAir = false;
    public BlockPos magnetBlock = null;
    public Vec attach_dir = null;

    public GrapplehookEntity(EntityType<? extends GrapplehookEntity> type, Level world) {
        super(type, world);
        this.segmentHandler = new SegmentHandler(this.f_19853_, this, Vec.positionVec((Entity)this), Vec.positionVec((Entity)this));
        this.customization = new GrappleCustomization();
    }

    public GrapplehookEntity(Level world, LivingEntity shooter, boolean righthand, GrappleCustomization customization, boolean isdouble) {
        super(CommonSetup.grapplehookEntityType, shooter.m_20182_().f_82479_, shooter.m_20182_().f_82480_ + (double)shooter.m_20192_(), shooter.m_20182_().f_82481_, world);
        this.shootingEntity = shooter;
        this.shootingEntityID = this.shootingEntity.m_142049_();
        this.isDouble = isdouble;
        Vec pos = Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.m_20192_(), 0.0));
        this.segmentHandler = new SegmentHandler(this.f_19853_, this, new Vec(pos), new Vec(pos));
        this.customization = customization;
        this.r = customization.maxlen;
        this.rightHand = righthand;
    }

    public void writeSpawnData(FriendlyByteBuf data) {
        data.writeInt(this.shootingEntity != null ? this.shootingEntity.m_142049_() : 0);
        data.writeBoolean(this.rightHand);
        data.writeBoolean(this.isDouble);
        if (this.customization == null) {
            System.out.println("error: customization null");
        }
        this.customization.writeToBuf((ByteBuf)data);
    }

    public void readSpawnData(FriendlyByteBuf data) {
        this.shootingEntityID = data.readInt();
        this.shootingEntity = this.f_19853_.m_6815_(this.shootingEntityID);
        this.rightHand = data.readBoolean();
        this.isDouble = data.readBoolean();
        this.customization = new GrappleCustomization();
        this.customization.readFromBuf((ByteBuf)data);
    }

    public void m_8097_() {
        super.m_8097_();
    }

    public void removeServer() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        this.shootingEntityID = 0;
    }

    public float getVelocity() {
        return (float)this.customization.throwspeed;
    }

    public void m_8119_() {
        if (this.shootingEntityID == 0 || this.shootingEntity == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.firstAttach) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.firstAttach = false;
            super.m_6034_(this.thisPos.x, this.thisPos.y, this.thisPos.z);
        }
        if (this.attached) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.shootingEntity != null && !this.attached) {
            double newdist;
            Vec farthest;
            if (this.segmentHandler.hookPastBend(this.r)) {
                System.out.println("around bend");
                farthest = this.segmentHandler.getFarthest();
                this.serverAttach(this.segmentHandler.getBendBlock(1), farthest, null);
            }
            if (!this.customization.phaserope) {
                this.segmentHandler.update(Vec.positionVec((Entity)this), Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.m_20192_(), 0.0)), this.r, true);
                if (this.customization.sticky && this.segmentHandler.segments.size() > 2) {
                    int bendnumber = this.segmentHandler.segments.size() - 2;
                    Vec closest = this.segmentHandler.segments.get(bendnumber);
                    BlockPos blockpos = this.segmentHandler.getBendBlock(bendnumber);
                    for (int i = 1; i <= bendnumber; ++i) {
                        this.segmentHandler.removeSegment(1);
                    }
                    this.serverAttach(blockpos, closest, null);
                }
            } else {
                this.segmentHandler.updatePos(Vec.positionVec((Entity)this), Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.m_20192_(), 0.0)), this.r);
            }
            farthest = this.segmentHandler.getFarthest();
            double distToFarthest = this.segmentHandler.getDistToFarthest();
            Vec ropevec = Vec.positionVec((Entity)this).sub(farthest);
            double d = ropevec.length();
            if (this.customization.reelin && this.shootingEntity.m_6047_() && (newdist = d + distToFarthest - 0.4) > 1.0 && newdist <= this.customization.maxlen) {
                this.r = newdist;
            }
            if (d + distToFarthest > this.r) {
                Vec motion = Vec.motionVec((Entity)this);
                if (motion.dot(ropevec) > 0.0) {
                    motion = motion.removeAlong(ropevec);
                }
                this.setVelocityActually(motion.x, motion.y, motion.z);
                ropevec.changeLen_ip(this.r - distToFarthest);
                Vec newpos = ropevec.add(farthest);
                this.m_6034_(newpos.x, newpos.y, newpos.z);
            }
        }
        if (!this.attached && this.customization.attract && Vec.positionVec((Entity)this).sub(Vec.positionVec(this.shootingEntity)).length() > this.customization.attractradius) {
            if (this.shootingEntity == null) {
                return;
            }
            if (!this.foundBlock && !this.f_19853_.f_46443_) {
                Vec playerpos = Vec.positionVec(this.shootingEntity);
                Vec pos = Vec.positionVec((Entity)this);
                if (this.magnetBlock == null && this.prevPos != null) {
                    HashMap<BlockPos, Boolean> checkedset = new HashMap<BlockPos, Boolean>();
                    Vec vector = pos.sub(this.prevPos);
                    if (vector.length() > 0.0) {
                        Vec normvector = vector.normalize();
                        int i = 0;
                        while ((double)i < vector.length()) {
                            double dist = this.prevPos.sub(playerpos).length();
                            int radius = (int)dist / 4;
                            BlockPos found = this.check(this.prevPos, checkedset);
                            if (found != null) {
                                Vec distvec = new Vec(found.m_123341_(), found.m_123342_(), found.m_123343_());
                                distvec.sub_ip(this.prevPos);
                                if (distvec.length() < (double)radius) {
                                    this.m_20343_(this.prevPos.x, this.prevPos.y, this.prevPos.z);
                                    pos = this.prevPos;
                                    this.magnetBlock = found;
                                    break;
                                }
                            } else {
                                this.wasInAir = true;
                            }
                            this.prevPos.add_ip(normvector);
                            ++i;
                        }
                    }
                }
                if (this.magnetBlock != null) {
                    BlockState blockstate = this.f_19853_.m_8055_(this.magnetBlock);
                    VoxelShape BB = blockstate.m_60812_((BlockGetter)this.f_19853_, this.magnetBlock);
                    Vec blockvec = new Vec((double)this.magnetBlock.m_123341_() + (BB.m_83297_(Direction.Axis.X) + BB.m_83288_(Direction.Axis.X)) / 2.0, (double)this.magnetBlock.m_123342_() + (BB.m_83297_(Direction.Axis.Y) + BB.m_83288_(Direction.Axis.Y)) / 2.0, (double)this.magnetBlock.m_123343_() + (BB.m_83297_(Direction.Axis.Z) + BB.m_83288_(Direction.Axis.Z)) / 2.0);
                    Vec newvel = blockvec.sub(pos);
                    double l = newvel.length();
                    newvel.changeLen(this.getVelocity());
                    this.m_20334_(newvel.x, newvel.y, newvel.z);
                    if (l < 0.2) {
                        this.serverAttach(this.magnetBlock, blockvec, Direction.UP);
                    }
                }
                this.prevPos = pos;
            }
        }
    }

    public void setVelocityActually(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = Math.sqrt(x * x + z * z);
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.29577951308232));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.29577951308232));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public boolean m_6783_(double p_70112_1_) {
        return true;
    }

    public boolean m_6000_(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    public AABB m_6921_() {
        if (this.shootingEntity == null) {
            return super.m_6921_();
        }
        return this.segmentHandler.getBoundingBox(Vec.positionVec((Entity)this), Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.m_20192_(), 0.0)));
    }

    protected void m_6532_(HitResult movingobjectposition) {
        if (!this.f_19853_.f_46443_) {
            Block block;
            BlockPos blockpos;
            if (this.attached) {
                return;
            }
            if (this.shootingEntity == null || this.shootingEntityID == 0) {
                return;
            }
            if (movingobjectposition == null) {
                return;
            }
            Vec vec3d = Vec.positionVec((Entity)this);
            Vec vec3d1 = vec3d.add(Vec.motionVec((Entity)this));
            if (movingobjectposition instanceof EntityHitResult && !GrappleConfig.getConf().grapplinghook.other.hookaffectsentities) {
                this.m_6532_((HitResult)GrapplemodUtils.rayTraceBlocks(this.f_19853_, vec3d, vec3d1));
                return;
            }
            BlockHitResult blockhit = null;
            if (movingobjectposition instanceof BlockHitResult) {
                blockhit = (BlockHitResult)movingobjectposition;
            }
            if (blockhit != null && (blockpos = blockhit.m_82425_()) != null && GrappleConfigUtils.breaksBlock(block = this.f_19853_.m_8055_(blockpos).m_60734_())) {
                this.f_19853_.m_46961_(blockpos, true);
                this.m_6532_((HitResult)GrapplemodUtils.rayTraceBlocks(this.f_19853_, vec3d, vec3d1));
                return;
            }
            if (movingobjectposition instanceof EntityHitResult) {
                EntityHitResult entityHit = (EntityHitResult)movingobjectposition;
                Entity entity = entityHit.m_82443_();
                if (entity == this.shootingEntity || entity == null) {
                    return;
                }
                Vec playerpos = Vec.positionVec(this.shootingEntity);
                Vec entitypos = Vec.positionVec(entity);
                Vec yank = playerpos.sub(entitypos).mult(0.4);
                yank.y = Math.min(yank.y, 2.0);
                Vec newmotion = Vec.motionVec(entity).add(yank);
                entity.m_20256_(newmotion.toVec3d());
                this.removeServer();
                return;
            }
            if (blockhit != null) {
                blockpos = blockhit.m_82425_();
                Vec vec3 = new Vec(movingobjectposition.m_82450_());
                this.serverAttach(blockpos, vec3, blockhit.m_82434_());
            } else {
                System.out.println("unknown impact?");
            }
        }
    }

    protected Item m_7881_() {
        return CommonSetup.grapplingHookItem;
    }

    public void serverAttach(BlockPos blockpos, Vec pos, Direction sideHit) {
        Block block;
        if (this.attached) {
            return;
        }
        if (this.shootingEntity == null || this.shootingEntityID == 0) {
            return;
        }
        this.attached = true;
        if (blockpos != null && !GrappleConfigUtils.attachesBlock(block = this.f_19853_.m_8055_(blockpos).m_60734_())) {
            this.removeServer();
            return;
        }
        Vec vec3 = Vec.positionVec((Entity)this);
        vec3.add_ip(Vec.motionVec((Entity)this));
        if (pos != null) {
            vec3 = pos;
            this.m_20343_(vec3.x, vec3.y, vec3.z);
        }
        Vec curpos = Vec.positionVec((Entity)this);
        if (sideHit == Direction.DOWN) {
            curpos.y -= 0.3;
        } else if (sideHit == Direction.WEST) {
            curpos.x -= 0.05;
        } else if (sideHit == Direction.NORTH) {
            curpos.z -= 0.05;
        } else if (sideHit == Direction.SOUTH) {
            curpos.z += 0.05;
        } else if (sideHit == Direction.EAST) {
            curpos.x += 0.05;
        } else if (sideHit == Direction.UP) {
            curpos.y += 0.05;
        }
        curpos.setPos((Entity)this);
        this.m_20334_(0.0, 0.0, 0.0);
        this.thisPos = Vec.positionVec((Entity)this);
        this.firstAttach = true;
        ServerControllerManager.attached.add(this.shootingEntityID);
        GrapplemodUtils.sendToCorrectClient(new GrappleAttachMessage(this.m_142049_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, this.getControlId(), this.shootingEntityID, blockpos, this.segmentHandler.segments, this.segmentHandler.segmentTopSides, this.segmentHandler.segmentBottomSides, this.customization), this.shootingEntityID, this.f_19853_);
        GrappleAttachPosMessage msg = new GrappleAttachPosMessage(this.m_142049_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
        CommonSetup.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(new BlockPos(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_))), (Object)msg);
    }

    public void clientAttach(double x, double y, double z) {
        this.setAttachPos(x, y, z);
        if (this.shootingEntity instanceof Player) {
            ClientProxyInterface.proxy.resetLauncherTime(this.shootingEntityID);
        }
    }

    protected float m_7139_() {
        if (this.attached) {
            return 0.0f;
        }
        return (float)this.customization.hookgravity * 0.1f;
    }

    public int getControlId() {
        return GrapplemodUtils.GRAPPLEID;
    }

    public void setAttachPos(double x, double y, double z) {
        this.m_20343_(x, y, z);
        this.m_20334_(0.0, 0.0, 0.0);
        this.firstAttach = true;
        this.attached = true;
        this.thisPos = new Vec(x, y, z);
    }

    public BlockPos check(Vec p, HashMap<BlockPos, Boolean> checkedset) {
        int radius = (int)Math.floor(this.customization.attractradius);
        BlockPos closestpos = null;
        double closestdist = 0.0;
        for (int x = (int)p.x - radius; x <= (int)p.x + radius; ++x) {
            for (int y = (int)p.y - radius; y <= (int)p.y + radius; ++y) {
                for (int z = (int)p.z - radius; z <= (int)p.z + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos == null || !this.hasBlock(pos, checkedset)) continue;
                    Vec distvec = new Vec(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    distvec.sub_ip(p);
                    double dist = distvec.length();
                    if (closestpos != null && !(dist < closestdist)) continue;
                    closestpos = pos;
                    closestdist = dist;
                }
            }
        }
        return closestpos;
    }

    public boolean hasBlock(BlockPos pos, HashMap<BlockPos, Boolean> checkedset) {
        if (!checkedset.containsKey(pos)) {
            VoxelShape BB;
            boolean isblock = false;
            BlockState blockstate = this.f_19853_.m_8055_(pos);
            Block b = blockstate.m_60734_();
            if (GrappleConfigUtils.attachesBlock(b) && !blockstate.m_60795_() && (BB = blockstate.m_60812_((BlockGetter)this.f_19853_, pos)) != null && !BB.m_83281_()) {
                isblock = true;
            }
            checkedset.put(pos, isblock);
            return isblock;
        }
        return checkedset.get(pos);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)this.m_7881_());
    }
}

