/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.logo;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.util.Strings;
import shadows.menu.ExtendedMenuScreen;
import shadows.menu.buttons.AnchorPoint;
import shadows.placebo.config.Configuration;

public class Logo {
    protected ResourceLocation texture;
    protected final int xOff;
    protected final int yOff;
    protected final int width;
    protected final int height;
    protected final int texWidth;
    protected final int texHeight;
    protected final AnchorPoint anchor;

    public Logo(int xOff, int yOff, int width, int height, int texWidth, int texHeight, ResourceLocation texture, AnchorPoint anchor) {
        this.xOff = xOff;
        this.yOff = yOff;
        this.width = width;
        this.height = height;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.texture = texture;
        this.anchor = anchor;
    }

    public void draw(ExtendedMenuScreen screen, PoseStack stack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        stack.m_85836_();
        stack.m_85837_((double)this.anchor.getX(screen), (double)this.anchor.getY(screen), 0.0);
        stack.m_85841_((float)this.width / (float)this.texWidth, (float)this.height / (float)this.texHeight, 1.0f);
        GuiComponent.m_93133_((PoseStack)stack, (int)this.xOff, (int)this.yOff, (float)0.0f, (float)0.0f, (int)this.texWidth, (int)this.texHeight, (int)this.texWidth, (int)this.texHeight);
        stack.m_85849_();
        RenderSystem.m_69482_();
    }

    @Nullable
    public static Logo read(Configuration cfg) {
        String tex = cfg.getString("Texture Path", "logo", "packmenu:textures/gui/logo.png", "The location of the logo texture.  Must be a png file.  Should contain the extension.");
        int xOff = cfg.getInt("X Offset", "logo", -650, -500000, 500000, "The X offset of the logo.");
        int yOff = cfg.getInt("Y Offset", "logo", 0, -500000, 500000, "The Y offset of the logo.");
        int width = cfg.getInt("Width", "logo", 100, 0, 500000, "The width of the logo.");
        int height = cfg.getInt("Height", "logo", 100, 0, 500000, "The height of the logo.");
        int texWidth = cfg.getInt("Texture Width", "logo", 300, 0, 500000, "The width of the logo's texture.");
        int texHeight = cfg.getInt("Texture Height", "logo", 300, 0, 500000, "The height of the logo's texture.");
        AnchorPoint anchor = AnchorPoint.valueOf(cfg.getString("Anchor Point", "logo", "DEFAULT_LOGO", "The anchor point of the logo.  The types of anchor points are available on the wiki."));
        if (!cfg.getBoolean("Enable Logo", "logo", true, "If the logo is enabled or not.")) {
            return null;
        }
        if (Strings.isBlank((String)tex)) {
            return null;
        }
        return new Logo(xOff, yOff, width, height, texWidth, texHeight, new ResourceLocation(tex), anchor);
    }
}

